/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.utils.Severity;

public class Normalize
extends ToneEffect {
    private static final int SAMPLING_STEPS = 767;
    private static final double NORMAL_LEVEL = Math.sqrt(0.5);
    private double correction;

    public Normalize() {
        super("music.effect.normalize", "Normalize level to 0 dB");
    }

    @Override
    protected boolean isModified() {
        return false;
    }

    @Override
    protected void updateParameters() {
    }

    @Override
    protected Tone createTranform(Tone source) {
        double period = source.getPeriod();
        double energy = 0.0;
        double lastPos = 0.0;
        int i = 0;
        while (i < 767) {
            double pos = (double)(i + 1) * period / 767.0;
            double sample = source.getSample(-1.0, lastPos, pos);
            energy += sample * sample;
            lastPos = pos;
            ++i;
        }
        energy = Math.sqrt(energy / 767.0);
        this.correction = 1.0;
        if (energy > 0.0) {
            this.correction = NORMAL_LEVEL / energy;
        }
        super.log(GraphErrorType.Information, Severity.Debug, "Correction: {0}", this.correction);
        return new ToneWrapper(this, source){

            @Override
            public double getSample(double offTime, double begTime, double endTime) {
                return this.source.getSample(offTime, begTime, endTime) * Normalize.this.correction;
            }
        };
    }
}

