/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Rate
extends ToneEffect {
    public InDouble inRate = new InDouble("rate", "Rate at which the tone is played. 1=no change", 1.0, 0.01, 100.0);
    private double timeRatio;

    public Rate() {
        super("music.effect.rate", "Change the rate (relative frequency) of a tone");
        this.inRate.setScaleType(ScaleType.LOG2);
        this.inRate.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    protected boolean isModified() {
        return this.inRate.isModified();
    }

    @Override
    protected void updateParameters() {
        this.timeRatio = (Double)this.inRate.read();
    }

    @Override
    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            @Override
            public double getSample(double offTime, double begTime, double endTime) {
                return this.source.getSample(offTime * Rate.this.timeRatio, begTime * Rate.this.timeRatio, endTime * Rate.this.timeRatio);
            }

            @Override
            public double getPeriod() {
                return super.getPeriod() / Rate.this.timeRatio;
            }
        };
    }
}

