/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Saturate
extends ToneEffect {
    public InDouble inLevel = new InDouble("level", "Amplification", 1.0, 0.0, 10.0);
    public InDouble inClip = new InDouble("clip", "Clipping level", 1.0, 0.0, 1.0);
    private double level;
    private double clip;

    public Saturate() {
        super("music.effect.saturate", "Amplification with clipping");
        this.inLevel.setSkillType(SkillType.SIMPLIFIED);
        this.inClip.setSkillType(SkillType.NORMAL);
    }

    @Override
    protected boolean isModified() {
        return this.inLevel.isModified() || this.inClip.isModified();
    }

    @Override
    protected void updateParameters() {
        this.level = (Double)this.inLevel.read();
        this.clip = (Double)this.inClip.read();
    }

    @Override
    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            @Override
            public double getSample(double offTime, double begTime, double endTime) {
                double sample = this.source.getSample(offTime, begTime, endTime) * Saturate.this.level;
                if (sample < -Saturate.this.clip) {
                    return -Saturate.this.clip;
                }
                if (sample > Saturate.this.clip) {
                    return Saturate.this.clip;
                }
                return sample;
            }
        };
    }
}

