/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.frequency;

import org.corebounce.decklight.bouncelets.music.FmCurve;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.frequency.FmCurveWrapper;
import org.corebounce.decklight.bouncelets.music.frequency.FmEffect;
import org.corebounce.decklight.bouncelets.music.ports.InTone;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Vibrato
extends FmEffect {
    public InTone inModulator = new InTone("tone", "Modulation tone");
    public InDouble inFrequency = new InDouble("frequency", "Modulation frequency", 4.0, 0.01, 100.0);
    public InDouble inAmplitude = new InDouble("amplitude", "Modulation amplitude [octave]", 0.041666666666666664, 0.0, 1.0);
    private double timeRatio;
    private double amplitude;

    public Vibrato() {
        super("music.frequency.vibrato", "Modulate the frequency curve using a tone");
        this.inFrequency.setScaleType(ScaleType.LOG2);
        this.inFrequency.setSkillType(SkillType.SIMPLIFIED);
        this.inAmplitude.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    protected boolean isModified() {
        return this.inFrequency.isModified() || this.inAmplitude.isModified();
    }

    @Override
    protected boolean isCurveModified() {
        return super.isCurveModified() || this.inModulator.isModified();
    }

    @Override
    protected void updateParameters() {
        this.timeRatio = (Double)this.inFrequency.read() / 440.0;
        this.amplitude = (Double)this.inAmplitude.read();
    }

    @Override
    protected FmCurve createTranform(FmCurve source) {
        final Tone modulator = (Tone)this.inModulator.read();
        return new FmCurveWrapper(source){

            @Override
            public double getRatio(double offTime, double elapsed) {
                double scaledElapsed = elapsed * Vibrato.this.timeRatio;
                double scaledOffTime = offTime * Vibrato.this.timeRatio;
                double modulation = modulator.getSample(scaledOffTime, scaledElapsed, scaledElapsed);
                modulation = Math.pow(2.0, modulation * Vibrato.this.amplitude);
                return this.source.getRatio(offTime, elapsed) * modulation;
            }
        };
    }
}

