/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.tone;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.tone.SynthTone;
import org.corebounce.decklight.bouncelets.music.tone.ToneSource;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class Synth
extends ToneSource {
    public InInt inSamplingSize = new InInt("sampling", "Sampling size", 512, 32, 32768);
    public InInt inMultiplier = new InInt("multiplier", "Main harmonic order", 1, 1, 5);
    public InDouble inCentroid = new InDouble("centroid", "Centroid", 0.5, 0.0, 1.0);
    private SynthTone tone;

    public Synth() {
        super("music.tone.synth", "Synth tone", "Additive synthesis tone");
    }

    @Override
    public void cycle() {
        if (this.tone == null) {
            this.tone = new SynthTone();
            this.outTone.write(this.tone);
        }
        if (this.tone != null) {
            if (this.inSamplingSize.isModified()) {
                this.tone.setSamplingSize((Integer)this.inSamplingSize.read());
            }
            if (this.inMultiplier.isModified()) {
                this.tone.setMultiplier((Integer)this.inMultiplier.read());
            }
            if (this.inCentroid.isModified()) {
                this.tone.setCentroid((Double)this.inCentroid.read());
            }
        }
        this.outTone.setModified(this.tone.isDirty());
    }

    @Override
    protected Tone createTone() {
        return this.tone;
    }
}

