/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.tone;

import java.util.Arrays;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.math.FastMath;

public class SynthTone
extends Tone {
    private static final double MIN_LEVEL = AudioMath.dbToLevel(-180.0);
    private int samplingSize = 512;
    private int multiplier = 1;
    private double centroid = 0.5;
    private double[] buffer;
    private boolean dirty = true;

    public void setSamplingSize(int samplingSize) {
        this.samplingSize = samplingSize;
        this.dirty = true;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
        this.dirty = true;
    }

    public void setCentroid(double multCentroid) {
        this.centroid = multCentroid;
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void synth() {
        if (this.buffer == null || this.buffer.length != this.samplingSize) {
            this.buffer = new double[this.samplingSize];
        } else {
            Arrays.fill(this.buffer, 0.0);
        }
        int harm = 1;
        while (harm < this.samplingSize) {
            if ((harm - 1) % this.multiplier == 0) {
                double exponent = 1.00001 - this.centroid;
                double level = Math.pow(harm, exponent *= -4.0);
                if (level < MIN_LEVEL) break;
                double toRadian = Math.PI * 2 * (double)harm / (double)this.samplingSize;
                int i = 0;
                while (i < this.samplingSize) {
                    int n = i;
                    this.buffer[n] = this.buffer[n] + FastMath.fastSin((double)i * toRadian) * level;
                    ++i;
                }
            }
            ++harm;
        }
        double max = 0.0;
        int i = 0;
        while (i < this.samplingSize) {
            if (Math.abs(this.buffer[i]) > max) {
                max = Math.abs(this.buffer[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.samplingSize) {
            int n = i++;
            this.buffer[n] = this.buffer[n] / max;
        }
        this.dirty = false;
    }

    @Override
    public double getSample(double offTime, double begTime, double endTime) {
        if (this.dirty) {
            this.synth();
        }
        double position = this.getAngle((begTime + endTime) / 2.0) * (double)this.samplingSize;
        int index0 = (int)position;
        int index1 = (index0 + 1) % this.samplingSize;
        float weight1 = (float)(position - (double)index0);
        float weight0 = 1.0f - weight1;
        return this.buffer[index0] * (double)weight0 + this.buffer[index1] * (double)weight1;
    }
}

