/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bridge;

import java.util.Arrays;
import java.util.Collection;
import org.corebounce.decklight.bridge.BaseType;

public class DataType {
    private String name;
    private BaseType baseType;
    private DataType componentType;
    private Collection<DataType> components;
    private String[] enumValues;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(BaseType type) {
        this.baseType = type;
    }

    public DataType getComponentType() {
        if (this.baseType != BaseType.ARRAY) {
            throw new IllegalStateException("Not an array");
        }
        return this.componentType;
    }

    public void setComponentType(DataType componentType) {
        if (this.baseType != BaseType.ARRAY) {
            throw new IllegalStateException("Not an array");
        }
        this.componentType = componentType;
    }

    public Collection<DataType> getComponents() {
        if (this.baseType != BaseType.STRUCT) {
            throw new IllegalStateException("Not a struct");
        }
        return this.components;
    }

    public void setComponents(Collection<DataType> components) {
        if (this.baseType != BaseType.STRUCT) {
            throw new IllegalStateException("Not a struct");
        }
        this.components = components;
    }

    public String[] getEnumValues() {
        if (this.baseType != BaseType.ENUM) {
            throw new IllegalStateException("Not an enum");
        }
        return this.enumValues;
    }

    public void setEnumValues(String[] enumValues) {
        if (this.baseType != BaseType.ENUM) {
            throw new IllegalStateException("Not an enum");
        }
        this.enumValues = enumValues;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataType) {
            DataType other = (DataType)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        result.append(':');
        result.append(this.baseType.toString());
        if (this.baseType == BaseType.ENUM) {
            result.append(Arrays.toString(this.enumValues));
        } else if (this.baseType == BaseType.ARRAY) {
            result.append('(');
            result.append(this.componentType.toString());
            result.append(')');
        } else if (this.baseType == BaseType.STRUCT) {
            result.append(this.components.toString());
        }
        return result.toString();
    }
}

