/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.server;

import java.util.ArrayList;
import java.util.List;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bridge.BounceletInfo;
import org.corebounce.decklight.bridge.InputPortInfo;
import org.corebounce.decklight.bridge.OutputPortInfo;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.IncarnatedBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.decklight.server.InputPortImpl;
import org.corebounce.decklight.server.OutputPortImpl;
import org.corebounce.utils.ResourceLoader;

public class BounceletImpl
implements BounceletInfo {
    private final BounceletBase bouncelet;
    private List<InputPortInfo> inputPorts;
    private List<OutputPortInfo> outputPorts;

    public BounceletImpl(BounceletBase bouncelet) {
        this.bouncelet = bouncelet;
    }

    BounceletBase getTarget() {
        return this.bouncelet;
    }

    @Override
    public String getName() {
        return this.bouncelet.getName();
    }

    @Override
    public String getDescription() {
        return this.bouncelet.getDescription();
    }

    @Override
    public String getDocumentation() {
        BounceletBase b = this.bouncelet;
        while (b instanceof IncarnatedBouncelet) {
            IncarnatedBouncelet incarnation = (IncarnatedBouncelet)b;
            b = incarnation.getTarget();
        }
        Class<?> bClass = b.getClass();
        String name = bClass.getSimpleName();
        String documentation = ResourceLoader.getResourceAsString(bClass, String.valueOf(name) + ".txt");
        return documentation;
    }

    @Override
    public SkillType getSkillType() {
        return this.bouncelet.getSkillType();
    }

    @Override
    public List<InputPortInfo> getInputPorts() {
        if (this.inputPorts == null) {
            List<InputPort<?>> ports = this.bouncelet.getInputPorts();
            this.inputPorts = new ArrayList<InputPortInfo>(ports.size());
            int i = 0;
            while (i < ports.size()) {
                this.inputPorts.add(new InputPortImpl((BounceletInfo)this, ports.get(i), i));
                ++i;
            }
        }
        return this.inputPorts;
    }

    @Override
    public List<OutputPortInfo> getOutputPorts() {
        if (this.outputPorts == null) {
            List<OutputPort<?>> ports = this.bouncelet.getOutputPorts();
            this.outputPorts = new ArrayList<OutputPortInfo>(ports.size());
            int i = 0;
            while (i < ports.size()) {
                this.outputPorts.add(new OutputPortImpl((BounceletInfo)this, ports.get(i), i));
                ++i;
            }
        }
        return this.outputPorts;
    }
}

