/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.server;

import java.net.URL;
import java.util.ArrayList;
import org.corebounce.decklight.bridge.BaseType;
import org.corebounce.decklight.bridge.DataType;
import org.corebounce.utils.ClassInfo;
import org.corebounce.utils.MemberInfo;

public class ClassToDataType {
    public static boolean isSimpleType(Class<?> type) {
        return type == Integer.class || type == Integer.TYPE || type == Boolean.class || type == Boolean.TYPE || type == Float.class || type == Float.TYPE || type == String.class || type == URL.class || type == Double.class || type == Double.TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <E> DataType toDataType(Class<E> type) {
        DataType result = null;
        if (ClassToDataType.isSimpleType(type)) {
            result = new DataType();
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                result.setBaseType(BaseType.INTEGER);
            } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                result.setBaseType(BaseType.FLOAT);
            } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                result.setBaseType(BaseType.DOUBLE);
            } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                result.setBaseType(BaseType.BOOLEAN);
            } else if (type.equals(String.class)) {
                result.setBaseType(BaseType.STRING);
            } else {
                if (!type.equals(URL.class)) throw new IllegalArgumentException("Unsupported primitive type: " + type);
                result.setBaseType(BaseType.URL);
            }
        } else if (type.isArray()) {
            DataType componentType = ClassToDataType.toDataType(type.getComponentType());
            result = new DataType();
            result.setBaseType(BaseType.ARRAY);
            result.setComponentType(componentType);
        } else if (type.isEnum()) {
            result = new DataType();
            result.setBaseType(BaseType.ENUM);
            Enum[] members = (Enum[])type.getEnumConstants();
            String[] names = new String[members.length];
            int i = 0;
            while (i < members.length) {
                names[i] = members[i].toString();
                ++i;
            }
            result.setEnumValues(names);
        } else {
            result = new DataType();
            result.setBaseType(BaseType.STRUCT);
            ClassInfo info = new ClassInfo(type);
            ArrayList<DataType> fieldTypes = new ArrayList<DataType>();
            for (MemberInfo member : info.getMembers()) {
                DataType fieldType = ClassToDataType.toDataType(member.getType());
                fieldTypes.add(fieldType);
            }
            result.setComponents(fieldTypes);
        }
        result.setName(type.getSimpleName());
        return result;
    }
}

