/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.server.osc;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.corebounce.decklight.bridge.BaseType;
import org.corebounce.decklight.bridge.BounceletInfo;
import org.corebounce.decklight.bridge.DataType;
import org.corebounce.decklight.bridge.InputPortInfo;
import org.corebounce.decklight.bridge.LogMessage;
import org.corebounce.decklight.bridge.OutputPortInfo;
import org.corebounce.decklight.server.ClassToDataType;
import org.corebounce.decklight.server.InputPortImpl;
import org.corebounce.utils.ClassInfo;
import org.corebounce.utils.MemberInfo;
import org.corebounce.utils.TextEncoding;

public class Cromagnon {
    private static String s(String s) {
        return s == null ? "" : s;
    }

    private static ClassInfo<?> getClassInfo(Class<?> type) {
        return new ClassInfo(type);
    }

    private static void encodeGeneric(Class<?> type, Object instance, List<Object> result) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (!type.equals(URL.class)) break block6;
                        result.add(TextEncoding.toUrl(instance.toString()));
                        break block7;
                    }
                    if (!ClassToDataType.isSimpleType(type)) break block8;
                    result.add(instance);
                    break block7;
                }
                if (!type.isArray()) break block9;
                int length = instance == null ? 0 : Array.getLength(instance);
                result.add(length);
                if (instance == null) break block7;
                int i = 0;
                while (i < length) {
                    Object item = Array.get(instance, i);
                    Cromagnon.encodeGeneric(type.getComponentType(), item, result);
                    ++i;
                }
                break block7;
            }
            if (instance instanceof Enum) {
                Enum value = (Enum)instance;
                result.add(value.ordinal());
            } else {
                ClassInfo<?> info = Cromagnon.getClassInfo(type);
                for (MemberInfo member : info.getMembers()) {
                    Class<?> memberType = member.getType();
                    try {
                        Object value = member.getValue(instance);
                        Cromagnon.encodeGeneric(memberType, value, result);
                    }
                    catch (InvocationTargetException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        }
    }

    private static void encodeDataType(DataType type, List<Object> result) {
        block3: {
            BaseType baseType;
            block4: {
                block2: {
                    result.add(type.getName());
                    baseType = type.getBaseType();
                    result.add(baseType.ordinal());
                    if (!baseType.equals((Object)BaseType.ENUM)) break block2;
                    String[] values = type.getEnumValues();
                    result.add(values.length);
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        result.add(value);
                        ++n2;
                    }
                    break block3;
                }
                if (!baseType.equals((Object)BaseType.ARRAY)) break block4;
                Cromagnon.encodeDataType(type.getComponentType(), result);
                break block3;
            }
            if (!baseType.equals((Object)BaseType.STRUCT)) break block3;
            Collection<DataType> fieldTypes = type.getComponents();
            result.add(fieldTypes.size());
            for (DataType fieldType : fieldTypes) {
                Cromagnon.encodeDataType(fieldType, result);
            }
        }
    }

    private static void encodeInputPort(InputPortInfo port, List<Object> result) {
        result.add(port.getName());
        result.add(Cromagnon.s(port.getDescription()));
        Cromagnon.encodeDataType(port.getDataType(), result);
        result.add(port.getScaleType().ordinal());
        result.add(port.getSkillType().ordinal());
        int count = 0;
        if (port.getDefaultValue() != null) {
            ++count;
        }
        if (port.getMinValue() != null) {
            ++count;
        }
        if (port.getMaxValue() != null) {
            ++count;
        }
        result.add(count);
        Class<?> javaType = ((InputPortImpl)port).getJavaType();
        if (port.getDefaultValue() != null) {
            Cromagnon.encodeGeneric(javaType, port.getDefaultValue(), result);
        }
        if (port.getMinValue() != null) {
            Cromagnon.encodeGeneric(javaType, port.getMinValue(), result);
        }
        if (port.getMaxValue() != null) {
            Cromagnon.encodeGeneric(javaType, port.getMaxValue(), result);
        }
    }

    private static void encodeOutputPort(OutputPortInfo port, List<Object> result) {
        result.add(port.getName());
        result.add(Cromagnon.s(port.getDescription()));
        Cromagnon.encodeDataType(port.getDataType(), result);
        result.add(port.getScaleType().ordinal());
        result.add(port.getSkillType().ordinal());
    }

    private static void encodeBouncelet(BounceletInfo info, List<Object> result) {
        result.add(info.getName());
        result.add(info.getDescription());
        result.add(Cromagnon.s(info.getDocumentation()));
        result.add(info.getSkillType().ordinal());
        List<InputPortInfo> inputPorts = info.getInputPorts();
        result.add(inputPorts.size());
        for (InputPortInfo port : inputPorts) {
            Cromagnon.encodeInputPort(port, result);
        }
        List<OutputPortInfo> outputPorts = info.getOutputPorts();
        result.add(outputPorts.size());
        for (OutputPortInfo port : outputPorts) {
            Cromagnon.encodeOutputPort(port, result);
        }
    }

    private static void encodeStringCollection(Collection<String> coll, List<Object> result) {
        result.add(coll.size());
        for (String string : coll) {
            result.add(string);
        }
    }

    private static void encodeLogMessage(LogMessage message, List<Object> result) {
        result.add(message.getLevel().getName());
        result.add(message.getLocation().ordinal());
        result.add(message.getItemId());
        result.add(message.getErrorType());
        result.add(message.getMessage());
        result.add(message.getTime());
    }

    public static Object[] fromBouncelet(BounceletInfo info) {
        ArrayList<Object> content = new ArrayList<Object>();
        Cromagnon.encodeBouncelet(info, content);
        return content.toArray();
    }

    public static Object[] fromStringCollection(Collection<String> coll) {
        ArrayList<Object> content = new ArrayList<Object>();
        Cromagnon.encodeStringCollection(coll, content);
        return content.toArray();
    }

    public static Object[] fromLogMessage(LogMessage logMessage) {
        ArrayList<Object> content = new ArrayList<Object>();
        Cromagnon.encodeLogMessage(logMessage, content);
        return content.toArray();
    }

    public static Object fromValue(Object data) {
        if (data == null) {
            return null;
        }
        ArrayList<Object> content = new ArrayList<Object>();
        Cromagnon.encodeGeneric(data.getClass(), data, content);
        if (content.size() == 1) {
            return content.get(0);
        }
        return content.toArray();
    }

    public static Object toValue(Class<?> type, Object data) {
        return Cromagnon.toValue(type, Arrays.asList(data).iterator());
    }

    private static Object toValue(Class<?> type, Iterator<Object> data) {
        if (Cromagnon.isPrimitive(type) || type.equals(String.class)) {
            return data.next();
        }
        if (type.equals(URL.class)) {
            String str = data.next().toString();
            str = TextEncoding.fromUrl(str);
            try {
                return new URL(str);
            }
            catch (MalformedURLException ex) {
                throw new ClassCastException("Cannot convert to URL: " + str);
            }
        }
        if (type.isArray()) {
            int length = (Integer)data.next();
            Object[] array = (Object[])Array.newInstance(type, length);
            int i = 0;
            while (i < length) {
                array[i] = Cromagnon.toValue(type.getComponentType(), data);
                ++i;
            }
            return array;
        }
        if (type.isEnum()) {
            int ordinal = (Integer)data.next();
            return (Enum)type.getEnumConstants()[ordinal];
        }
        Object instance = null;
        try {
            instance = type.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        ClassInfo<?> info = Cromagnon.getClassInfo(type);
        for (MemberInfo member : info.getMembers()) {
            Class<?> memberType = member.getType();
            try {
                Object value = Cromagnon.toValue(memberType, data);
                member.setValue(instance, value);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return instance;
    }

    private static boolean isPrimitive(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        return type.equals(Integer.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(Boolean.class) || type.equals(Short.class) || type.equals(Long.class) || type.equals(Character.class) || type.equals(Byte.class);
    }
}

