/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.math;

import java.util.Random;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.UnityRoots;
import org.corebounce.common.math.Cmplx;

public class RFFT {
    private int length;
    private int log;
    private final float sqrthalf = (float)Math.sqrt(0.5);
    private final Cmplx[] d16;
    private final Cmplx[] d32;
    private final Cmplx[] d64;
    private final Cmplx[] d128;
    private final Cmplx[] d256;
    private final Cmplx[] d512;
    private final Cmplx[][] roots;
    private final int[] scramble;

    public RFFT(int length) {
        this.length = length;
        this.log = RFFT.log2(length);
        UnityRoots generator = UnityRoots.getInstance();
        this.roots = new Cmplx[(this.log < 10 ? 10 : this.log) + 2][];
        int i = this.roots.length - 1;
        while (i >= 10) {
            int div = i == this.log + 1 ? 4 : 8;
            int size = 1 << i;
            this.roots[i] = generator.getRoots(size, size / div);
            --i;
        }
        this.d512 = this.getRoots(generator, 512, 9);
        this.d256 = this.getRoots(generator, 256, 8);
        this.d128 = this.getRoots(generator, 128, 7);
        this.d64 = this.getRoots(generator, 64, 6);
        this.d32 = this.getRoots(generator, 32, 5);
        this.d16 = this.getRoots(generator, 16, 4);
        this.scramble = new int[length];
        i = 0;
        while (i < length) {
            this.scramble[this.replaceReal((int)i, (int)length)] = i;
            ++i;
        }
    }

    private Cmplx[] getRoots(UnityRoots generator, int size, int log) {
        Cmplx[] result = generator.getRoots(size, size / 4);
        this.roots[log] = result;
        return result;
    }

    private int replaceReal(int i, int n) {
        if (n <= 2) {
            return i;
        }
        int m = n / 2;
        if (i < m) {
            return this.replaceReal(i, m) * 2;
        }
        return this.replace((i -= m) / 2, m / 2) * 2 + 1;
    }

    private int replace(int i, int n) {
        if (n <= 2) {
            return i;
        }
        int m = n / 2;
        if (i < m) {
            return this.replace(i, m) * 2;
        }
        if ((i -= m) < (m /= 2)) {
            return this.replace(i, m) * 4 + 1;
        }
        return this.replace(i -= m, m) * 4 - 1 & n - 1;
    }

    protected static final void transform(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3, float wre, float wim) {
        float t1 = a0.re - a2.re;
        float t2 = a0.im - a2.im;
        float t3 = a1.re - a3.re;
        float t4 = a1.im - a3.im;
        a0.re += a2.re;
        a0.im += a2.im;
        a1.re += a3.re;
        a1.im += a3.im;
        float t5 = t1 - t4;
        float t6 = t2 + t3;
        float t7 = t1 + t4;
        float t8 = t2 - t3;
        a2.re = t5 * wre - t6 * wim;
        a2.im = t6 * wre + t5 * wim;
        a3.re = t7 * wre + t8 * wim;
        a3.im = t8 * wre - t7 * wim;
    }

    protected final void transformHalf(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3) {
        float t1 = a0.re - a2.re;
        float t2 = a0.im - a2.im;
        float t3 = a1.re - a3.re;
        float t4 = a1.im - a3.im;
        a0.re += a2.re;
        a0.im += a2.im;
        a1.re += a3.re;
        a1.im += a3.im;
        float t5 = t1 - t4;
        float t6 = t2 + t3;
        float t7 = t1 + t4;
        float t8 = t2 - t3;
        a2.re = (t5 - t6) * this.sqrthalf;
        a2.im = (t6 + t5) * this.sqrthalf;
        a3.re = (t7 + t8) * this.sqrthalf;
        a3.im = (t8 - t7) * this.sqrthalf;
    }

    protected final void transformZero(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3) {
        float t1 = a0.re - a2.re;
        float t2 = a0.im - a2.im;
        float t3 = a1.re - a3.re;
        float t4 = a1.im - a3.im;
        a0.re += a2.re;
        a0.im += a2.im;
        a1.re += a3.re;
        a1.im += a3.im;
        a2.re = t1 - t4;
        a2.im = t2 + t3;
        a3.re = t1 + t4;
        a3.im = t2 - t3;
    }

    protected final void untransform(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3, float wre, float wim) {
        float t5 = a2.re * wre + a2.im * wim;
        float t6 = a2.im * wre - a2.re * wim;
        float t7 = a3.re * wre - a3.im * wim;
        float t8 = a3.im * wre + a3.re * wim;
        float t1 = t5 + t7;
        float t2 = t6 + t8;
        float t3 = t6 - t8;
        float t4 = t7 - t5;
        a2.re = a0.re - t1;
        a2.im = a0.im - t2;
        a3.re = a1.re - t3;
        a3.im = a1.im - t4;
        a0.re += t1;
        a0.im += t2;
        a1.re += t3;
        a1.im += t4;
    }

    protected final void untransformHalf(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3) {
        float t5 = (a2.re + a2.im) * this.sqrthalf;
        float t6 = (a2.im - a2.re) * this.sqrthalf;
        float t7 = (a3.re - a3.im) * this.sqrthalf;
        float t8 = (a3.im + a3.re) * this.sqrthalf;
        float t1 = t5 + t7;
        float t2 = t6 + t8;
        float t3 = t6 - t8;
        float t4 = t7 - t5;
        a2.re = a0.re - t1;
        a2.im = a0.im - t2;
        a3.re = a1.re - t3;
        a3.im = a1.im - t4;
        a0.re += t1;
        a0.im += t2;
        a1.re += t3;
        a1.im += t4;
    }

    protected final void untransformZero(Cmplx a0, Cmplx a1, Cmplx a2, Cmplx a3) {
        float t1 = a2.re + a3.re;
        float t2 = a2.im + a3.im;
        float t3 = a2.im - a3.im;
        float t4 = a3.re - a2.re;
        a2.re = a0.re - t1;
        a2.im = a0.im - t2;
        a3.re = a1.re - t3;
        a3.im = a1.im - t4;
        a0.re += t1;
        a0.im += t2;
        a1.re += t3;
        a1.im += t4;
    }

    protected final void transformReal(Cmplx a, Cmplx b, float wre, float wim) {
        float t1 = a.re - a.im;
        float t2 = b.re - b.im;
        float t3 = a.re + a.im;
        float t4 = b.re + b.im;
        b.re = t1 * wre - t2 * wim;
        b.im = t2 * wre + t1 * wim;
        a.re = t3;
        a.im = t4;
    }

    protected final void transformRealHalf(Cmplx a, Cmplx b) {
        float t1 = a.re - a.im;
        float t2 = b.re - b.im;
        float t3 = a.re + a.im;
        float t4 = b.re + b.im;
        b.re = (t1 - t2) * this.sqrthalf;
        b.im = (t2 + t1) * this.sqrthalf;
        a.re = t3;
        a.im = t4;
    }

    protected final void transformRealZero(Cmplx a, Cmplx b) {
        float t1 = a.re - a.im;
        float t2 = b.re - b.im;
        float t3 = a.re + a.im;
        float t4 = b.re + b.im;
        b.re = t1;
        b.im = t2;
        a.re = t3;
        a.im = t4;
    }

    protected final void untransformReal(Cmplx a, Cmplx b, float wre, float wim) {
        float t5 = b.re * wre + b.im * wim;
        float t6 = b.im * wre - b.re * wim;
        float t1 = a.re + t5;
        float t2 = a.re - t5;
        float t3 = a.im + t6;
        float t4 = a.im - t6;
        a.re = t1;
        a.im = t2;
        b.re = t3;
        b.im = t4;
    }

    protected final void untransformRealHalf(Cmplx a, Cmplx b) {
        float t5 = (b.re + b.im) * this.sqrthalf;
        float t6 = (b.im - b.re) * this.sqrthalf;
        float t1 = a.re + t5;
        float t2 = a.re - t5;
        float t3 = a.im + t6;
        float t4 = a.im - t6;
        a.re = t1;
        a.im = t2;
        b.re = t3;
        b.im = t4;
    }

    protected final void untransformRealZero(Cmplx a, Cmplx b) {
        float t1 = a.re + b.re;
        float t2 = a.re - b.re;
        float t3 = a.im + b.im;
        float t4 = a.im - b.im;
        a.re = t1;
        a.im = t2;
        b.re = t3;
        b.im = t4;
    }

    protected final void cpass(Cmplx[] a, int off, Cmplx[] w, int n) {
        int a0 = off;
        int a1 = 2 * n + off;
        int a2 = 4 * n + off;
        int a3 = 6 * n + off;
        this.transformZero(a[a0], a[a1], a[a2], a[a3]);
        int k = 2 * n - 1;
        int b = 1;
        do {
            RFFT.transform(a[b + a0], a[b + a1], a[b + a2], a[b + a3], w[b].re, w[b].im);
            ++b;
        } while (--k > 0);
    }

    protected final void upass(Cmplx[] a, int off, Cmplx[] w, int n) {
        int a0 = off;
        int a1 = 2 * n + off;
        int a2 = 4 * n + off;
        int a3 = 6 * n + off;
        this.untransformZero(a[a0], a[a1], a[a2], a[a3]);
        int k = 2 * n - 1;
        int b = 1;
        do {
            this.untransform(a[b + a0], a[b + a1], a[b + a2], a[b + a3], w[b].re, w[b].im);
            ++b;
        } while (--k > 0);
    }

    protected final void rpass(Cmplx[] a, Cmplx[] w, int n) {
        int h = 2 * n;
        this.transformRealZero(a[0], a[h]);
        int b = 1;
        int k = h - 1;
        do {
            this.transformReal(a[b], a[h + b], w[b].re, w[b].im);
            ++b;
        } while (--k > 0);
    }

    protected final void vpass(Cmplx[] a, Cmplx[] w, int n) {
        int h = 2 * n;
        this.untransformRealZero(a[0], a[h]);
        int b = 1;
        int k = h - 1;
        do {
            this.untransformReal(a[b], a[h + b], w[b].re, w[b].im);
            ++b;
        } while (--k > 0);
    }

    protected final void cpassBig(Cmplx[] a, int off, Cmplx[] w, int n) {
        int a0 = off;
        int a1 = 2 * n + off;
        int a2 = 4 * n + off;
        int a3 = 6 * n + off;
        this.transformZero(a[a0], a[a1], a[a2], a[a3]);
        int wb = 1;
        do {
            RFFT.transform(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].re, w[wb].im);
        } while (++wb < n);
        this.transformHalf(a[++a0], a[++a1], a[++a2], a[++a3]);
        --wb;
        do {
            RFFT.transform(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].im, w[wb].re);
        } while (--wb > 0);
    }

    protected final void upassBig(Cmplx[] a, int off, Cmplx[] w, int n) {
        int a0 = off;
        int a1 = 2 * n + off;
        int a2 = 4 * n + off;
        int a3 = 6 * n + off;
        this.untransformZero(a[a0], a[a1], a[a2], a[a3]);
        int wb = 1;
        do {
            this.untransform(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].re, w[wb].im);
        } while (++wb < n);
        this.untransformHalf(a[++a0], a[++a1], a[++a2], a[++a3]);
        --wb;
        do {
            this.untransform(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].im, w[wb].re);
        } while (--wb > 0);
    }

    protected final void rpassBig(Cmplx[] a, Cmplx[] w, int n) {
        int h = 2 * n;
        this.transformRealZero(a[0], a[h]);
        int b = 1;
        int wb = 1;
        do {
            this.transformReal(a[b], a[b + h], w[wb].re, w[wb].im);
            ++b;
        } while (++wb < n);
        this.transformRealHalf(a[b], a[b + h]);
        ++b;
        --wb;
        do {
            this.transformReal(a[b], a[b + h], w[wb].im, w[wb].re);
            ++b;
        } while (--wb > 0);
    }

    protected final void vpassBig(Cmplx[] a, Cmplx[] w, int n) {
        int h = 2 * n;
        this.untransformRealZero(a[0], a[h]);
        int b = 1;
        int wb = 1;
        do {
            this.untransformReal(a[b], a[h + b], w[wb].re, w[wb].im);
            ++b;
        } while (++wb < n);
        this.untransformRealHalf(a[b], a[b + h]);
        ++b;
        --wb;
        do {
            this.untransformReal(a[b], a[b + h], w[wb].im, w[wb].re);
            ++b;
        } while (--wb > 0);
    }

    protected final void c2(Cmplx[] a, int off) {
        float t1 = a[off + 0].re + a[off + 1].re;
        float t2 = a[off + 0].im + a[off + 1].im;
        float t3 = a[off + 0].re - a[off + 1].re;
        float t4 = a[off + 0].im - a[off + 1].im;
        a[off + 0].re = t1;
        a[off + 0].im = t2;
        a[off + 1].re = t3;
        a[off + 1].im = t4;
    }

    protected final void r2(Cmplx[] a, int off) {
        float t1 = a[off + 0].re + a[off + 0].im;
        float t2 = a[off + 0].re - a[off + 0].im;
        a[off + 0].re = t1;
        a[off + 0].im = t2;
    }

    protected final void r2(Cmplx[] a) {
        this.r2(a, 0);
    }

    protected final void c4(Cmplx[] a, int off) {
        this.transformZero(a[off + 0], a[off + 1], a[off + 2], a[off + 3]);
        this.c2(a, off);
    }

    protected final void u4(Cmplx[] a, int off) {
        this.c2(a, off);
        this.untransformZero(a[off + 0], a[off + 1], a[off + 2], a[off + 3]);
    }

    protected final void r4(Cmplx[] a, int off) {
        this.transformRealZero(a[off], a[off + 1]);
        this.r2(a, off);
    }

    protected final void r4(Cmplx[] a) {
        this.r4(a, 0);
    }

    protected final void v4(Cmplx[] a) {
        this.r2(a);
        this.untransformRealZero(a[0], a[1]);
    }

    protected final void c8(Cmplx[] a, int off) {
        this.transformZero(a[off + 0], a[off + 2], a[off + 4], a[off + 6]);
        this.transformHalf(a[off + 1], a[off + 3], a[off + 5], a[off + 7]);
        this.c4(a, off);
        this.c2(a, off + 4);
        this.c2(a, off + 6);
    }

    protected final void u8(Cmplx[] a, int off) {
        this.u4(a, off);
        this.c2(a, off + 4);
        this.c2(a, off + 6);
        this.untransformZero(a[off + 0], a[off + 2], a[off + 4], a[off + 6]);
        this.untransformHalf(a[off + 1], a[off + 3], a[off + 5], a[off + 7]);
    }

    protected final void r8(Cmplx[] a) {
        this.transformRealZero(a[0], a[2]);
        this.transformRealHalf(a[1], a[3]);
        this.r4(a);
        this.c2(a, 2);
    }

    protected final void v8(Cmplx[] a) {
        this.v4(a);
        this.c2(a, 2);
        this.untransformRealZero(a[0], a[2]);
        this.untransformRealHalf(a[1], a[3]);
    }

    protected final void c16(Cmplx[] a, int off) {
        this.cpass(a, off, this.d16, 2);
        this.c8(a, off);
        this.c4(a, off + 8);
        this.c4(a, off + 12);
    }

    protected final void u16(Cmplx[] a, int off) {
        this.u8(a, off);
        this.u4(a, off + 8);
        this.u4(a, off + 12);
        this.upass(a, off, this.d16, 2);
    }

    protected final void r16(Cmplx[] a) {
        this.rpass(a, this.d16, 2);
        this.r8(a);
        this.c4(a, 4);
    }

    protected final void v16(Cmplx[] a) {
        this.v8(a);
        this.u4(a, 4);
        this.vpass(a, this.d16, 2);
    }

    protected final void c32(Cmplx[] a, int off) {
        this.cpass(a, off, this.d32, 4);
        this.c16(a, off);
        this.c8(a, off + 16);
        this.c8(a, off + 24);
    }

    protected final void u32(Cmplx[] a, int off) {
        this.u16(a, off);
        this.u8(a, off + 16);
        this.u8(a, off + 24);
        this.upass(a, off, this.d32, 4);
    }

    protected final void r32(Cmplx[] a) {
        this.rpass(a, this.d32, 4);
        this.r16(a);
        this.c8(a, 8);
    }

    protected final void v32(Cmplx[] a) {
        this.v16(a);
        this.u8(a, 8);
        this.vpass(a, this.d32, 4);
    }

    protected final void c64(Cmplx[] a, int off) {
        this.cpass(a, off, this.d64, 8);
        this.c32(a, off);
        this.c16(a, off + 32);
        this.c16(a, off + 48);
    }

    protected final void u64(Cmplx[] a, int off) {
        this.u32(a, off);
        this.u16(a, off + 32);
        this.u16(a, off + 48);
        this.upass(a, off, this.d64, 8);
    }

    protected final void r64(Cmplx[] a) {
        this.rpass(a, this.d64, 8);
        this.r32(a);
        this.c16(a, 16);
    }

    protected final void v64(Cmplx[] a) {
        this.v32(a);
        this.u16(a, 16);
        this.vpass(a, this.d64, 8);
    }

    protected final void c128(Cmplx[] a, int off) {
        this.cpass(a, off, this.d128, 16);
        this.c64(a, off);
        this.c32(a, off + 64);
        this.c32(a, off + 96);
    }

    protected final void u128(Cmplx[] a, int off) {
        this.u64(a, off);
        this.u32(a, off + 64);
        this.u32(a, off + 96);
        this.upass(a, off, this.d128, 16);
    }

    protected final void r128(Cmplx[] a) {
        this.rpass(a, this.d128, 16);
        this.r64(a);
        this.c32(a, 32);
    }

    protected final void v128(Cmplx[] a) {
        this.v64(a);
        this.u32(a, 32);
        this.vpass(a, this.d128, 16);
    }

    protected final void c256(Cmplx[] a, int off) {
        this.cpass(a, off, this.d256, 32);
        this.c128(a, off);
        this.c64(a, off + 128);
        this.c64(a, off + 192);
    }

    protected final void u256(Cmplx[] a, int off) {
        this.u128(a, off);
        this.u64(a, off + 128);
        this.u64(a, off + 192);
        this.upass(a, off, this.d256, 32);
    }

    protected final void r256(Cmplx[] a) {
        this.rpass(a, this.d256, 32);
        this.r128(a);
        this.c64(a, 64);
    }

    protected final void v256(Cmplx[] a) {
        this.v128(a);
        this.u64(a, 64);
        this.vpass(a, this.d256, 32);
    }

    protected final void c512(Cmplx[] a, int off) {
        this.cpass(a, off, this.d512, 64);
        this.c256(a, off);
        this.c128(a, off + 256);
        this.c128(a, off + 384);
    }

    protected final void u512(Cmplx[] a, int off) {
        this.u256(a, off);
        this.u128(a, off + 256);
        this.u128(a, off + 384);
        this.upass(a, off, this.d512, 64);
    }

    protected final void r512(Cmplx[] a) {
        this.rpass(a, this.d512, 64);
        this.r256(a);
        this.c128(a, 128);
    }

    protected final void v512(Cmplx[] a) {
        this.v256(a);
        this.u128(a, 128);
        this.vpass(a, this.d512, 64);
    }

    protected final void cn(Cmplx[] a, int off, int log) {
        switch (log) {
            case 1: {
                this.c2(a, off);
                break;
            }
            case 2: {
                this.c4(a, off);
                break;
            }
            case 3: {
                this.c8(a, off);
                break;
            }
            case 4: {
                this.c16(a, off);
                break;
            }
            case 5: {
                this.c32(a, off);
                break;
            }
            case 6: {
                this.c64(a, off);
                break;
            }
            case 7: {
                this.c128(a, off);
                break;
            }
            case 8: {
                this.c256(a, off);
                break;
            }
            case 9: {
                this.c512(a, off);
                break;
            }
            default: {
                int size = 1 << log;
                int size4 = size / 4;
                this.cpassBig(a, off, this.roots[log], size / 8);
                this.cn(a, off, log - 1);
                this.cn(a, off + size4 + size4, log - 2);
                this.cn(a, off + size4 + size4 + size4, log - 2);
            }
        }
    }

    protected final void un(Cmplx[] a, int off, int log) {
        switch (log) {
            case 1: {
                this.c2(a, off);
                break;
            }
            case 2: {
                this.u4(a, off);
                break;
            }
            case 3: {
                this.u8(a, off);
                break;
            }
            case 4: {
                this.u16(a, off);
                break;
            }
            case 5: {
                this.u32(a, off);
                break;
            }
            case 6: {
                this.u64(a, off);
                break;
            }
            case 7: {
                this.u128(a, off);
                break;
            }
            case 8: {
                this.u256(a, off);
                break;
            }
            case 9: {
                this.u512(a, off);
                break;
            }
            default: {
                int size = 1 << log;
                int size4 = size / 4;
                this.un(a, off, log - 1);
                this.un(a, off + size4 + size4, log - 2);
                this.un(a, off + size4 + size4 + size4, log - 2);
                this.upassBig(a, off, this.roots[log], size / 8);
            }
        }
    }

    protected final void rn(Cmplx[] a, int log) {
        switch (log) {
            case 1: {
                this.r2(a);
                break;
            }
            case 2: {
                this.r4(a);
                break;
            }
            case 3: {
                this.r8(a);
                break;
            }
            case 4: {
                this.r16(a);
                break;
            }
            case 5: {
                this.r32(a);
                break;
            }
            case 6: {
                this.r64(a);
                break;
            }
            case 7: {
                this.r128(a);
                break;
            }
            case 8: {
                this.r256(a);
                break;
            }
            case 9: {
                this.r512(a);
                break;
            }
            default: {
                int size = 1 << log;
                this.rpassBig(a, this.roots[log], size / 8);
                this.rn(a, log - 1);
                this.cn(a, size / 4, log - 2);
            }
        }
    }

    protected final void vn(Cmplx[] a, int log) {
        switch (log) {
            case 1: {
                this.r2(a);
                break;
            }
            case 2: {
                this.v4(a);
                break;
            }
            case 3: {
                this.v8(a);
                break;
            }
            case 4: {
                this.v16(a);
                break;
            }
            case 5: {
                this.v32(a);
                break;
            }
            case 6: {
                this.v64(a);
                break;
            }
            case 7: {
                this.v128(a);
                break;
            }
            case 8: {
                this.v256(a);
                break;
            }
            case 9: {
                this.v512(a);
                break;
            }
            default: {
                int size = 1 << log;
                this.vn(a, log - 1);
                this.un(a, size / 4, log - 2);
                this.vpassBig(a, this.roots[log], size / 8);
            }
        }
    }

    public void scaleReal(Cmplx[] a) {
        double u = 1.0 / (double)(this.length * 2);
        a[0].re = (float)((double)a[0].re * u);
        a[0].im = (float)((double)a[0].im * u);
        u += u;
        int i = 1;
        while (i < this.length) {
            a[i].re = (float)((double)a[i].re * u);
            a[i].im = (float)((double)a[i].im * u);
            ++i;
        }
    }

    private static int log2(int size) {
        int log = 0;
        if (size >= 65536) {
            log += 16;
            size >>>= 16;
        }
        if (size >= 256) {
            log += 8;
            size >>>= 8;
        }
        if (size >= 16) {
            log += 4;
            size >>>= 4;
        }
        if (size >= 4) {
            log += 2;
            size >>>= 2;
        }
        if (size >= 2) {
            ++log;
        }
        return log;
    }

    static void test3() {
        int size = 64;
        Cmplx[] cArr = Cmplx.newArray(64);
        Cmplx[] rArr = Cmplx.newArray(32);
        int i = 0;
        while (i < 64) {
            cArr[i].set(-i, 0.0f);
            ++i;
        }
        i = 0;
        while (i < 32) {
            rArr[i].set(i * 2, i * 2 + 1);
            ++i;
        }
        RFFT fft = new RFFT(64);
        int log = RFFT.log2(64);
        fft.cn(cArr, 0, log);
        fft.rn(rArr, log);
        int i2 = 0;
        while (i2 < 64) {
            System.out.print(cArr[i2] + " ");
            ++i2;
        }
        System.out.println();
        i2 = 0;
        while (i2 < 32) {
            System.out.print(rArr[i2] + " ");
            ++i2;
        }
        System.out.println();
    }

    static void test1() {
        int CSIZE = 2;
        int RSIZE = 4;
        Random rnd = new Random(0L);
        Cmplx[] arr = Cmplx.newArray(2);
        Cmplx[] chk = Cmplx.newArray(2);
        float[] smp = new float[4];
        Cmplx[] boo = Cmplx.newArray(3);
        int i = 0;
        while (i < arr.length) {
            arr[i].re = rnd.nextFloat();
            arr[i].im = rnd.nextFloat();
            chk[i].copyFrom(arr[i]);
            smp[i * 2 + 0] = arr[i].re;
            smp[i * 2 + 1] = arr[i].im;
            ++i;
        }
        RFFT fft = new RFFT(2);
        BooFFT bfft = new BooFFT(2);
        fft.rn(arr, RFFT.log2(4));
        fft.scaleReal(arr);
        bfft.forwR2C(smp, boo);
        System.out.print("RFFT: ");
        int i2 = 0;
        while (i2 < arr.length) {
            System.out.print(arr[i2] + "  ");
            ++i2;
        }
        System.out.println();
        System.out.print("BFFT: ");
        i2 = 0;
        while (i2 < boo.length) {
            System.out.print(boo[i2] + "  ");
            ++i2;
        }
        System.out.println();
        fft.vn(arr, RFFT.log2(4));
        float maxError = 0.0f;
        int i3 = 0;
        while (i3 < arr.length) {
            float error = Math.abs(arr[i3].re - chk[i3].re) + Math.abs(arr[i3].im - chk[i3].im);
            if (error > maxError) {
                maxError = error;
            }
            ++i3;
        }
        System.out.println("Max error: " + maxError);
    }

    public static void main(String ... args) {
        RFFT.test3();
        RFFT.test1();
    }
}

