/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.GraphListener;
import org.corebounce.pitchbox.Controller;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.SharedFileReader;
import org.corebounce.pitchbox.effects.BeatFilter;
import org.corebounce.pitchbox.effects.Detune;
import org.corebounce.pitchbox.effects.Distort;
import org.corebounce.pitchbox.effects.Echo;
import org.corebounce.pitchbox.effects.Flanger;
import org.corebounce.pitchbox.effects.GhostDance;
import org.corebounce.pitchbox.effects.GraphicEq;
import org.corebounce.pitchbox.effects.Miserablize;
import org.corebounce.pitchbox.effects.Normal;
import org.corebounce.pitchbox.effects.OctaveShifter;
import org.corebounce.pitchbox.effects.PitchScrew;
import org.corebounce.pitchbox.effects.PitchShift;
import org.corebounce.pitchbox.effects.Robotize;
import org.corebounce.pitchbox.effects.SoundEffect;
import org.corebounce.pitchbox.effects.StnEqualizer;
import org.corebounce.pitchbox.effects.Thor;
import org.corebounce.pitchbox.effects.Vocoder;
import org.corebounce.pitchbox.effects.Water;
import org.corebounce.pitchbox.effects.Whisperize;
import org.corebounce.pitchbox.effects.Zombify;
import org.corebounce.pitchbox.utils.TableLayout;
import org.corebounce.utils.Severity;

public class EffectChooserPanel
extends JPanel
implements ActionListener,
ChangeListener,
Controller {
    private static final long serialVersionUID = 61299982543604576L;
    private Engine engine;
    private SoundEffect effect;
    private JPanel ctnControl;
    private JPanel pnlControl;
    private boolean audioInActive;
    private File file;
    private boolean showing = false;
    private final JToggleButton btnNormal = new JToggleButton("Normal");
    private final JToggleButton btnEcho = new JToggleButton("Echo");
    private final JToggleButton btnBeatFilter = new JToggleButton("Beat Filter");
    private final JToggleButton btnDistort = new JToggleButton("Distort");
    private final JToggleButton btnPitchshift = new JToggleButton("Pitch Shift");
    private final JToggleButton btnXSnow = new JToggleButton("Whisperize");
    private final JToggleButton btnGfxEq = new JToggleButton("Graphic Eq.");
    private final JToggleButton btnSTNEq = new JToggleButton("STN Equalizer");
    private final JToggleButton btnRobotizer = new JToggleButton("Robotize");
    private final JToggleButton btnThor = new JToggleButton("Thor");
    private final JToggleButton btnMiserablize = new JToggleButton("Miserablize");
    private final JToggleButton btnFlanger = new JToggleButton("Flanger");
    private final JToggleButton btnWater = new JToggleButton("Water");
    private final JToggleButton btnGhostDance = new JToggleButton("Ghost Dance");
    private final JToggleButton btnDetune = new JToggleButton("Detune");
    private final JToggleButton btnOctaveShifter = new JToggleButton("Octaver");
    private final JToggleButton btnZombify = new JToggleButton("Zombify");
    private final JToggleButton btnVocoder = new JToggleButton("Vocoder");
    private final JToggleButton btnPitchScrew = new JToggleButton("Pitch Screw");
    private final JToggleButton[] buttons = new JToggleButton[]{this.btnNormal, this.btnEcho, this.btnFlanger, this.btnPitchshift, this.btnXSnow, this.btnRobotizer, this.btnGfxEq, this.btnDetune, this.btnGhostDance, this.btnMiserablize, this.btnBeatFilter, this.btnThor, this.btnDistort, this.btnWater, this.btnSTNEq, this.btnOctaveShifter, this.btnZombify, this.btnVocoder, this.btnPitchScrew};
    private final Map<Component, Class<? extends SoundEffect>> effectsMap = new HashMap<Component, Class<? extends SoundEffect>>();
    Component current;

    public EffectChooserPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.ipadx = 2;
        gbc.ipady = 2;
        TableLayout layout = new TableLayout(4, gbc);
        super.setLayout(layout);
        ButtonGroup group = new ButtonGroup();
        gbc = (GridBagConstraints)layout.getDfltConstraint().clone();
        gbc.gridwidth = 2;
        this.btnNormal.setSelected(true);
        this.btnNormal.requestFocusInWindow();
        JToggleButton[] jToggleButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JToggleButton button = jToggleButtonArray[n2];
            button.addActionListener(this);
            button.addChangeListener(this);
            this.add((Component)button, gbc);
            gbc = null;
            group.add(button);
            this.setBold(button, true);
            ++n2;
        }
        this.effectsMap.put(this.btnNormal, Normal.class);
        this.effectsMap.put(this.btnEcho, Echo.class);
        this.effectsMap.put(this.btnBeatFilter, BeatFilter.class);
        this.effectsMap.put(this.btnPitchshift, PitchShift.class);
        this.effectsMap.put(this.btnXSnow, Whisperize.class);
        this.effectsMap.put(this.btnRobotizer, Robotize.class);
        this.effectsMap.put(this.btnGfxEq, GraphicEq.class);
        this.effectsMap.put(this.btnDetune, Detune.class);
        this.effectsMap.put(this.btnGhostDance, GhostDance.class);
        this.effectsMap.put(this.btnFlanger, Flanger.class);
        this.effectsMap.put(this.btnMiserablize, Miserablize.class);
        this.effectsMap.put(this.btnThor, Thor.class);
        this.effectsMap.put(this.btnDistort, Distort.class);
        this.effectsMap.put(this.btnWater, Water.class);
        this.effectsMap.put(this.btnSTNEq, StnEqualizer.class);
        this.effectsMap.put(this.btnOctaveShifter, OctaveShifter.class);
        this.effectsMap.put(this.btnZombify, Zombify.class);
        this.effectsMap.put(this.btnVocoder, Vocoder.class);
        this.effectsMap.put(this.btnPitchScrew, PitchScrew.class);
    }

    public void setControlPanel(JPanel panel) {
        this.ctnControl = panel;
    }

    public void init() {
        JToggleButton[] jToggleButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JToggleButton button = jToggleButtonArray[n2];
            button.setMinimumSize(button.getSize());
            button.setPreferredSize(button.getSize());
            this.setBold(button, false);
            ++n2;
        }
    }

    public void start() {
        this.actionPerformed(this.btnNormal);
        this.setBold(this.btnNormal, true);
    }

    @Override
    public void rebuild() {
        this.actionPerformed(this.current);
    }

    public void stop() {
        this.flush();
    }

    private void setBold(JToggleButton button, boolean bold) {
        if (bold) {
            button.setFont(button.getFont().deriveFont(1));
        } else {
            button.setFont(button.getFont().deriveFont(0));
        }
        button.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JToggleButton btn = (JToggleButton)e.getSource();
        this.setBold(btn, btn.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed((Component)e.getSource());
    }

    private void actionPerformed(Component src) {
        this.flush();
        this.current = src;
        this.engine = new Engine();
        this.engine.setAudioInActive(this.audioInActive);
        this.engine.setFile(this.file);
        this.engine.init();
        this.engine.setGraphListener(new GraphListener(){

            @Override
            public void portValueChanged(int bounceletId, int portNum, boolean output, Object value) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logMessage(GraphErrorType errorType, Severity severity, String message, Object source) {
                if (severity != Severity.Error && severity != Severity.Catastroph) {
                    return;
                }
                EffectChooserPanel effectChooserPanel = EffectChooserPanel.this;
                synchronized (effectChooserPanel) {
                    if (EffectChooserPanel.this.showing) {
                        return;
                    }
                    EffectChooserPanel.this.showing = true;
                }
                if (message.contains("Drake")) {
                    EffectChooserPanel.this.displayError("Sorry Prof. Drake, I couldn't finish my homework");
                } else if (errorType == GraphErrorType.ServerError || errorType == GraphErrorType.DeviceError) {
                    if (source instanceof SharedFileReader) {
                        EffectChooserPanel.this.displayError("Unsupported audio file format");
                    } else {
                        EffectChooserPanel.this.displayError("Failed to open audio device");
                    }
                } else {
                    EffectChooserPanel.this.showing = false;
                }
            }
        });
        this.pnlControl = new JPanel();
        this.pnlControl.setLayout(new TableLayout(2));
        this.ctnControl.add(this.pnlControl);
        this.ctnControl.validate();
        this.ctnControl.revalidate();
        this.ctnControl.repaint();
        Class<? extends SoundEffect> effectClass = this.effectsMap.get(src);
        if (effectClass != null) {
            try {
                this.effect = effectClass.newInstance();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        if (this.effect != null) {
            SoundEffect.SourceMode mode = SoundEffect.SourceMode.AUDIO_IN;
            if (this.engine.getFile() != null) {
                mode = this.engine.isAudioInActive() ? SoundEffect.SourceMode.MIXED : SoundEffect.SourceMode.FILE;
            }
            this.effect.initMode(mode);
            this.effect.initEngine(this.engine);
            this.effect.initGui(this.engine, this.pnlControl);
            if (this.engine.isAudioInActive() || this.engine.getFile() != null) {
                this.engine.commitAndPlay();
            }
        }
    }

    private void displayError(final String message) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EffectChooserPanel.this.flush();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(EffectChooserPanel.this, message, "Error", 0);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                EffectChooserPanel effectChooserPanel = EffectChooserPanel.this;
                synchronized (effectChooserPanel) {
                    EffectChooserPanel.this.showing = false;
                }
            }
        }.start();
    }

    private void flush() {
        if (this.effect != null) {
            this.effect.flush(this.engine);
            this.effect = null;
        }
        if (this.engine != null) {
            this.engine.stop();
            this.engine.flush();
            this.engine = null;
        }
        if (this.pnlControl != null) {
            this.ctnControl.remove(this.pnlControl);
            this.pnlControl = null;
        }
    }

    @Override
    public void resume() {
        if (this.engine == null) {
            return;
        }
        this.engine.init();
        this.effect.initEngine(this.engine);
        if (this.engine.isAudioInActive() || this.engine.getFile() != null) {
            this.engine.commitAndPlay();
        }
    }

    @Override
    public void suspend() {
        if (this.engine != null) {
            this.engine.flush();
        }
    }

    @Override
    public float getRecordLevel() {
        if (this.effect != null) {
            return this.effect.getRecordLevel();
        }
        return -200.0f;
    }

    @Override
    public void setAudioInActive(boolean isAudioInActive) {
        this.audioInActive = isAudioInActive;
        if (this.engine != null) {
            this.engine.setAudioInActive(isAudioInActive);
        }
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        if (this.engine != null) {
            this.engine.setFile(file);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

