/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.corebounce.decklight.audio.device.AudioIO;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SampleRate;
import org.corebounce.pitchbox.PitchBox;

public class Settings {
    public static final String[] SUPPORTED_FORMATS = new String[]{".mp3", ".ogg", ".wav", ".aif", ".aiff", ".aifc", ".au", ".flac"};
    public static final String FORMATS_DESCRIPTION = "Audio files (*.mp3, *.ogg, *.wav, *.aif, *.au, *.flac)";
    private static Preferences prefs = Preferences.userNodeForPackage(PitchBox.class);
    private static Settings instance;
    private PowerOf2 minBlockSize = PowerOf2.p1024;
    private boolean exactBlockSize = false;
    private SampleRate sampleRate = SampleRate.r44100;
    private int nbBuffers = 3;
    private int recordDeviceNum = 0;
    private int firstRecordChanIndex = 0;
    private int playDeviceNum = 0;
    private int firstPlayChanIndex = 0;
    private int numChans = 2;
    private boolean processMono = false;
    private boolean dupOutputChans = false;

    private Settings() {
        this.load();
    }

    public static synchronized Settings instance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    private void load() {
        this.minBlockSize = PowerOf2.fromInt(prefs.getInt("minBlockSize", this.minBlockSize.intValue()));
        this.exactBlockSize = prefs.getBoolean("exactBlockSize", false);
        this.sampleRate = SampleRate.fromValue(prefs.getInt("sampleRate", this.sampleRate.value()));
        this.nbBuffers = prefs.getInt("nbBuffers", this.nbBuffers);
        this.recordDeviceNum = prefs.getInt("recordDeviceNum", this.recordDeviceNum);
        this.firstRecordChanIndex = prefs.getInt("firstRecordChanIndex", this.firstRecordChanIndex);
        this.playDeviceNum = prefs.getInt("playDeviceNum", this.playDeviceNum);
        this.firstPlayChanIndex = prefs.getInt("firstPlayChanIndex", this.firstPlayChanIndex);
        this.numChans = prefs.getInt("numChans", this.numChans);
        this.processMono = prefs.getBoolean("processMono", this.processMono);
        this.dupOutputChans = prefs.getBoolean("dupOutputChans", this.dupOutputChans);
    }

    public void save() {
        prefs.putInt("minBlockSize", this.minBlockSize.intValue());
        prefs.putBoolean("exactBlockSize", this.exactBlockSize);
        prefs.putInt("sampleRate", this.sampleRate.value());
        prefs.putInt("nbBuffers", this.nbBuffers);
        prefs.putInt("recordDeviceNum", this.recordDeviceNum);
        prefs.putInt("firstRecordChanIndex", this.firstRecordChanIndex);
        prefs.putInt("playDeviceNum", this.playDeviceNum);
        prefs.putInt("firstPlayChanIndex", this.firstPlayChanIndex);
        prefs.putInt("numChans", this.numChans);
        prefs.putBoolean("processMono", this.processMono);
        prefs.putBoolean("dupOutputChans", this.dupOutputChans);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public PowerOf2 getMinBlockSize() {
        if (this.minBlockSize == null) {
            this.minBlockSize = PowerOf2.fromInt(AudioIO.instance().preferredFrameSize());
        }
        return this.minBlockSize;
    }

    public void setMinBlockSize(PowerOf2 minBlockSize) {
        this.minBlockSize = minBlockSize;
    }

    public boolean isExactBlockSize() {
        return this.exactBlockSize;
    }

    public void setExactBlockSize(boolean exactBlockSize) {
        this.exactBlockSize = exactBlockSize;
    }

    public SampleRate getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(SampleRate sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getNbBuffers() {
        if (this.nbBuffers < 0) {
            this.nbBuffers = AudioIO.instance().preferredNumberOfBuffers();
        }
        return this.nbBuffers;
    }

    public void setNbBuffers(int nbBuffers) {
        this.nbBuffers = nbBuffers;
    }

    public int getRecordDeviceNum() {
        return this.recordDeviceNum;
    }

    public void setRecordDeviceNum(int recordDeviceNum) {
        this.recordDeviceNum = recordDeviceNum;
    }

    public int getFirstRecordChanIndex() {
        return this.firstRecordChanIndex;
    }

    public void setFirstRecordChanIndex(int firstRecordChanIndex) {
        this.firstRecordChanIndex = firstRecordChanIndex;
    }

    public int getPlayDeviceNum() {
        return this.playDeviceNum;
    }

    public void setPlayDeviceNum(int playDeviceNum) {
        this.playDeviceNum = playDeviceNum;
    }

    public int getFirstPlayChanIndex() {
        return this.firstPlayChanIndex;
    }

    public void setFirstPlayChanIndex(int firstPlayChanIndex) {
        this.firstPlayChanIndex = firstPlayChanIndex;
    }

    public int getNumChans() {
        return this.numChans;
    }

    public void setNumChans(int numChans) {
        this.numChans = numChans;
    }

    public boolean isProcessMono() {
        return this.processMono;
    }

    public void setProcessMono(boolean processMono) {
        this.processMono = processMono;
    }

    public boolean isDupOutputChans() {
        return this.dupOutputChans;
    }

    public void setDupOutputChans(boolean dupOutputChans) {
        this.dupOutputChans = dupOutputChans;
    }

    public static void setCurrentDir(File dir) {
        prefs.put("currentDir", dir.getAbsolutePath());
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static File getCurrentDir() {
        String path = prefs.get("currentDir", System.getProperty("user.home"));
        return new File(path);
    }
}

