/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.corebounce.decklight.audio.device.AudioIO;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SampleRate;
import org.corebounce.pitchbox.Controller;
import org.corebounce.pitchbox.Settings;
import org.corebounce.pitchbox.utils.TableLayout;

public class SettingsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Controller controller;
    private JComboBox cmbSampleRate;
    private JComboBox cmbExact;
    private JComboBox cmbBlockSize;
    private JComboBox cmbBuffers;
    private JComboBox cmbMode;
    private JComboBox cmbRecDev;
    private JComboBox cmbRecChan;
    private JComboBox cmbPlayDev;
    private JComboBox cmbPlayChan;

    public SettingsDialog(Frame owner, Controller controller) {
        super(owner, "PitchBox settings", false);
        this.controller = controller;
        this.setResizable(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        TableLayout vertical = new TableLayout(2, gbc);
        this.getContentPane().setLayout(vertical);
        GridBagConstraints inpConstraints = new GridBagConstraints();
        inpConstraints.insets = new Insets(4, 4, 4, 4);
        inpConstraints.fill = 2;
        inpConstraints.anchor = 17;
        JPanel devicePanel = new JPanel();
        devicePanel.setBorder(new TitledBorder("Audio device settings"));
        this.getContentPane().add(devicePanel);
        TableLayout deviceLayout = new TableLayout(2, inpConstraints);
        devicePanel.setLayout(deviceLayout);
        JLabel lblSampleRate = new JLabel("Sample rate: ");
        devicePanel.add(lblSampleRate);
        this.cmbSampleRate = new JComboBox<String>(new String[]{"44100 Hz", "48000 Hz"});
        devicePanel.add(this.cmbSampleRate);
        JLabel lblBlockSize = new JLabel("Buffer size: ");
        devicePanel.add(lblBlockSize);
        JPanel pnlBlockSize = new JPanel(new TableLayout(2));
        this.cmbExact = new JComboBox<String>(new String[]{">=", "="});
        this.cmbExact.setToolTipText("<html><body><ul><li>Allow larger block size for effects needing it (&gt;=)</li><li>Force the given value (=) - may result in drops</li></ul></body></html>");
        pnlBlockSize.add(this.cmbExact);
        this.cmbBlockSize = new JComboBox<String>(new String[]{"16", "32", "64", "128", "256", "512", "1024", "2048", "4096", "8192"});
        this.cmbBlockSize.setToolTipText("<html><body>Smaller means lower latency, but is more subject to drops.<br>You should leave to the default value when playing audio files.</body></html>");
        pnlBlockSize.add(this.cmbBlockSize);
        devicePanel.add(pnlBlockSize);
        JLabel lblBuffers = new JLabel("Buffers (Linux only): ");
        devicePanel.add(lblBuffers);
        this.cmbBuffers = new JComboBox<String>(new String[]{"2", "3", "4", "5", "6", "7", "8"});
        devicePanel.add(this.cmbBuffers);
        JPanel chanPanel = new JPanel();
        chanPanel.setBorder(new TitledBorder("Audio channels settings"));
        this.getContentPane().add(chanPanel);
        TableLayout chanLayout = new TableLayout(2, inpConstraints);
        chanPanel.setLayout(chanLayout);
        JLabel lblMode = new JLabel("Mode: ");
        chanPanel.add(lblMode);
        this.cmbMode = new JComboBox<String>(new String[]{"Mono", "Stereo to Mono", "Mono to Stereo", "Stereo"});
        this.cmbMode.setToolTipText("<html><body><ul><li><b>Mono</b>: Record and play one channel<li><b>Stereo to Mono</b>: Record two channels, play one<li><b>Mono to Stereo</b>: Record one channel, play two<li><b>Stereo</b>: Play and record two channels</ul></body></html>");
        chanPanel.add(this.cmbMode);
        JLabel lblFirstRec = new JLabel("Rec. chan: ");
        chanPanel.add(lblFirstRec);
        this.cmbRecChan = new JComboBox<String>(new String[]{"0 (default)", "1", "2", "3", "4", "5", "6"});
        this.cmbRecChan.setToolTipText("Index of first input channel. Useful for native ASIO only; leave to zero else.");
        chanPanel.add(this.cmbRecChan);
        JLabel lblFirstPlay = new JLabel("Play chan: ");
        chanPanel.add(lblFirstPlay);
        this.cmbPlayChan = new JComboBox<String>(new String[]{"0 (default)", "1", "2", "3", "4", "5", "6"});
        this.cmbPlayChan.setToolTipText("Index of first output channel. Useful for native ASIO only; leave to zero else.");
        chanPanel.add(this.cmbPlayChan);
        JPanel portPanel = new JPanel();
        portPanel.setBorder(new TitledBorder("Audio device selection (advanced)"));
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)portPanel, gbc);
        TableLayout portLayout = new TableLayout(4, inpConstraints);
        portPanel.setLayout(portLayout);
        JLabel lblRecDev = new JLabel("Rec. dev: ");
        portPanel.add(lblRecDev);
        this.cmbRecDev = new JComboBox<String>(new String[]{"0 (default device)", "1", "2", "3", "4", "5", "6", "7", "8"});
        this.cmbRecDev.setToolTipText("Record device number. Leave to zero unless you have multiple sound cards. 1 is 1st device.");
        portPanel.add(this.cmbRecDev);
        JLabel lblPlayDev = new JLabel("Play. dev: ");
        portPanel.add(lblPlayDev);
        this.cmbPlayDev = new JComboBox<String>(new String[]{"0 (default device)", "1", "2", "3", "4", "5", "6", "7", "8"});
        this.cmbPlayDev.setToolTipText("playback device number. Leave to zero unless you have multiple sound cards. 1 is 1st device.");
        portPanel.add(this.cmbPlayDev);
        GridBagConstraints btnConstraints = new GridBagConstraints();
        btnConstraints.insets = new Insets(4, 4, 4, 4);
        btnConstraints.anchor = 10;
        GridBagConstraints btpConstraints = new GridBagConstraints();
        btpConstraints.fill = 1;
        btpConstraints.gridwidth = 2;
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add((Component)buttonPanel, btpConstraints);
        TableLayout buttonLayout = new TableLayout(4, btnConstraints);
        buttonPanel.setLayout(buttonLayout);
        JButton btnOk = new JButton("OK");
        btnOk.setToolTipText("Apply and close");
        buttonPanel.add(btnOk);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.save();
                SettingsDialog.this.close();
            }
        });
        JButton btnReset = new JButton("Reset");
        btnReset.setToolTipText("Restore default settings");
        buttonPanel.add(btnReset);
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int option = JOptionPane.showConfirmDialog(SettingsDialog.this, "Restore default settings?", "Reset", 2);
                if (option == 0) {
                    SettingsDialog.this.reset();
                }
            }
        });
        JButton btnApply = new JButton("Apply");
        buttonPanel.add(btnApply);
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.save();
            }
        });
        JButton btnClose = new JButton("Close");
        buttonPanel.add(btnClose);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.close();
            }
        });
        this.pack();
        btnClose.requestFocusInWindow();
        this.load();
    }

    private void load() {
        Settings s = Settings.instance();
        if (s.getSampleRate() == SampleRate.r44100) {
            this.cmbSampleRate.setSelectedIndex(0);
        } else {
            this.cmbSampleRate.setSelectedIndex(1);
        }
        int bsIndex = s.getMinBlockSize().getLog2() - 4;
        this.cmbBlockSize.setSelectedIndex(bsIndex);
        this.cmbExact.setSelectedIndex(s.isExactBlockSize() ? 1 : 0);
        this.cmbBuffers.setSelectedIndex(s.getNbBuffers() - 2);
        int modeIndex = 0;
        if (s.getNumChans() == 2) {
            modeIndex = s.isProcessMono() ? 1 : 3;
        } else if (s.isDupOutputChans()) {
            modeIndex = 2;
        }
        this.cmbMode.setSelectedIndex(modeIndex);
        this.cmbRecDev.setSelectedIndex(s.getRecordDeviceNum());
        this.cmbRecChan.setSelectedIndex(s.getFirstRecordChanIndex());
        this.cmbPlayDev.setSelectedIndex(s.getPlayDeviceNum());
        this.cmbPlayChan.setSelectedIndex(s.getFirstPlayChanIndex());
    }

    private void reset() {
        this.cmbSampleRate.setSelectedIndex(0);
        int bsIndex = PowerOf2.fromInt(AudioIO.instance().preferredFrameSize()).getLog2() - 4;
        this.cmbBlockSize.setSelectedIndex(bsIndex);
        this.cmbExact.setSelectedIndex(0);
        this.cmbBuffers.setSelectedIndex(AudioIO.instance().preferredNumberOfBuffers() - 2);
        this.cmbMode.setSelectedIndex(3);
        this.cmbRecDev.setSelectedIndex(0);
        this.cmbRecChan.setSelectedIndex(0);
        this.cmbPlayDev.setSelectedIndex(0);
        this.cmbPlayChan.setSelectedIndex(0);
    }

    private void save() {
        this.controller.suspend();
        Settings s = Settings.instance();
        if (this.cmbSampleRate.getSelectedIndex() == 0) {
            s.setSampleRate(SampleRate.r44100);
        } else {
            s.setSampleRate(SampleRate.r48000);
        }
        PowerOf2 blockSize = PowerOf2.values()[this.cmbBlockSize.getSelectedIndex() + 4];
        s.setMinBlockSize(blockSize);
        s.setExactBlockSize(this.cmbExact.getSelectedIndex() == 1);
        s.setNbBuffers(this.cmbBuffers.getSelectedIndex() + 2);
        if (this.cmbMode.getSelectedIndex() == 0) {
            s.setNumChans(1);
            s.setProcessMono(false);
            s.setDupOutputChans(false);
        } else if (this.cmbMode.getSelectedIndex() == 1) {
            s.setNumChans(2);
            s.setProcessMono(true);
            s.setDupOutputChans(false);
        } else if (this.cmbMode.getSelectedIndex() == 2) {
            s.setNumChans(1);
            s.setProcessMono(false);
            s.setDupOutputChans(true);
        } else {
            s.setNumChans(2);
            s.setProcessMono(false);
            s.setDupOutputChans(false);
        }
        s.setRecordDeviceNum(this.cmbRecDev.getSelectedIndex());
        s.setPlayDeviceNum(this.cmbPlayDev.getSelectedIndex());
        s.setFirstRecordChanIndex(this.cmbRecChan.getSelectedIndex());
        s.setFirstPlayChanIndex(this.cmbPlayChan.getSelectedIndex());
        s.save();
        this.controller.rebuild();
    }

    private void close() {
        this.setVisible(false);
    }
}

