/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import javax.swing.JPanel;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.effect.base.Volume;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PitchShiftOcean;
import org.corebounce.decklight.bouncelets.audio.effect.wave.time.Delay;
import org.corebounce.decklight.bouncelets.audio.flow.Mixer;
import org.corebounce.decklight.bouncelets.signal.Sub;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class Echo
extends SoundEffect {
    private PitchShiftOcean pitchShift;
    private Volume backVolume;
    private Volume forwVolume;
    private Sub sub;

    @Override
    public void initEngine(Engine engine) {
        super.init(engine, PowerOf2.p256);
        this.forwVolume = new Volume();
        this.pitchShift = new PitchShiftOcean();
        this.backVolume = new Volume();
        this.sub = new Sub();
        Delay delay = new Delay();
        BlockSize blockSize = new BlockSize();
        Mixer mixer = new Mixer();
        engine.addBouncelets(this.forwVolume, this.backVolume, this.sub, delay, blockSize, mixer);
        super.addFourierEffect(engine, this.pitchShift, this.pitchShift.inSpectrum, this.pitchShift.outSpectrum, PowerOf2.p2048, PowerOf2.p8, false, false);
        engine.connect(this.sub.outResult, delay.inDelay);
        engine.connect(this.sourcePort, this.forwVolume.inAudio);
        engine.connect(this.forwVolume.outAudio, mixer.inAudio0);
        engine.connect(mixer.outAudio, this.backVolume.inAudio);
        engine.connect(this.backVolume.outAudio, delay.inAudio);
        engine.connect(delay.outAudio, this.wave2spectrum.inAudio());
        engine.connect(this.spectrum2wave.outAudio(), blockSize.inAudio);
        engine.connect(blockSize.outAudio, mixer.inAudio1);
        engine.connect(mixer.outAudio, this.targetPort);
        engine.setInput(blockSize.inBlockSize, this.blockSize);
        engine.setInput(mixer.inNormalized, false);
        engine.setInput(this.sub.inValue2, 0.0625);
        engine.setInput(this.sub.inValue1, Math.exp((Math.log(0.0625) + Math.log(1.0)) / 2.0));
        WaveData data = new WaveData(2, this.blockSize.intValue());
        mixer.inAudio0.write(data);
        mixer.inAudio1.write(data);
        Port.transfer(mixer.inAudio0, mixer.outAudio);
    }

    @Override
    public void initGui(Engine engine, JPanel panel) {
        super.addDoubleSliderLog(engine, panel, this.sub.inValue1, "Delay: ", 0.0625, 1.0, Double.NaN);
        double min = 0.4;
        double max = 0.8;
        super.addDoubleSliderLinear(engine, panel, "Duration: ", 0.4, 0.8, 0.6000000000000001, new SoundEffect.SliderListener(){

            @Override
            public void apply(Engine engine, double value) {
                double normalized = (value - 0.4) / 0.4;
                double logMin = Math.log(Math.abs(0.4));
                double logMax = Math.log(Math.abs(0.8));
                double scaled = logMin + normalized * (logMax - logMin);
                double result = Math.exp(scaled);
                engine.setInput(((Echo)Echo.this).backVolume.inVolume, result);
                double backL = 1.0 / (1.0 - result) - 1.0;
                double correction = (1.0 + 1.0 / backL) / 2.0;
                engine.setInput(((Echo)Echo.this).forwVolume.inVolume, correction);
            }
        });
        super.addDoubleSliderLog(engine, panel, this.pitchShift.inRatio, "Pitch Shift: ", 0.9, 1.111, 1.0);
    }
}

