/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.SharpToWave;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.WaveToSharp;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PhaseLockedVocoder;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PitchShiftOcean;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PitchShiftVocoder;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.PitchShiftRollers;
import org.corebounce.decklight.bouncelets.signal.values.Double;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class PitchShift
extends SoundEffect {
    private PitchShiftOcean pitchShift;
    private Double ratio = new Double();
    private int mode = 0;

    @Override
    public void initEngine(Engine engine) {
        if (this.mode < 3) {
            if (this.mode == 0) {
                super.init(engine, PowerOf2.p64);
            } else if (this.mode == 1) {
                super.init(engine, PowerOf2.p128);
            } else {
                super.init(engine, PowerOf2.p256);
            }
            this.pitchShift = new PitchShiftOcean();
            super.addFourierEffect(engine, this.pitchShift, PowerOf2.p512);
            engine.addBouncelets(this.ratio);
            engine.connect(this.ratio.outDouble, this.pitchShift.inRatio);
            engine.setInput(this.wave2spectrum.inOverlap(), PowerOf2.p8);
            if (this.mode == 0) {
                engine.setInput(this.pitchShift.inZeroPadding, PowerOf2.p4);
                engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p512);
            } else if (this.mode == 1) {
                engine.setInput(this.pitchShift.inZeroPadding, PowerOf2.p4);
                engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p1024);
            } else {
                engine.setInput(this.pitchShift.inZeroPadding, PowerOf2.p2);
                engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p2048);
            }
        } else if (this.mode == 4) {
            super.init(engine, PowerOf2.p16);
            PitchShiftRollers rollers = new PitchShiftRollers();
            engine.addBouncelets(rollers, this.ratio);
            engine.connect(this.sourcePort, rollers.inAudio);
            engine.connect(rollers.outAudio, this.targetPort);
            engine.connect(this.ratio.outDouble, rollers.inRatio);
        } else if (this.mode == 3) {
            super.init(engine, PowerOf2.p1024);
            WaveToSharp wave2sharp = new WaveToSharp();
            PitchShiftVocoder voc = new PitchShiftVocoder();
            SharpToWave sharp2wave = new SharpToWave();
            engine.addBouncelets(wave2sharp, voc, sharp2wave);
            engine.connect(this.sourcePort, wave2sharp.getInAudio());
            engine.connect(wave2sharp.getOutSpectrum(), voc.inSpectrum);
            engine.connect(voc.outSpectrum, sharp2wave.inSpectrum);
            engine.connect(sharp2wave.outAudio, this.targetPort);
            engine.setInput(wave2sharp.getInMode(), HqxMode.DOUBLE_LOW);
            engine.setInput(voc.inPickMode, PhaseLockedVocoder.PickMode.LogScale);
            engine.setInput(voc.inPeakCount, 400);
            engine.setInput(voc.inMerging, true);
            engine.setInput(voc.inFastApprox, false);
            engine.addBouncelets(this.ratio);
            engine.connect(this.ratio.outDouble, voc.inRatio);
        }
    }

    @Override
    public void initGui(final Engine engine, JPanel panel) {
        super.addDoubleSliderLog(engine, panel, this.ratio.inDouble, "Ratio: ", 0.625, 1.6, 1.6);
        JLabel label = new JLabel("Mode: ");
        panel.add(label);
        final JComboBox<String> combo = new JComboBox<String>(new String[]{"Voice", "Mixed 1", "Mixed 2", "Music", "Rollers"});
        panel.add(combo);
        combo.setSelectedIndex(this.mode);
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!combo.isEnabled()) {
                    return;
                }
                PitchShift.this.mode = combo.getSelectedIndex();
                PitchShift.this.rebuildEngine(engine);
            }
        });
    }

    @Override
    public void initMode(SoundEffect.SourceMode srcMode) {
        this.mode = srcMode == SoundEffect.SourceMode.AUDIO_IN ? 0 : (srcMode == SoundEffect.SourceMode.MIXED ? 1 : 3);
    }
}

