/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.net.MalformedURLException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.convert.channels.MergeChannels;
import org.corebounce.decklight.bouncelets.audio.convert.channels.SplitChannels;
import org.corebounce.decklight.bouncelets.audio.convert.channels.ToMono;
import org.corebounce.decklight.bouncelets.audio.convert.channels.ToMulti;
import org.corebounce.decklight.bouncelets.audio.convert.format.SpectrumToWave;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.effect.base.Volume;
import org.corebounce.decklight.bouncelets.audio.flow.Mixer;
import org.corebounce.decklight.bouncelets.audio.line.AudioIn;
import org.corebounce.decklight.bouncelets.audio.line.AudioOut;
import org.corebounce.decklight.bouncelets.audio.line.Silence;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.macro.GhostTwin;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.LevelMeter;
import org.corebounce.pitchbox.Settings;
import org.corebounce.pitchbox.SharedFileReader;

public abstract class SoundEffect {
    private static SharedFileReader fileReader;
    private ToMulti channer;
    private AudioIn audioIn;
    private AudioOut audioOut;
    private LevelMeter levelMeter;
    protected WaveToSpectrum wave2spectrum = null;
    protected SpectrumToWave spectrum2wave = null;
    protected OutputPort<WaveData> sourcePort;
    protected InputPort<WaveData> targetPort;
    protected PowerOf2 blockSize;

    protected final void init(Engine engine, PowerOf2 myBlockSize) {
        ToMono toMono;
        Settings s = Settings.instance();
        this.blockSize = s.getMinBlockSize();
        if (!s.isExactBlockSize() && myBlockSize.compareTo(this.blockSize) > 0) {
            this.blockSize = myBlockSize;
        }
        AudioConfig.setBlockSize(this.blockSize);
        AudioConfig.setBuffers(s.getNbBuffers());
        AudioConfig.setSampleRate(s.getSampleRate());
        OutAudio recPort = null;
        int nbInChans = s.getNumChans() + s.getFirstRecordChanIndex();
        if (engine.isAudioInActive()) {
            this.audioIn = new AudioIn();
            engine.addBouncelets(this.audioIn);
            engine.setInput(this.audioIn.inChannels, nbInChans);
            engine.setInput(this.audioIn.inDevice, s.getRecordDeviceNum());
            recPort = this.audioIn.outAudio;
            if (s.getFirstRecordChanIndex() > 0) {
                SplitChannels splitter = new SplitChannels();
                MergeChannels merger = new MergeChannels();
                engine.addBouncelets(splitter, merger);
                engine.connect(this.audioIn.outAudio, splitter.inAudio);
                int i = 0;
                while (i < s.getNumChans()) {
                    engine.connect(splitter.outAudios[i + s.getFirstRecordChanIndex()], merger.inAudios[i]);
                    ++i;
                }
                recPort = merger.outAudio;
            }
        }
        if (engine.getFile() != null) {
            boolean renew;
            boolean bl = renew = fileReader == null;
            if (fileReader == null) {
                fileReader = new SharedFileReader();
            }
            engine.addBouncelets(fileReader);
            this.channer = new ToMulti();
            engine.addBouncelets(this.channer);
            engine.setInput(this.channer.inChannels, Settings.instance().getNumChans());
            engine.connect(SoundEffect.fileReader.outAudio, this.channer.inAudio);
            if (renew) {
                try {
                    engine.setInput(SoundEffect.fileReader.inFile, engine.getFile().toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            if (fileReader != null) {
                fileReader.kill();
            }
            fileReader = null;
        }
        this.levelMeter = new LevelMeter();
        engine.addBouncelets(this.levelMeter);
        if (engine.isAudioInActive() && engine.getFile() != null) {
            Volume fileVolume = new Volume();
            Volume recVolume = new Volume();
            Mixer mixer = new Mixer();
            engine.addBouncelets(fileVolume, recVolume, mixer);
            engine.setInput(fileVolume.inVolume, 0.2);
            engine.setInput(recVolume.inVolume, 0.8);
            engine.setInput(mixer.inNormalized, false);
            engine.connect(recPort, recVolume.inAudio);
            engine.connect(recVolume.outAudio, mixer.inAudio0);
            engine.connect(this.channer.outAudio, fileVolume.inAudio);
            engine.connect(fileVolume.outAudio, mixer.inAudio1);
            engine.connect(mixer.outAudio, this.levelMeter.inAudio);
        } else if (engine.isAudioInActive()) {
            engine.connect(recPort, this.levelMeter.inAudio);
        } else if (engine.getFile() != null) {
            engine.connect(this.channer.outAudio, this.levelMeter.inAudio);
        } else {
            Silence silence = new Silence();
            engine.addBouncelets(silence);
            engine.connect(silence.outAudio, this.levelMeter.inAudio);
        }
        this.sourcePort = this.levelMeter.outAudio;
        if (s.isProcessMono()) {
            ToMono toMono2 = new ToMono();
            engine.addBouncelets(toMono2);
            engine.connect(this.sourcePort, toMono2.inAudio);
            this.sourcePort = toMono2.outAudio;
        }
        Volume volume = new Volume();
        this.audioOut = new AudioOut();
        engine.addBouncelets(volume, this.audioOut);
        engine.setInput(this.audioOut.inDevice(), s.getPlayDeviceNum());
        if (s.isDupOutputChans()) {
            toMono = new ToMono();
            ToMulti toStereo = new ToMulti();
            engine.addBouncelets(toMono, toStereo);
            engine.connect(volume.outAudio, toMono.inAudio);
            engine.connect(toMono.outAudio, toStereo.inAudio);
            engine.connect(toStereo.outAudio, this.audioOut.inAudio());
        } else if (s.isProcessMono() || s.getNumChans() == 1) {
            toMono = new ToMono();
            engine.addBouncelets(toMono);
            engine.connect(volume.outAudio, toMono.inAudio);
            engine.connect(toMono.outAudio, this.audioOut.inAudio());
        } else {
            engine.connect(volume.outAudio, this.audioOut.inAudio());
        }
        engine.setInput(volume.inVolume, Math.sqrt(0.5));
        this.targetPort = volume.inAudio;
        if (s.getFirstPlayChanIndex() > 0) {
            SplitChannels splitter = new SplitChannels();
            MergeChannels merger = new MergeChannels();
            Volume silencer = new Volume();
            engine.addBouncelets(splitter, merger, silencer);
            engine.setInput(silencer.inVolume, 0.0);
            engine.connect(splitter.outAudio0, silencer.inAudio);
            int i = 0;
            while (i < s.getFirstPlayChanIndex()) {
                engine.connect(silencer.outAudio, merger.inAudios[i]);
                ++i;
            }
            i = 0;
            while (i < s.getNumChans()) {
                engine.connect(splitter.outAudios[i], merger.inAudios[s.getFirstPlayChanIndex() + i]);
                ++i;
            }
            engine.connect(merger.outAudio, this.targetPort);
            this.targetPort = splitter.inAudio;
        }
        if (s.isProcessMono()) {
            SplitChannels mono = new SplitChannels();
            ToMulti dup = new ToMulti();
            engine.addBouncelets(mono, dup);
            engine.connect(mono.outAudio0, dup.inAudio);
            engine.connect(dup.outAudio, this.targetPort);
            this.targetPort = mono.inAudio;
        }
    }

    private InSpectrum getDefaultInputPort(BounceletBase effect) {
        for (InputPort<?> port : effect.getInputPorts()) {
            if (!port.getName().equals("in") || !(port instanceof InSpectrum)) continue;
            return (InSpectrum)port;
        }
        return null;
    }

    private OutSpectrum getDefaultOutputPort(BounceletBase effect) {
        for (OutputPort<?> port : effect.getOutputPorts()) {
            if (!port.getName().equals("out") || !(port instanceof OutSpectrum)) continue;
            return (OutSpectrum)port;
        }
        return null;
    }

    protected void addFourierEffect(Engine engine, BounceletBase effect, PowerOf2 blockSize) {
        this.addFourierEffect(engine, effect, this.getDefaultInputPort(effect), this.getDefaultOutputPort(effect), blockSize, PowerOf2.p4, true, true);
    }

    protected void addFourierEffect(Engine engine, BounceletBase effect, OutSpectrum outPort, PowerOf2 blockSize) {
        this.addFourierEffect(engine, effect, this.getDefaultInputPort(effect), outPort, blockSize, PowerOf2.p4, true, true);
    }

    protected void addFourierEffect(Engine engine, BounceletBase effect, InSpectrum inPort, OutSpectrum outPort, PowerOf2 blockSize, PowerOf2 overlap, boolean connectFromSource, boolean connectToTarget) {
        WaveToSpectrum wave2spectrum = new WaveToSpectrum();
        engine.addBouncelets(wave2spectrum);
        this.wave2spectrum = wave2spectrum;
        engine.addBouncelets(effect);
        SpectrumToWave spectrum2wave = new SpectrumToWave();
        engine.addBouncelets(spectrum2wave);
        this.spectrum2wave = spectrum2wave;
        if (connectFromSource) {
            engine.connect(this.sourcePort, wave2spectrum.inAudio());
        }
        engine.connect(wave2spectrum.outSpectrum(), inPort);
        engine.connect(outPort, spectrum2wave.inSpectrum());
        if (connectToTarget) {
            engine.connect(spectrum2wave.outAudio(), this.targetPort);
        }
        engine.setInput(wave2spectrum.inWindowSize(), blockSize);
        engine.setInput(wave2spectrum.inOverlap(), overlap);
        if (effect instanceof GhostTwin) {
            GhostTwin ghostTwin = (GhostTwin)((Object)effect);
            WaveToSpectrum[] waveToSpectrumArray = ghostTwin.getTwins();
            int n = waveToSpectrumArray.length;
            int n2 = 0;
            while (n2 < n) {
                WaveToSpectrum w2cGhost = waveToSpectrumArray[n2];
                engine.setInput(w2cGhost.inWindowSize(), blockSize);
                engine.setInput(w2cGhost.inOverlap(), overlap);
                ++n2;
            }
        }
    }

    protected void addDoubleSliderLinear(Engine engine, JPanel panel, InDouble port, String name, double min, double max, double dflt) {
        this.addDoubleSliderLinear(engine, panel, port, name, min, max, dflt, null);
    }

    protected void addDoubleSliderLinear(Engine engine, JPanel panel, String name, double min, double max, double dflt, SliderListener listener) {
        this.addDoubleSliderLinear(engine, panel, null, name, min, max, dflt, listener);
    }

    private void addDoubleSliderLinear(final Engine engine, JPanel panel, final InDouble port, String name, final double min, final double max, double dflt, final SliderListener listener) {
        JLabel label = new JLabel(name);
        panel.add(label);
        int init = (int)((dflt - min) * 100.0 / (max - min) + 0.5);
        final JSlider slider = new JSlider(0, 100, init);
        try {
            slider.setFont(panel.getFont().deriveFont(0.0f));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        panel.add(slider);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int ivalue = slider.getValue();
                double normalized = (double)ivalue / 100.0;
                double result = min + normalized * (max - min);
                if (listener == null) {
                    engine.setInput(port, result);
                } else {
                    listener.apply(engine, result);
                }
            }
        });
        if (listener != null) {
            listener.apply(engine, dflt);
        }
    }

    protected void addDoubleSliderLog(final Engine engine, JPanel panel, final InDouble port, String name, final double min, final double max, double initVal) {
        JLabel label = new JLabel(name);
        panel.add(label);
        final JSlider slider = new JSlider(0, 100, 50);
        try {
            slider.setFont(panel.getFont().deriveFont(0.0f));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        panel.add(slider);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int ivalue = slider.getValue();
                double normalized = (double)ivalue / 100.0;
                double logMin = Math.log(Math.abs(min));
                double logMax = Math.log(Math.abs(max));
                double scaled = logMin + normalized * (logMax - logMin);
                double result = Math.exp(scaled);
                engine.setInput(port, result);
            }
        });
        if (!Double.isNaN(initVal)) {
            double logMin = Math.log(Math.abs(min));
            double logMax = Math.log(Math.abs(max));
            double logValue = Math.log(Math.abs(initVal));
            double normalized = (logValue - logMin) / (logMax - logMin);
            int ivalue = (int)(normalized * 100.0 + 0.5);
            slider.setValue(ivalue);
        }
    }

    protected void addDoubleSliderCbrt(final Engine engine, JPanel panel, final InDouble port, String name, final double min, final double max, double dflt) {
        JLabel label = new JLabel(name);
        panel.add(label);
        double crMin = Math.cbrt(min);
        double crMax = Math.cbrt(max);
        double crValue = Math.cbrt(dflt);
        double normalized = (crValue - crMin) / (crMax - crMin);
        int value = (int)(normalized * 100.0 + 0.5);
        final JSlider slider = new JSlider(0, 100, value);
        engine.setInput(port, dflt);
        try {
            slider.setFont(panel.getFont().deriveFont(0.0f));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        panel.add(slider);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int ivalue = slider.getValue();
                double value = (double)ivalue * (max - min) / 100.0 + min;
                double normalized = (value - min) / (max - min);
                double crMin = Math.cbrt(min);
                double crMax = Math.cbrt(max);
                double scaled = crMin + normalized * (crMax - crMin);
                double result = Math.pow(scaled, 3.0);
                engine.setInput(port, result);
            }
        });
    }

    public float getRecordLevel() {
        if (this.levelMeter == null) {
            return -50.0f;
        }
        return this.levelMeter.getLevel();
    }

    public abstract void initEngine(Engine var1);

    public abstract void initGui(Engine var1, JPanel var2);

    public void flush(Engine engine) {
    }

    public void initMode(SourceMode mode) {
    }

    protected void rebuildEngine(Engine engine) {
        engine.flush();
        engine.init();
        this.initEngine(engine);
        engine.commitAndPlay();
    }

    protected static abstract class SliderListener {
        protected SliderListener() {
        }

        public abstract void apply(Engine var1, double var2);
    }

    public static enum SourceMode {
        AUDIO_IN,
        MIXED,
        FILE;

    }
}

