/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.effect.base.Volume;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class Thor
extends SoundEffect {
    private int mode;

    @Override
    public void initEngine(Engine engine) {
        if (this.mode == 0) {
            super.init(engine, PowerOf2.p128);
        } else if (this.mode == 1) {
            super.init(engine, PowerOf2.p256);
        } else {
            super.init(engine, PowerOf2.p512);
        }
        WaveToSpectrum wave2spectrum = new WaveToSpectrum();
        org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.Thor effect = new org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.Thor();
        Volume volume = new Volume();
        engine.addBouncelets(wave2spectrum, effect, volume);
        engine.connect(this.sourcePort, wave2spectrum.inAudio());
        engine.connect(wave2spectrum.outSpectrum(), effect.inSpectrum());
        engine.connect(effect.outAudio(), volume.inAudio);
        engine.connect(volume.outAudio, this.targetPort);
        engine.setInput(volume.inVolume, Math.sqrt(3.0));
        if (this.mode == 0) {
            engine.setInput(wave2spectrum.inWindowSize(), PowerOf2.p512);
            engine.setInput(effect.zeroPad(), PowerOf2.p4);
        } else if (this.mode == 1) {
            engine.setInput(wave2spectrum.inWindowSize(), PowerOf2.p1024);
            engine.setInput(effect.zeroPad(), PowerOf2.p2);
        } else {
            engine.setInput(wave2spectrum.inWindowSize(), PowerOf2.p2048);
            engine.setInput(effect.zeroPad(), PowerOf2.p1);
        }
    }

    @Override
    public void initGui(final Engine engine, JPanel panel) {
        JLabel label = new JLabel("Mode: ");
        panel.add(label);
        final JComboBox<String> combo = new JComboBox<String>(new String[]{"Voice", "Mixed", "Music"});
        panel.add(combo);
        combo.setSelectedIndex(this.mode);
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!combo.isEnabled()) {
                    return;
                }
                Thor.this.mode = combo.getSelectedIndex();
                Thor.this.rebuildEngine(engine);
            }
        });
    }

    @Override
    public void initMode(SoundEffect.SourceMode srcMode) {
        this.mode = srcMode == SoundEffect.SourceMode.AUDIO_IN ? 0 : (srcMode == SoundEffect.SourceMode.MIXED ? 1 : 2);
    }
}

