/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.effects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.corebounce.decklight.bouncelets.audio.analysis.Formants;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter.CrossSynth;
import org.corebounce.decklight.bouncelets.music.PlayTone;
import org.corebounce.decklight.bouncelets.music.effect.Cosmos;
import org.corebounce.decklight.bouncelets.music.effect.Saturate;
import org.corebounce.decklight.bouncelets.music.ports.OutTone;
import org.corebounce.decklight.bouncelets.music.tone.Saw;
import org.corebounce.decklight.bouncelets.music.tone.Sine;
import org.corebounce.decklight.bouncelets.music.tone.Square;
import org.corebounce.decklight.bouncelets.music.tone.Synth;
import org.corebounce.decklight.bouncelets.music.tone.Triangle;
import org.corebounce.pitchbox.Engine;
import org.corebounce.pitchbox.effects.SoundEffect;

public class Vocoder
extends SoundEffect {
    private OutTone curSource = null;
    private Cosmos cosmos;
    private CrossSynth vocoder;
    private WaveToSpectrum wave2spectrumF;
    private Saw saw = new Saw();
    private Sine sine = new Sine();
    private Triangle triangle = new Triangle();
    private Square square = new Square();
    private Synth synth = new Synth();
    private Saturate saturate = new Saturate();
    private PlayTone play = new PlayTone();
    private int mode = 0;

    @Override
    public void initEngine(Engine engine) {
        if (this.mode == 0) {
            super.init(engine, PowerOf2.p64);
        } else if (this.mode == 1) {
            super.init(engine, PowerOf2.p128);
        } else {
            super.init(engine, PowerOf2.p256);
        }
        this.cosmos = new Cosmos();
        this.wave2spectrumF = new WaveToSpectrum();
        Formants formants = new Formants();
        this.vocoder = new CrossSynth();
        engine.addBouncelets(this.saw, this.sine, this.triangle, this.square, this.synth, this.saturate, this.cosmos, this.play, this.wave2spectrumF, formants);
        super.addFourierEffect(engine, this.vocoder, this.vocoder.inSpectrum, this.vocoder.outSpectrum, PowerOf2.p512, PowerOf2.p8, false, true);
        engine.connect(this.saw.outTone, this.saturate.inTone);
        engine.setInput(this.saturate.inLevel, 3.0);
        engine.setInput(this.synth.inMultiplier, 3);
        engine.setInput(this.synth.inCentroid, 1.0);
        engine.connect(this.cosmos.outTone(), this.play.inTone);
        engine.connect(this.play.outAudio, this.wave2spectrum.inAudio());
        engine.connect(this.sourcePort, this.wave2spectrumF.inAudio());
        engine.connect(this.wave2spectrumF.outSpectrum(), formants.inSpectrum);
        engine.connect(formants.outShape, this.vocoder.inShape);
        this.setCurSource(engine, this.saw.outTone);
        engine.setInput(this.cosmos.inDepth(), 4.0);
        engine.setInput(this.wave2spectrum.inOverlap(), PowerOf2.p8);
        engine.setInput(this.wave2spectrumF.inOverlap(), PowerOf2.p8);
        if (this.mode == 0) {
            engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p512);
            engine.setInput(this.wave2spectrumF.inWindowSize(), PowerOf2.p512);
        } else if (this.mode == 1) {
            engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p1024);
            engine.setInput(this.wave2spectrumF.inWindowSize(), PowerOf2.p1024);
        } else {
            engine.setInput(this.wave2spectrum.inWindowSize(), PowerOf2.p2048);
            engine.setInput(this.wave2spectrumF.inWindowSize(), PowerOf2.p2048);
        }
    }

    @Override
    public void initGui(final Engine engine, JPanel panel) {
        this.initSimplified(engine, panel, this.saw, this.sine, this.triangle, this.square, this.saturate, this.synth);
        super.addDoubleSliderLog(engine, panel, this.play.inFrequency, "Frequency: ", 40.0, 400.0, 165.0);
        JLabel label = new JLabel("Mode: ");
        panel.add(label);
        final JComboBox<String> combo = new JComboBox<String>(new String[]{"Voice", "Mixed", "Music"});
        panel.add(combo);
        combo.setSelectedIndex(this.mode);
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!combo.isEnabled()) {
                    return;
                }
                Vocoder.this.mode = combo.getSelectedIndex();
                Vocoder.this.rebuildEngine(engine);
            }
        });
    }

    void initSimplified(final Engine engine, JPanel panel, Saw saw, Sine sine, Triangle triangle, Square square, Saturate saturate, Synth synth) {
        JLabel lblTone = new JLabel("Tone: ");
        panel.add(lblTone);
        final JComboBox<String> toneCombo = new JComboBox<String>();
        panel.add(toneCombo);
        toneCombo.addItem("Cosmos");
        toneCombo.addItem("Space");
        toneCombo.addItem("Galaxy");
        toneCombo.addItem("Star");
        toneCombo.addItem("Moon");
        toneCombo.addItem("Pulsar");
        toneCombo.addItem("Nebula");
        toneCombo.addItem("Supernova");
        toneCombo.addItem("Dark Mater");
        toneCombo.addItem("Wormhole");
        toneCombo.addItem("Black Hole");
        final OutTone[] sources = new OutTone[]{saw.outTone, sine.outTone, square.outTone, synth.outTone, sine.outTone, square.outTone, square.outTone, saw.outTone, square.outTone, sine.outTone, square.outTone};
        final double[] depths = new double[]{4.0, 4.0, 4.0, 0.0, 3.0, 3.0, 4.0, 3.0, 4.0, 4.0, 4.0};
        final int[] nums = new int[]{1, 3, 1, 1, 2, 201, 1, 5, 2, 30, 7};
        final int[] dens = new int[]{1, 2, 1, 1, 1, 199, 2, 2, 5, 17, 10};
        final double[] centroids = new double[]{0.25, 0.25, 0.25, 0.5, 0.5, 0.25, 0.6, 0.25, 0.25, 0.25, 0.75};
        toneCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = toneCombo.getSelectedIndex();
                if (index >= 0) {
                    Vocoder.this.setCurSource(engine, sources[index]);
                    engine.setInput(Vocoder.this.cosmos.inDepth(), depths[index]);
                    engine.setInput(Vocoder.this.cosmos.inNumerator(), nums[index]);
                    engine.setInput(Vocoder.this.cosmos.inDenominator(), dens[index]);
                    engine.setInput(((Vocoder)Vocoder.this).vocoder.inWhitening, centroids[index]);
                }
            }
        });
    }

    private void setCurSource(Engine engine, OutTone sourceTone) {
        if (this.curSource != null) {
            engine.disconnect(this.curSource, this.cosmos.inTone());
        }
        engine.connect(sourceTone, this.cosmos.inTone());
        this.curSource = sourceTone;
    }

    @Override
    public void initMode(SoundEffect.SourceMode srcMode) {
        this.mode = srcMode == SoundEffect.SourceMode.AUDIO_IN ? 0 : (srcMode == SoundEffect.SourceMode.MIXED ? 1 : 2);
    }
}

