/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.pitchbox.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.UIManager;

public class AwtTools {
    private static final Object dndLock = new Object();
    private static boolean isDnd = false;

    private AwtTools() {
    }

    public static void setupHighQuality(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public static void setupHighSpeed(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    public static void centerWindowOnScreen(Window window) {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = gEnv.getCenterPoint();
        Dimension wDim = window.getSize();
        int x = center.x - wDim.width / 2;
        int y = center.y - wDim.height / 2;
        window.setLocation(x, y);
    }

    public static void centerWindowOn(Window window, Component parent) {
        window.setLocationRelativeTo(parent);
    }

    public static Point getLocationInWindow(Component cmp) {
        Point location = cmp.getLocation();
        Container parent = cmp.getParent();
        while (!(parent instanceof Window)) {
            Point parLocation = parent.getLocation();
            location.setLocation(location.x + parLocation.x, location.y + parLocation.y);
            parent = parent.getParent();
        }
        return location;
    }

    public static Window getWindow(Component cmp) {
        Container parent = cmp.getParent();
        while (!(parent instanceof Window)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    public static void switchToNativeLookAndFeel() {
        try {
            String name = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void switchToMetalLookAndFeel() {
        try {
            String name = UIManager.getCrossPlatformLookAndFeelClassName();
            UIManager.setLookAndFeel(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean switchToNimbusLookAndFeel() {
        boolean found = false;
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    found = true;
                    break;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDnd() {
        Object object = dndLock;
        synchronized (object) {
            return isDnd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDnd(boolean value) {
        Object object = dndLock;
        synchronized (object) {
            isDnd = value;
            dndLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitDndEnd() {
        Object object = dndLock;
        synchronized (object) {
            while (isDnd) {
                try {
                    dndLock.wait();
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            return true;
        }
    }
}

