/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.test;

import java.io.File;
import java.text.DecimalFormat;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.Resample;
import org.corebounce.decklight.bouncelets.audio.line.FileReader;
import org.corebounce.decklight.bouncelets.audio.line.FileWriter;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.tools.SimpleEngine;

public class TestResample {
    private static final String TEST_DIR = "C:\\Users\\Nicolas\\Desktop\\Tests";
    private SimpleEngine engine;

    private void test(File inFile, File outFile) throws Exception {
        System.out.println("Processing " + inFile.getPath());
        this.engine = new SimpleEngine();
        this.engine.init();
        FileReader fileReader = new FileReader();
        fileReader.setRealTime(false);
        Resample resample = new Resample();
        FileWriter fileWriter = new FileWriter();
        this.engine.addBouncelets(new BounceletBase[]{fileReader, resample, fileWriter});
        this.engine.connect((OutputPort)fileReader.outAudio, (InputPort)resample.inAudio);
        this.engine.connect((OutputPort)resample.outAudio, (InputPort)fileWriter.inAudio);
        this.engine.setInput((InputPort)fileReader.inFile, (Object)inFile.toURI().toURL());
        this.engine.setInput((InputPort)resample.inQuality, (Object)3);
        this.engine.setInput((InputPort)resample.inRatio, (Object)0.8);
        this.engine.setInput((InputPort)fileWriter.inFile, (Object)outFile.toURI().toURL());
        this.engine.commitPlayAndWaitForStop();
        this.engine.dispose();
    }

    private void testAll(File directory) throws Exception {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().endsWith(".mp3")) {
                String path = file.getPath();
                String outPath = String.valueOf(path.substring(0, path.length() - ".mp3".length())) + ".wav";
                File outFile = new File(outPath);
                this.test(file, outFile);
            }
            ++n2;
        }
    }

    public static void main(String[] args) throws Exception {
        long clock = System.currentTimeMillis();
        TestResample t = new TestResample();
        t.testAll(new File(TEST_DIR));
        double seconds = (double)(System.currentTimeMillis() - clock) / 1000.0;
        DecimalFormat f = new DecimalFormat("#0.00");
        System.out.println("Time elapsed [s]: " + f.format(seconds));
    }
}

