/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CacheMap<K, V>
extends AbstractMap<K, V> {
    private transient EntrySet entrySet;
    private final Map<K, CacheReference> target = new LinkedHashMap<K, CacheReference>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    private CacheReference wrap(K key, V item) {
        return new CacheReference(key, item);
    }

    private V unwrap(SoftReference<V> ref) {
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    private void poll() {
        Reference<V> ref = this.queue.poll();
        while (ref != null) {
            CacheReference cRef = (CacheReference)ref;
            this.remove(cRef.getKey());
            ref = this.queue.poll();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.poll();
        return this.target.containsKey(key);
    }

    @Override
    public V get(Object key) {
        this.poll();
        return this.unwrap(this.target.get(key));
    }

    @Override
    public V put(K key, V value) {
        this.poll();
        return this.unwrap(this.target.put(key, this.wrap(key, value)));
    }

    @Override
    public V remove(Object key) {
        this.poll();
        return this.unwrap(this.target.remove(key));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.poll();
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        this.poll();
        return this.target.keySet();
    }

    @Override
    public String toString() {
        this.poll();
        return this.target.toString();
    }

    @Override
    public boolean equals(Object o) {
        this.poll();
        if (o instanceof CacheMap) {
            CacheMap other = (CacheMap)o;
            other.poll();
            return this.target.equals(other.target);
        }
        return false;
    }

    @Override
    public int hashCode() {
        this.poll();
        return this.target.hashCode();
    }

    private class CacheEntry
    implements Map.Entry<K, V> {
        private final K key;

        public CacheEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return CacheMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return CacheMap.this.put(this.key, value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CacheEntry) {
                CacheEntry other = (CacheEntry)obj;
                return this.key.equals(other.key);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private class CacheReference
    extends SoftReference<V> {
        private final K key;

        public CacheReference(K key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }

        public CacheReference(K key, V referent) {
            super(referent);
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheReference) {
                CacheReference other = (CacheReference)obj;
                Object otherItem = other.get();
                Object thisItem = this.get();
                if (otherItem == null) {
                    return thisItem == null;
                }
                return otherItem.equals(thisItem);
            }
            return false;
        }

        public int hashCode() {
            Object item = this.get();
            if (item == null) {
                return 0;
            }
            return item.hashCode();
        }

        public String toString() {
            return "" + this.get();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            CacheMap.this.poll();
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return CacheMap.this.size();
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            return CacheMap.this.put(o.getKey(), o.getValue()) == null;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return CacheMap.this.containsKey(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return CacheMap.this.remove(o) != null;
        }

        private class EntrySetIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<K> keyIter;

            private EntrySetIterator() {
                this.keyIter = CacheMap.this.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keyIter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Object key = this.keyIter.next();
                return new CacheEntry(key);
            }

            @Override
            public void remove() {
                this.keyIter.remove();
            }
        }
    }
}

