/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.corebounce.common.utils.AppUtils;
import org.corebounce.common.utils.Platform;
import org.corebounce.utils.Pair;

public class LibraryLoader {
    private static Preferences prefs = Preferences.userNodeForPackage(LibraryLoader.class);
    private static Set<String> libFiles = new HashSet<String>();
    private static final Set<Pair<Class<?>, String>> loadedLibraries = new HashSet();

    public static synchronized void loadLibrary(Class<?> forClass, String libName) throws IOException {
        Pair key = new Pair(forClass, libName);
        if (loadedLibraries.contains(key)) {
            return;
        }
        loadedLibraries.add(key);
        String osName = Platform.getCanonicalPlatformName();
        String osArch = System.getProperty("os.arch");
        libName = String.valueOf(libName) + "-" + osName + "-" + osArch;
        libName = System.mapLibraryName(libName);
        File appDir = AppUtils.getApplicationDirectory(forClass);
        File nativeDir = new File(appDir, "native");
        File libFile = new File(nativeDir, libName);
        System.load(libFile.getAbsolutePath());
    }

    private static void cleanupAndAdd(String libFileName) {
        String[] fileArr;
        String oldFiles = prefs.get("Libraries", "");
        String[] stringArray = fileArr = oldFiles.split(Pattern.quote(File.pathSeparator));
        int n = fileArr.length;
        int n2 = 0;
        while (n2 < n) {
            String oldFile = stringArray[n2];
            if (!libFiles.contains(oldFile)) {
                new File(oldFile).delete();
            }
            ++n2;
        }
        libFiles.add(libFileName);
        StringBuilder newFiles = new StringBuilder();
        for (String file : libFiles) {
            if (newFiles.length() > 0) {
                newFiles.append(File.separator);
            }
            newFiles.append(file);
        }
        prefs.put("Libraries", newFiles.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }
}

