/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.utils;

import org.corebounce.utils.Severity;

public class Log {
    private static final String LOG_LEVEL = "LogLevel";
    private static final String BASE_PACKAGE = "org.corebounce.decklight";
    private static Severity MinSeverity = null;

    public static Severity getLoggedMinSeverity() {
        if (MinSeverity == null) {
            MinSeverity = Severity.Warning;
            String value = System.getProperty(LOG_LEVEL);
            if (value != null) {
                try {
                    MinSeverity = Enum.valueOf(Severity.class, value);
                }
                catch (IllegalArgumentException ex) {
                    System.err.println("Warning: invalid log level: " + value);
                }
            }
        }
        return MinSeverity;
    }

    private static boolean isWorth(Severity severity) {
        return severity.ordinal() >= Log.getLoggedMinSeverity().ordinal();
    }

    private static String className(StackTraceElement elt) {
        String result = elt.getClassName();
        if (result.startsWith(BASE_PACKAGE)) {
            result = result.substring(BASE_PACKAGE.length());
        }
        return result;
    }

    private static String getContext(int nbFrames) {
        if (MinSeverity != Severity.Debug) {
            return "";
        }
        Exception ex = new Exception();
        StackTraceElement[] stack = ex.getStackTrace();
        if (stack == null) {
            return "";
        }
        int index = 0;
        while (index < stack.length) {
            String className = stack[index].getClassName();
            if (!className.equals(Log.class.getName())) {
                if (nbFrames <= 0) {
                    return " {" + Log.className(stack[index]) + "." + stack[index].getMethodName() + "; \"" + stack[index].getFileName() + "\" line " + stack[index].getLineNumber() + "}";
                }
                --nbFrames;
            }
            ++index;
        }
        return "";
    }

    public static void message(int nbFrames, Severity severity, String message, Object ... args) {
        if (Log.isWorth(severity)) {
            String result = Log.format(message, args);
            if (severity.ordinal() >= Severity.Error.ordinal()) {
                System.err.println((Object)((Object)severity) + Log.getContext(nbFrames) + ": " + result);
            } else {
                System.out.println((Object)((Object)severity) + Log.getContext(nbFrames) + ": " + result);
            }
        }
    }

    public static void message(Severity severity, String message, Object ... args) {
        Log.message(0, severity, message, args);
    }

    public static String format(String message, Object ... args) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            char ch = message.charAt(i);
            if (ch == '{' && i <= message.length() - 3) {
                try {
                    int j = message.indexOf(125, i + 1);
                    int index = Integer.parseInt(message.substring(i + 1, j));
                    result.append(args[index]);
                    i = j + 1;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ++i;
                }
                continue;
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    public static void debug(String message, Object ... args) {
        Log.message(Severity.Debug, message, args);
    }

    public static void info(String message, Object ... args) {
        Log.message(Severity.Info, message, args);
    }

    public static void warning(String message, Object ... args) {
        Log.message(Severity.Warning, message, args);
    }

    public static void error(String message, Object ... args) {
        Log.message(Severity.Error, message, args);
    }

    public static void catastroph(String message, Object ... args) {
        Log.message(Severity.Catastroph, message, args);
    }
}

