/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class ShaolinMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
Cloneable,
Serializable {
    private Comparator<? super K> comparator = null;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public ShaolinMap() {
    }

    public ShaolinMap(Comparator<? super K> c) {
        this.comparator = c;
    }

    public ShaolinMap(Map<? extends K, ? extends V> m) {
        this.putAll(m);
    }

    public ShaolinMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.root == null ? false : (value == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, value));
    }

    private boolean valueSearchNull(Entry<K, V> n) {
        if (n.value == null) {
            return true;
        }
        return ((Entry)n).left != null && this.valueSearchNull(((Entry)n).left) || ((Entry)n).right != null && this.valueSearchNull(((Entry)n).right);
    }

    private boolean valueSearchNonNull(Entry<K, V> n, Object value) {
        if (value.equals(n.value)) {
            return true;
        }
        return ((Entry)n).left != null && this.valueSearchNonNull(((Entry)n).left, value) || ((Entry)n).right != null && this.valueSearchNonNull(((Entry)n).right, value);
    }

    @Override
    public V get(Object key) {
        Entry<K, V> p = this.getEntry(key);
        return p == null ? null : (V)p.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return ShaolinMap.key(this.firstEntry());
    }

    @Override
    public K lastKey() {
        return ShaolinMap.key(this.lastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && c.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    private Entry<K, V> getEntry(Object key) {
        Entry p = this.root;
        Object k = key;
        while (p != null) {
            int cmp = this.compare(k, p.key);
            if (cmp == 0) {
                return p;
            }
            p = cmp < 0 ? p.left : p.right;
        }
        return null;
    }

    private Entry<K, V> getCeilEntry(K key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) == 0) {
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right == null) break;
            p = p.right;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.right) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry<K, V> getPrecedingEntry(K key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left == null) break;
            p = p.left;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.left) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static <K> K key(Entry<K, ?> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    @Override
    public V put(K key, V value) {
        Entry t = this.root;
        if (t == null) {
            this.incrementSize();
            this.root = new Entry<K, V>(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = (Entry)new Entry<K, V>(key, value, t);
                Entry current = t;
                while (current != null) {
                    Entry entry = current;
                    entry.subSize = entry.subSize + 1;
                    current = current.parent;
                }
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = (Entry)new Entry<K, V>(key, value, t);
        Entry current = t;
        while (current != null) {
            Entry entry = current;
            entry.subSize = entry.subSize + 1;
            current = current.parent;
        }
        this.fixAfterInsertion(t.right);
        return null;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        ShaolinMap clone = null;
        try {
            clone = (ShaolinMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator();
                }

                @Override
                public int size() {
                    return ShaolinMap.this.size();
                }

                @Override
                public boolean contains(Object o) {
                    return ShaolinMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    int oldSize = ShaolinMap.this.size;
                    ShaolinMap.this.remove(o);
                    return ShaolinMap.this.size != oldSize;
                }

                @Override
                public void clear() {
                    ShaolinMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return ShaolinMap.this.size();
                }

                @Override
                public boolean contains(Object o) {
                    Map.Entry e = ShaolinMap.this.firstEntry();
                    while (e != null) {
                        if (ShaolinMap.valEquals(((Entry)e).getValue(), o)) {
                            return true;
                        }
                        e = ShaolinMap.this.successor((Entry)e);
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    Map.Entry e = ShaolinMap.this.firstEntry();
                    while (e != null) {
                        if (ShaolinMap.valEquals(((Entry)e).getValue(), o)) {
                            ShaolinMap.this.deleteEntry((Entry)e);
                            return true;
                        }
                        e = ShaolinMap.this.successor((Entry)e);
                    }
                    return false;
                }

                @Override
                public void clear() {
                    ShaolinMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = ShaolinMap.this.getEntry(entry.getKey());
                    return p != null && ShaolinMap.valEquals(p.getValue(), value);
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = ShaolinMap.this.getEntry(entry.getKey());
                    if (p != null && ShaolinMap.valEquals(p.getValue(), value)) {
                        ShaolinMap.this.deleteEntry(p);
                        return true;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return ShaolinMap.this.size();
                }

                @Override
                public void clear() {
                    ShaolinMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return new SubMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new SubMap(toKey, true);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new SubMap(fromKey, false);
    }

    private Entry<K, V> getByIndex(int index) {
        if (index < 0 || index >= this.weight()) {
            return null;
        }
        Entry result = this.root;
        int position = result.leftSubSize();
        while (position != index) {
            if (position > index) {
                result = result.left;
                position -= this.entrySubSize(result);
                position -= result.rightSubSize();
                continue;
            }
            assert (position < index);
            if (position + this.entrySubSize(result) > index) break;
            position += this.entrySubSize(result);
            result = result.right;
            position += result.leftSubSize();
        }
        return result;
    }

    public K getKey(int index) throws IndexOutOfBoundsException {
        Entry<K, V> entry = this.getByIndex(index);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.key;
    }

    public V getValue(int index) throws IndexOutOfBoundsException {
        Entry<K, V> entry = this.getByIndex(index);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.value;
    }

    public int indexOfKey(Object key) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return -1;
        }
        return this.indexOfEntry(entry);
    }

    private int indexOfEntry(Entry<K, V> entry) {
        int index = entry.leftSubSize();
        while (entry.parent != null) {
            if (entry == entry.parent.right) {
                index += entry.parent.leftSubSize() + this.entrySubSize(entry.parent);
            }
            entry = entry.parent;
        }
        return index;
    }

    public K remove(int index) throws IndexOutOfBoundsException {
        Entry<K, V> entry = this.getByIndex(index);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        Object oldValue = entry.key;
        this.deleteEntry(entry);
        return oldValue;
    }

    private int compare(K k1, K k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected int entrySubSize(Entry<K, V> entry) {
        return 1;
    }

    protected int weight() {
        return this.size;
    }

    protected void updateSizes(K key) {
        Entry entry = this.getEntry(key);
        while (entry != null) {
            entry.subSize = entry.leftSubSize() + this.entrySubSize(entry) + entry.rightSubSize();
            entry = entry.parent;
        }
    }

    @Override
    public Entry<K, V> firstEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    @Override
    public Entry<K, V> lastEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    private Entry<K, V> successor(Entry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static <K, V> boolean colorOf(Entry<K, V> p) {
        return p == null ? true : p.color;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> p) {
        return p == null ? null : ((Entry)p).parent;
    }

    private static <K, V> void setColor(Entry<K, V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> p) {
        return p == null ? null : ((Entry)p).left;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> p) {
        return p == null ? null : ((Entry)p).right;
    }

    private void rotateLeft(Entry<K, V> p) {
        Entry r = ((Entry)p).right;
        ((Entry)p).right = r.left;
        if (r.left != null) {
            r.left.parent = (Entry)p;
        }
        r.parent = ((Entry)p).parent;
        if (((Entry)p).parent == null) {
            this.root = r;
        } else if (((Entry)p).parent.left == p) {
            ((Entry)p).parent.left = r;
        } else {
            ((Entry)p).parent.right = r;
        }
        r.left = (Entry)p;
        ((Entry)p).parent = r;
        r.subSize = ((Entry)p).subSize;
        ((Entry)p).subSize = ((Entry)p).leftSubSize() + ((Entry)p).rightSubSize() + this.entrySubSize(p);
        assert (r.subSize == r.leftSubSize() + r.rightSubSize() + this.entrySubSize(r));
    }

    private void rotateRight(Entry<K, V> p) {
        Entry l = ((Entry)p).left;
        ((Entry)p).left = l.right;
        if (l.right != null) {
            l.right.parent = (Entry)p;
        }
        l.parent = ((Entry)p).parent;
        if (((Entry)p).parent == null) {
            this.root = l;
        } else if (((Entry)p).parent.right == p) {
            ((Entry)p).parent.right = l;
        } else {
            ((Entry)p).parent.left = l;
        }
        l.right = (Entry)p;
        ((Entry)p).parent = l;
        l.subSize = ((Entry)p).subSize;
        ((Entry)p).subSize = ((Entry)p).leftSubSize() + ((Entry)p).rightSubSize() + this.entrySubSize(p);
        assert (l.subSize == l.leftSubSize() + l.rightSubSize() + this.entrySubSize(l));
    }

    private void fixAfterInsertion(Entry<K, V> x) {
        x.color = false;
        while (x != null && x != this.root && !((Entry)x).parent.color) {
            Entry<K, V> y;
            if (ShaolinMap.parentOf(x) == ShaolinMap.leftOf(ShaolinMap.parentOf(ShaolinMap.parentOf(x)))) {
                y = ShaolinMap.rightOf(ShaolinMap.parentOf(ShaolinMap.parentOf(x)));
                if (!ShaolinMap.colorOf(y)) {
                    ShaolinMap.setColor(ShaolinMap.parentOf(x), true);
                    ShaolinMap.setColor(y, true);
                    ShaolinMap.setColor(ShaolinMap.parentOf(ShaolinMap.parentOf(x)), false);
                    x = ShaolinMap.parentOf(ShaolinMap.parentOf(x));
                    continue;
                }
                if (x == ShaolinMap.rightOf(ShaolinMap.parentOf(x))) {
                    x = ShaolinMap.parentOf(x);
                    this.rotateLeft(x);
                }
                ShaolinMap.setColor(ShaolinMap.parentOf(x), true);
                ShaolinMap.setColor(ShaolinMap.parentOf(ShaolinMap.parentOf(x)), false);
                if (ShaolinMap.parentOf(ShaolinMap.parentOf(x)) == null) continue;
                this.rotateRight(ShaolinMap.parentOf(ShaolinMap.parentOf(x)));
                continue;
            }
            y = ShaolinMap.leftOf(ShaolinMap.parentOf(ShaolinMap.parentOf(x)));
            if (!ShaolinMap.colorOf(y)) {
                ShaolinMap.setColor(ShaolinMap.parentOf(x), true);
                ShaolinMap.setColor(y, true);
                ShaolinMap.setColor(ShaolinMap.parentOf(ShaolinMap.parentOf(x)), false);
                x = ShaolinMap.parentOf(ShaolinMap.parentOf(x));
                continue;
            }
            if (x == ShaolinMap.leftOf(ShaolinMap.parentOf(x))) {
                x = ShaolinMap.parentOf(x);
                this.rotateRight(x);
            }
            ShaolinMap.setColor(ShaolinMap.parentOf(x), true);
            ShaolinMap.setColor(ShaolinMap.parentOf(ShaolinMap.parentOf(x)), false);
            if (ShaolinMap.parentOf(ShaolinMap.parentOf(x)) == null) continue;
            this.rotateLeft(ShaolinMap.parentOf(ShaolinMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> p) {
        Entry replacement;
        Entry current;
        this.decrementSize();
        if (p.left != null && p.right != null) {
            Entry<K, V> s = this.successor(p);
            int subSizeAdd = this.entrySubSize(s) - this.entrySubSize(p);
            p.key = s.key;
            p.value = s.value;
            current = p;
            while (current != null) {
                Entry entry = current;
                entry.subSize = entry.subSize + subSizeAdd;
                current = current.parent;
            }
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.left = null;
            p.right = null;
            p.parent = null;
            Entry current2 = replacement;
            while (current2 != null) {
                current2.subSize = current2.leftSubSize() + this.entrySubSize(current2) + current2.rightSubSize();
                current2 = current2.parent;
            }
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            int subSizeRemove = this.entrySubSize(p);
            p.key = null;
            p.value = null;
            current = p;
            while (current != null) {
                Entry entry2 = current;
                entry2.subSize = entry2.subSize - subSizeRemove;
                current = current.parent;
            }
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
        assert (this.isOk());
    }

    public boolean isOk() {
        for (K key : this.keySet()) {
            Entry<K, V> entry = this.getEntry(key);
            if (((Entry)entry).subSize == ((Entry)entry).leftSubSize() + this.entrySubSize(entry) + ((Entry)entry).rightSubSize()) continue;
            return false;
        }
        return true;
    }

    private void fixAfterDeletion(Entry<K, V> x) {
        while (x != this.root && ShaolinMap.colorOf(x)) {
            Entry<K, V> sib;
            if (x == ShaolinMap.leftOf(ShaolinMap.parentOf(x))) {
                sib = ShaolinMap.rightOf(ShaolinMap.parentOf(x));
                if (!ShaolinMap.colorOf(sib)) {
                    ShaolinMap.setColor(sib, true);
                    ShaolinMap.setColor(ShaolinMap.parentOf(x), false);
                    this.rotateLeft(ShaolinMap.parentOf(x));
                    sib = ShaolinMap.rightOf(ShaolinMap.parentOf(x));
                }
                if (ShaolinMap.colorOf(ShaolinMap.leftOf(sib)) && ShaolinMap.colorOf(ShaolinMap.rightOf(sib))) {
                    ShaolinMap.setColor(sib, false);
                    x = ShaolinMap.parentOf(x);
                    continue;
                }
                if (ShaolinMap.colorOf(ShaolinMap.rightOf(sib))) {
                    ShaolinMap.setColor(ShaolinMap.leftOf(sib), true);
                    ShaolinMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = ShaolinMap.rightOf(ShaolinMap.parentOf(x));
                }
                ShaolinMap.setColor(sib, ShaolinMap.colorOf(ShaolinMap.parentOf(x)));
                ShaolinMap.setColor(ShaolinMap.parentOf(x), true);
                ShaolinMap.setColor(ShaolinMap.rightOf(sib), true);
                this.rotateLeft(ShaolinMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = ShaolinMap.leftOf(ShaolinMap.parentOf(x));
            if (!ShaolinMap.colorOf(sib)) {
                ShaolinMap.setColor(sib, true);
                ShaolinMap.setColor(ShaolinMap.parentOf(x), false);
                this.rotateRight(ShaolinMap.parentOf(x));
                sib = ShaolinMap.leftOf(ShaolinMap.parentOf(x));
            }
            if (ShaolinMap.colorOf(ShaolinMap.rightOf(sib)) && ShaolinMap.colorOf(ShaolinMap.leftOf(sib))) {
                ShaolinMap.setColor(sib, false);
                x = ShaolinMap.parentOf(x);
                continue;
            }
            if (ShaolinMap.colorOf(ShaolinMap.leftOf(sib))) {
                ShaolinMap.setColor(ShaolinMap.rightOf(sib), true);
                ShaolinMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = ShaolinMap.leftOf(ShaolinMap.parentOf(x));
            }
            ShaolinMap.setColor(sib, ShaolinMap.colorOf(ShaolinMap.parentOf(x)));
            ShaolinMap.setColor(ShaolinMap.parentOf(x), true);
            ShaolinMap.setColor(ShaolinMap.leftOf(sib), true);
            this.rotateRight(ShaolinMap.parentOf(x));
            x = this.root;
        }
        ShaolinMap.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet<Map.Entry<K, V>> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = this.buildFromSorted(0, 0, size - 1, ShaolinMap.computeRedLevel(size), it, str, defaultVal);
    }

    private final Entry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        V value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry<K, V> left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry<Object, V> middle = new Entry<Object, V>(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            ((Entry)middle).left = (Entry)left;
            ((Entry)left).parent = (Entry)middle;
        }
        if (mid < hi) {
            Entry<K, V> right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            ((Entry)middle).right = (Entry)right;
            ((Entry)right).parent = (Entry)middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    public static void main(String[] args) {
        Random rnd = new Random();
        int COUNT = 100;
        ShaolinMap<Integer, Integer> map = new ShaolinMap<Integer, Integer>();
        int i = 0;
        while (i < 100) {
            int value = rnd.nextInt(100);
            map.put(value, value);
            ++i;
        }
        System.out.println("Size: " + map.size());
        int[] arr = new int[map.size()];
        int i2 = 0;
        System.out.print("Result: [");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            System.out.print(String.valueOf(key) + ",");
            arr[i2++] = key;
        }
        System.out.println("]");
        int index = map.indexOfKey(50);
        System.out.println("Index of 50=" + index);
        if (index >= 0 ? !$assertionsDisabled && index != Arrays.binarySearch(arr, 50) : !$assertionsDisabled && Arrays.binarySearch(arr, 50) >= 0) {
            throw new AssertionError();
        }
        try {
            int value = (Integer)map.getKey(50);
            System.out.println("Value at 50=" + value);
            assert (arr[50] == value);
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println("No value at 50");
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        private Entry<K, V> left = null;
        private Entry<K, V> right = null;
        private Entry<K, V> parent;
        private int subSize = 1;
        boolean color = true;

        Entry(K key, V value, Entry<K, V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        private int leftSubSize() {
            return this.left == null ? 0 : this.left.subSize;
        }

        private int rightSubSize() {
            return this.right == null ? 0 : this.right.subSize;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ShaolinMap.valEquals(this.key, e.getKey()) && ShaolinMap.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends PrivateEntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    private abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        private int expectedModCount;
        private Entry<K, V> lastReturned;
        Entry<K, V> next;

        PrivateEntryIterator() {
            this.expectedModCount = ShaolinMap.this.modCount;
            this.lastReturned = null;
            this.next = ShaolinMap.this.firstEntry();
        }

        PrivateEntryIterator(Entry<K, V> first) {
            this.expectedModCount = ShaolinMap.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (ShaolinMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = ShaolinMap.this.successor(this.next);
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (ShaolinMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            ShaolinMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private K fromKey;
        private K toKey;
        private transient Set<Map.Entry<K, V>> entrySet = new EntrySetView();

        SubMap(K fromKey, K toKey) {
            if (ShaolinMap.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(K key, boolean headMap) {
            ShaolinMap.this.compare(key, key);
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, K fromKey, boolean toEnd, K toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.inRange(key) && ShaolinMap.this.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return ShaolinMap.this.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return ShaolinMap.this.put(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return ShaolinMap.this.comparator;
        }

        @Override
        public K firstKey() {
            Map.Entry e = this.fromStart ? ShaolinMap.this.firstEntry() : ShaolinMap.this.getCeilEntry(this.fromKey);
            Object first = ShaolinMap.key((Entry)e);
            if (!this.toEnd && ShaolinMap.this.compare(first, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return first;
        }

        @Override
        public K lastKey() {
            Map.Entry e = this.toEnd ? ShaolinMap.this.lastEntry() : ShaolinMap.this.getPrecedingEntry(this.toKey);
            Object last = ShaolinMap.key((Entry)e);
            if (!this.fromStart && ShaolinMap.this.compare(last, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return last;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet;
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(fromKey, toKey);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, toKey);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, fromKey, this.toEnd, this.toKey);
        }

        private boolean inRange(K key) {
            return !(!this.fromStart && ShaolinMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && ShaolinMap.this.compare(key, this.toKey) >= 0);
        }

        private boolean inRange2(K key) {
            return !(!this.fromStart && ShaolinMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && ShaolinMap.this.compare(key, this.toKey) > 0);
        }

        private class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            @Override
            public int size() {
                if (this.size == -1 || this.sizeModCount != ShaolinMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = ShaolinMap.this.modCount;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = ShaolinMap.this.getEntry(key);
                return node != null && ShaolinMap.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = ShaolinMap.this.getEntry(key);
                if (node != null && ShaolinMap.valEquals(node.getValue(), entry.getValue())) {
                    ShaolinMap.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new SubMapEntryIterator(SubMap.this.fromStart ? ShaolinMap.this.firstEntry() : ShaolinMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : ShaolinMap.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }

    private class SubMapEntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        private final K firstExcludedKey;

        SubMapEntryIterator(Entry<K, V> first, Entry<K, V> firstExcluded) {
            super(first);
            this.firstExcludedKey = firstExcluded == null ? null : firstExcluded.key;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends PrivateEntryIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }
}

