/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;

public class Radio {
    private static final String USAGE = "usage:\nnet.sourceforge.jaad.Radio <url>";

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                Radio.printUsage();
            } else {
                Radio.decode(args[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("error while decoding: " + e.toString());
        }
    }

    private static void printUsage() {
        System.out.println(USAGE);
        System.exit(1);
    }

    private static void decode(String arg) throws Exception {
        SampleBuffer buf = new SampleBuffer();
        DataLine line = null;
        try {
            String x;
            URL url = new URL(arg);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((x = br.readLine()) != null && !x.trim().equals("")) {
            }
            ADTSDemultiplexer adts = new ADTSDemultiplexer(in);
            AudioFormat aufmt = new AudioFormat(adts.getSampleFrequency(), 16, adts.getChannelCount(), true, true);
            Decoder dec = new Decoder(adts.getDecoderSpecificInfo());
            while (true) {
                byte[] b = adts.readNextFrame();
                dec.decodeFrame(b, buf);
                if (line != null && !line.getFormat().matches(aufmt)) {
                    line.stop();
                    line.close();
                    line = null;
                    aufmt = new AudioFormat(buf.getSampleRate(), buf.getBitsPerSample(), buf.getChannels(), true, true);
                }
                if (line == null) {
                    line = AudioSystem.getSourceDataLine(aufmt);
                    line.open();
                    line.start();
                }
                b = buf.getData();
                line.write(b, 0, b.length);
            }
        }
        catch (Throwable throwable) {
            if (line != null) {
                line.stop();
                line.close();
            }
            throw throwable;
        }
    }
}

