/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.gain;

class FFT {
    private static final float[][] FFT_TABLE_128 = new float[][]{{1.0f, -0.0f}, {0.99879545f, -0.049067676f}, {0.9951847f, -0.09801714f}, {0.9891765f, -0.14673047f}, {0.98078525f, -0.19509032f}, {0.97003126f, -0.24298018f}, {0.95694035f, -0.29028466f}, {0.94154406f, -0.33688986f}, {0.9238795f, -0.38268343f}, {0.9039893f, -0.42755508f}, {0.8819213f, -0.47139674f}, {0.8577286f, -0.51410276f}, {0.8314696f, -0.55557024f}, {0.8032075f, -0.5956993f}, {0.77301043f, -0.6343933f}, {0.7409511f, -0.671559f}, {0.70710677f, -0.70710677f}, {0.671559f, -0.7409511f}, {0.6343933f, -0.77301043f}, {0.5956993f, -0.8032075f}, {0.55557024f, -0.8314696f}, {0.51410276f, -0.8577286f}, {0.47139674f, -0.8819213f}, {0.42755508f, -0.9039893f}, {0.38268343f, -0.9238795f}, {0.33688986f, -0.94154406f}, {0.29028466f, -0.95694035f}, {0.24298018f, -0.97003126f}, {0.19509032f, -0.98078525f}, {0.14673047f, -0.9891765f}, {0.09801714f, -0.9951847f}, {0.049067676f, -0.99879545f}, {6.123234E-17f, -1.0f}, {-0.049067676f, -0.99879545f}, {-0.09801714f, -0.9951847f}, {-0.14673047f, -0.9891765f}, {-0.19509032f, -0.98078525f}, {-0.24298018f, -0.97003126f}, {-0.29028466f, -0.95694035f}, {-0.33688986f, -0.94154406f}, {-0.38268343f, -0.9238795f}, {-0.42755508f, -0.9039893f}, {-0.47139674f, -0.8819213f}, {-0.51410276f, -0.8577286f}, {-0.55557024f, -0.8314696f}, {-0.5956993f, -0.8032075f}, {-0.6343933f, -0.77301043f}, {-0.671559f, -0.7409511f}, {-0.70710677f, -0.70710677f}, {-0.7409511f, -0.671559f}, {-0.77301043f, -0.6343933f}, {-0.8032075f, -0.5956993f}, {-0.8314696f, -0.55557024f}, {-0.8577286f, -0.51410276f}, {-0.8819213f, -0.47139674f}, {-0.9039893f, -0.42755508f}, {-0.9238795f, -0.38268343f}, {-0.94154406f, -0.33688986f}, {-0.95694035f, -0.29028466f}, {-0.97003126f, -0.24298018f}, {-0.98078525f, -0.19509032f}, {-0.9891765f, -0.14673047f}, {-0.9951847f, -0.09801714f}, {-0.99879545f, -0.049067676f}};
    private static final float[][] FFT_TABLE_16 = new float[][]{{1.0f, -0.0f}, {0.9238795f, -0.38268343f}, {0.70710677f, -0.70710677f}, {0.38268343f, -0.9238795f}, {6.123234E-17f, -1.0f}, {-0.38268343f, -0.9238795f}, {-0.70710677f, -0.70710677f}, {-0.9238795f, -0.38268343f}};

    FFT() {
    }

    static void process(float[][] in, int n) {
        int ln = (int)Math.round(Math.log(n) / Math.log(2.0));
        float[][] table = n == 128 ? FFT_TABLE_128 : FFT_TABLE_16;
        float[][] rev = new float[n][2];
        int ii = 0;
        int i = 0;
        while (i < n) {
            rev[i][0] = in[ii][0];
            rev[i][1] = in[ii][1];
            int k = n >> 1;
            while (ii >= k && k > 0) {
                ii -= k;
                k >>= 1;
            }
            ii += k;
            ++i;
        }
        i = 0;
        while (i < n) {
            in[i][0] = rev[i][0];
            in[i][1] = rev[i][1];
            ++i;
        }
        int blocks = n / 2;
        int size = 2;
        float[] a = new float[2];
        i = 0;
        while (i < ln) {
            int size2 = size / 2;
            int k0 = 0;
            int k1 = size2;
            int j = 0;
            while (j < blocks) {
                int l = 0;
                int k = 0;
                while (k < size2) {
                    a[0] = in[k1][0] * table[l][0] - in[k1][1] * table[l][1];
                    a[1] = in[k1][0] * table[l][1] + in[k1][1] * table[l][0];
                    in[k1][0] = in[k0][0] - a[0];
                    in[k1][1] = in[k0][1] - a[1];
                    float[] fArray = in[k0];
                    fArray[0] = fArray[0] + a[0];
                    float[] fArray2 = in[k0];
                    fArray2[1] = fArray2[1] + a[1];
                    l += blocks;
                    ++k0;
                    ++k1;
                    ++k;
                }
                k0 += size2;
                k1 += size2;
                ++j;
            }
            blocks /= 2;
            size *= 2;
            ++i;
        }
    }
}

