/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.gain;

import net.sourceforge.jaad.aac.gain.GCConstants;
import net.sourceforge.jaad.aac.gain.PQFTables;

class IPQF
implements GCConstants,
PQFTables {
    private final float[] buf = new float[4];
    private final float[][] tmp1 = new float[2][24];
    private final float[][] tmp2 = new float[2][24];

    IPQF() {
    }

    void process(float[][] in, int frameLen, int maxBand, float[] out) {
        int i = 0;
        while (i < frameLen) {
            out[i] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < frameLen / 4) {
            int j = 0;
            while (j < 4) {
                this.buf[j] = in[j][i];
                ++j;
            }
            this.performSynthesis(this.buf, out, i * 4);
            ++i;
        }
    }

    private void performSynthesis(float[] in, float[] out, int outOff) {
        float acc;
        int k;
        int kk = 12;
        int n = 0;
        while (n < 2) {
            k = 0;
            while (k < 23) {
                this.tmp1[n][k] = this.tmp1[n][k + 1];
                this.tmp2[n][k] = this.tmp2[n][k + 1];
                ++k;
            }
            ++n;
        }
        n = 0;
        while (n < 2) {
            acc = 0.0f;
            int i = 0;
            while (i < 4) {
                acc += COEFS_Q0[n][i] * in[i];
                ++i;
            }
            this.tmp1[n][23] = acc;
            acc = 0.0f;
            i = 0;
            while (i < 4) {
                acc += COEFS_Q1[n][i] * in[i];
                ++i;
            }
            this.tmp2[n][23] = acc;
            ++n;
        }
        n = 0;
        while (n < 2) {
            acc = 0.0f;
            k = 0;
            while (k < 12) {
                acc += COEFS_T0[n][k] * this.tmp1[n][23 - 2 * k];
                ++k;
            }
            k = 0;
            while (k < 12) {
                acc += COEFS_T1[n][k] * this.tmp2[n][22 - 2 * k];
                ++k;
            }
            out[outOff + n] = acc;
            acc = 0.0f;
            k = 0;
            while (k < 12) {
                acc += COEFS_T0[3 - n][k] * this.tmp1[n][23 - 2 * k];
                ++k;
            }
            k = 0;
            while (k < 12) {
                acc -= COEFS_T1[3 - n][k] * this.tmp2[n][22 - 2 * k];
                ++k;
            }
            out[outOff + 4 - 1 - n] = acc;
            ++n;
        }
    }
}

