/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.ps2;

import net.sourceforge.jaad.aac.ps2.FilterbankTables;

class HybridFilterbank
implements FilterbankTables {
    HybridFilterbank() {
    }

    public static void analyze(float[][][] in, float[][][] out, boolean use34) {
        if (use34) {
            HybridFilterbank.splitBands4(in[0], out, 0, FILTER_34_12, 12);
            HybridFilterbank.splitBands4(in[1], out, 12, FILTER_34_8, 8);
            HybridFilterbank.splitBands4(in[2], out, 20, FILTER_34_4, 4);
            HybridFilterbank.splitBands4(in[3], out, 24, FILTER_34_4, 4);
            HybridFilterbank.splitBands4(in[4], out, 28, FILTER_34_4, 4);
        } else {
            HybridFilterbank.splitBands6(in[0], out, 0);
            HybridFilterbank.splitBands2(in[1], out, 6, true);
            HybridFilterbank.splitBands2(in[2], out, 8, false);
        }
    }

    private static void splitBands2(float[][] in, float[][][] out, int outOff, boolean reverse) {
        float[] tmp1 = new float[2];
        float[] tmp2 = new float[2];
        int i = 0;
        while (i < 32) {
            tmp1[0] = FILTER_20_2[6] * in[i + 6][0];
            tmp1[1] = FILTER_20_2[6] * in[i + 6][1];
            tmp2[0] = 0.0f;
            tmp2[1] = 0.0f;
            int j = 0;
            while (j < 6) {
                tmp2[0] = tmp2[0] + FILTER_20_2[j + 1] * (in[i + j + 1][0] + in[i + 12 - j - 1][0]);
                tmp2[1] = tmp2[1] + FILTER_20_2[j + 1] * (in[i + j + 1][1] + in[i + 12 - j - 1][1]);
                j += 2;
            }
            if (reverse) {
                out[outOff + 1][i][0] = tmp1[0] + tmp2[0];
                out[outOff + 1][i][1] = tmp1[1] + tmp2[1];
                out[outOff][i][0] = tmp1[0] - tmp2[0];
                out[outOff][i][1] = tmp1[1] - tmp2[1];
            } else {
                out[outOff][i][0] = tmp1[0] + tmp2[0];
                out[outOff][i][1] = tmp1[1] + tmp2[1];
                out[outOff + 1][i][0] = tmp1[0] - tmp2[0];
                out[outOff + 1][i][1] = tmp1[1] - tmp2[1];
            }
            ++i;
        }
    }

    private static void splitBands6(float[][] in, float[][][] out, int outOff) {
        float[][] tmp = new float[8][2];
        float[] sum = new float[2];
        int i = 0;
        while (i < 32) {
            int k = 0;
            while (k < 8) {
                sum[0] = FILTER_20_8[k][6][0] * in[i + 6][0];
                sum[1] = FILTER_20_8[k][6][0] * in[i + 6][1];
                int j = 0;
                while (j < 6) {
                    sum[0] = sum[0] + (FILTER_20_8[k][j][0] * (in[i + j][0] + in[i + 12 - j][0]) - FILTER_20_8[k][j][1] * (in[i + j][1] - in[i + 12 - j][1]));
                    sum[1] = sum[1] + (FILTER_20_8[k][j][0] * (in[i + j][1] + in[i + 12 - j][1]) + FILTER_20_8[k][j][1] * (in[i + j][0] - in[i + 12 - j][0]));
                    ++j;
                }
                tmp[k][0] = sum[0];
                tmp[k][1] = sum[1];
                ++k;
            }
            out[outOff + 0][i][0] = tmp[6][0];
            out[outOff + 0][i][1] = tmp[6][1];
            out[outOff + 1][i][0] = tmp[7][0];
            out[outOff + 1][i][1] = tmp[7][1];
            out[outOff + 2][i][0] = tmp[0][0];
            out[outOff + 2][i][1] = tmp[0][1];
            out[outOff + 3][i][0] = tmp[1][0];
            out[outOff + 3][i][1] = tmp[1][1];
            out[outOff + 4][i][0] = tmp[2][0] + tmp[5][0];
            out[outOff + 4][i][1] = tmp[2][1] + tmp[5][1];
            out[outOff + 5][i][0] = tmp[3][0] + tmp[4][0];
            out[outOff + 5][i][1] = tmp[3][1] + tmp[4][1];
            ++i;
        }
    }

    private static void splitBands4(float[][] in, float[][][] out, int outOff, float[][][] filter, int len) {
        float[] sum = new float[2];
        int i = 0;
        while (i < len) {
            int k = 0;
            while (k < len) {
                sum[0] = filter[k][6][0] * in[i + 6][0];
                sum[1] = filter[k][6][0] * in[i + 6][1];
                int j = 0;
                while (j < 6) {
                    sum[0] = sum[0] + (filter[k][j][0] * (in[i + j][0] + in[i + 12 - j][0]) - filter[k][j][1] * (in[i + j][1] - in[i + 12 - j][1]));
                    sum[1] = sum[1] + (filter[k][j][0] * (in[i + j][1] + in[i + 12 - j][1]) + filter[k][j][1] * (in[i + j][0] - in[i + 12 - j][0]));
                    ++j;
                }
                out[outOff + k][i][0] = sum[0];
                out[outOff + k][i][1] = sum[1];
                ++k;
            }
            ++i;
        }
    }

    public static void synthesize(float[][][] in, float[][][] out, boolean use34) {
        if (use34) {
            int n = 0;
            while (n < 32) {
                int k = 0;
                while (k < 5) {
                    out[k][n][0] = 0.0f;
                    out[k][n][1] = 0.0f;
                    ++k;
                }
                k = 0;
                while (k < 12) {
                    float[] fArray = out[0][n];
                    fArray[0] = fArray[0] + in[k][n][0];
                    float[] fArray2 = out[0][n];
                    fArray2[1] = fArray2[1] + in[k][n][1];
                    ++k;
                }
                k = 12;
                while (k < 19) {
                    float[] fArray = out[1][n];
                    fArray[0] = fArray[0] + in[k][n][0];
                    float[] fArray3 = out[1][n];
                    fArray3[1] = fArray3[1] + in[k][n][1];
                    ++k;
                }
                k = 20;
                while (k < 24) {
                    float[] fArray = out[2][n];
                    fArray[0] = fArray[0] + in[k][n][0];
                    float[] fArray4 = out[2][n];
                    fArray4[1] = fArray4[1] + in[k][n][1];
                    float[] fArray5 = out[3][n];
                    fArray5[0] = fArray5[0] + in[k + 4][n][0];
                    float[] fArray6 = out[3][n];
                    fArray6[1] = fArray6[1] + in[k + 4][n][1];
                    float[] fArray7 = out[4][n];
                    fArray7[0] = fArray7[0] + in[k + 8][n][0];
                    float[] fArray8 = out[4][n];
                    fArray8[1] = fArray8[1] + in[k + 8][n][1];
                    ++k;
                }
                k = 0;
                while (k < 59) {
                    out[k + 5][n][0] = in[k + 32][n][0];
                    out[k + 5][n][1] = in[k + 32][n][1];
                    ++k;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < 32) {
                out[0][n][0] = in[0][n][0] + in[1][n][0] + in[2][n][0] + in[3][n][0] + in[4][n][0] + in[5][n][0];
                out[0][n][1] = in[0][n][1] + in[1][n][1] + in[2][n][1] + in[3][n][1] + in[4][n][1] + in[5][n][1];
                out[1][n][0] = in[6][n][0] + in[7][n][0];
                out[1][n][1] = in[6][n][1] + in[7][n][1];
                out[2][n][0] = in[8][n][0] + in[9][n][0];
                out[2][n][1] = in[8][n][1] + in[9][n][1];
                int k = 0;
                while (k < 61) {
                    out[k + 3][n][0] = in[k + 10][n][0];
                    out[k + 3][n][1] = in[k + 10][n][1];
                    ++k;
                }
                ++n;
            }
        }
    }
}

