/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import net.sourceforge.jaad.aac.sbr2.FilterbankTables;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;

class AnalysisFilterbank
implements SBRConstants,
FilterbankTables {
    private final float[][][] COEFS;
    private final float[][] X = new float[2][320];
    private final float[] z = new float[320];
    private final float[] u = new float[64];

    AnalysisFilterbank() {
        this.COEFS = new float[32][64][2];
        int k = 0;
        while (k < 32) {
            int n = 0;
            while (n < 64) {
                double tmp = 0.04908738521234052 * ((double)k + 0.5) * ((double)(2 * n) - 0.5);
                this.COEFS[k][n][0] = (float)(2.0 * Math.cos(tmp));
                this.COEFS[k][n][1] = (float)(2.0 * Math.sin(tmp));
                ++n;
            }
            ++k;
        }
    }

    public void process(float[] in, float[][][] out, int ch) {
        float[] x = this.X[ch];
        int off = 0;
        int l = 0;
        while (l < 32) {
            int k;
            System.arraycopy(x, 0, x, 32, 288);
            int n = 31;
            while (n >= 0) {
                x[n] = in[off];
                ++off;
                --n;
            }
            n = 0;
            while (n < 320) {
                this.z[n] = x[n] * (float)WINDOW[2 * n];
                ++n;
            }
            n = 0;
            while (n < 64) {
                this.u[n] = this.z[n];
                k = 1;
                while (k < 5) {
                    int n2 = n;
                    this.u[n2] = this.u[n2] + this.z[n + k * 64];
                    ++k;
                }
                ++n;
            }
            k = 0;
            while (k < 32) {
                out[k][l][0] = 0.0f;
                out[k][l][1] = 0.0f;
                n = 0;
                while (n < 64) {
                    float[] fArray = out[k][l];
                    fArray[0] = fArray[0] + this.u[n] * this.COEFS[k][n][0];
                    float[] fArray2 = out[k][l];
                    fArray2[1] = fArray2[1] + this.u[n] * this.COEFS[k][n][1];
                    ++n;
                }
                ++k;
            }
            ++l;
        }
    }
}

