/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import java.util.Arrays;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.sbr2.FrequencyTables;
import net.sourceforge.jaad.aac.sbr2.HuffmanTables;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;
import net.sourceforge.jaad.aac.sbr2.SBRHeader;
import net.sourceforge.jaad.aac.syntax.BitStream;

class ChannelData
implements SBRConstants,
HuffmanTables {
    private boolean ampRes;
    private int frameClass;
    private int envCount;
    private int envCountPrev;
    private int noiseCount;
    private final int[] freqRes = new int[5];
    private int freqResPrevious;
    private int pointer;
    private int la;
    private int laPrevious;
    private final boolean[] dfEnv;
    private final boolean[] dfNoise;
    private final int[] invfMode = new int[5];
    private final int[] invfModePrevious = new int[5];
    private final float[][] envelopeSF;
    private final float[] envelopeSFPrevious;
    private final int[] te;
    private int tePrevious = 0;
    private final float[][] noiseFloorData;
    private final float[] noiseFDPrevious;
    private final int[] tq;
    private boolean sinusoidalsPresent;
    private final boolean[] sinusoidals;
    private final boolean[] sIndexMappedPrevious;
    private final float[] bwArray;
    private int noiseIndex;
    private int sineIndex;
    private int lTemp;
    private final float[][] gTmp;
    private final float[][] qTmp;

    ChannelData() {
        this.dfEnv = new boolean[5];
        this.dfNoise = new boolean[2];
        this.envelopeSF = new float[5][64];
        this.envelopeSFPrevious = new float[64];
        this.te = new int[6];
        this.noiseFloorData = new float[2][64];
        this.noiseFDPrevious = new float[64];
        this.tq = new int[3];
        this.sinusoidals = new boolean[64];
        this.sIndexMappedPrevious = new boolean[64];
        Arrays.fill(this.sIndexMappedPrevious, false);
        this.bwArray = new float[5];
        this.lTemp = 0;
        this.gTmp = new float[42][48];
        this.qTmp = new float[42][48];
    }

    void savePreviousData() {
        this.lTemp = 2 * this.te[this.envCount] - 32;
        this.envCountPrev = this.envCount;
        this.freqResPrevious = this.freqRes[this.freqRes.length - 1];
        this.laPrevious = this.la;
        this.tePrevious = this.te[this.envCountPrev];
        System.arraycopy(this.invfMode, 0, this.invfModePrevious, 0, 5);
    }

    void decodeGrid(BitStream in, SBRHeader header, FrequencyTables tables) throws AACException {
        int absBordTrail = 16;
        this.ampRes = header.getAmpRes();
        this.frameClass = in.readBits(2);
        switch (this.frameClass) {
            case 0: {
                this.envCount = 1 << in.readBits(2);
                int relLead = this.envCount - 1;
                if (this.envCount == 1) {
                    this.ampRes = false;
                } else if (this.envCount > 4) {
                    throw new AACException("SBR: too many envelopes: " + this.envCount);
                }
                Arrays.fill(this.freqRes, in.readBit());
                this.te[0] = 0;
                this.te[this.envCount] = absBordTrail;
                absBordTrail = (absBordTrail + (this.envCount >> 1)) / this.envCount;
                int i = 0;
                while (i < relLead) {
                    this.te[i + 1] = this.te[i] + absBordTrail;
                    ++i;
                }
                break;
            }
            case 1: {
                int relTrail = in.readBits(2);
                this.envCount = relTrail + 1;
                this.te[0] = 0;
                this.te[this.envCount] = absBordTrail += in.readBits(2);
                int i = 0;
                while (i < relTrail) {
                    this.te[this.envCount - 1 - i] = this.te[this.envCount - i] - 2 * in.readBits(2) - 2;
                    ++i;
                }
                this.pointer = in.readBits(CEIL_LOG2[this.envCount]);
                i = 0;
                while (i < this.envCount) {
                    this.freqRes[this.envCount - 1 - i] = in.readBit();
                    ++i;
                }
                break;
            }
            case 2: {
                this.te[0] = in.readBits(2);
                int relLead = in.readBits(2);
                this.envCount = relLead + 1;
                this.te[this.envCount] = absBordTrail;
                int i = 0;
                while (i < relLead) {
                    this.te[i + 1] = this.te[i] + 2 * in.readBits(2) + 2;
                    ++i;
                }
                this.pointer = in.readBits(CEIL_LOG2[this.envCount]);
                i = 0;
                while (i < this.envCount) {
                    this.freqRes[i] = in.readBit();
                    ++i;
                }
                break;
            }
            default: {
                this.te[0] = in.readBits(2);
                absBordTrail += in.readBits(2);
                int relLead = in.readBits(2);
                int relTrail = in.readBits(2);
                this.envCount = relLead + relTrail + 1;
                if (this.envCount > 5) {
                    throw new AACException("SBR: too many envelopes: " + this.envCount);
                }
                this.te[this.envCount] = absBordTrail;
                int i = 0;
                while (i < relLead) {
                    this.te[i + 1] = this.te[i] + 2 * in.readBits(2) + 2;
                    ++i;
                }
                i = 0;
                while (i < relTrail) {
                    this.te[this.envCount - 1 - i] = this.te[this.envCount - i] - 2 * in.readBits(2) - 2;
                    ++i;
                }
                this.pointer = in.readBits(CEIL_LOG2[this.envCount]);
                i = 0;
                while (i < this.envCount) {
                    this.freqRes[i] = in.readBit();
                    ++i;
                }
                break block0;
            }
        }
        this.noiseCount = this.envCount > 1 ? 2 : 1;
        this.tq[0] = this.te[0];
        this.tq[this.noiseCount] = this.te[this.envCount];
        if (this.envCount == 1) {
            this.tq[1] = this.te[1];
        } else {
            int middleBorder;
            switch (this.frameClass) {
                case 0: {
                    middleBorder = this.envCount / 2;
                    break;
                }
                case 2: {
                    if (this.pointer == 0) {
                        middleBorder = 1;
                        break;
                    }
                    if (this.pointer == 1) {
                        middleBorder = this.envCount - 1;
                        break;
                    }
                    middleBorder = this.pointer - 1;
                    break;
                }
                default: {
                    middleBorder = this.pointer > 1 ? this.envCount + 1 - this.pointer : this.envCount - 1;
                }
            }
            this.tq[1] = this.te[middleBorder];
        }
        this.la = (this.frameClass == 1 || this.frameClass == 3) && this.pointer > 0 ? this.envCount + 1 - this.pointer : (this.frameClass == 2 && this.pointer > 1 ? this.pointer - 1 : -1);
    }

    void decodeDTDF(BitStream in) throws AACException {
        int i = 0;
        while (i < this.envCount) {
            this.dfEnv[i] = in.readBool();
            ++i;
        }
        i = 0;
        while (i < this.noiseCount) {
            this.dfNoise[i] = in.readBool();
            ++i;
        }
    }

    void decodeInvf(BitStream in, SBRHeader header, FrequencyTables tables) throws AACException {
        int i = 0;
        while (i < tables.getNq()) {
            this.invfMode[i] = in.readBits(2);
            ++i;
        }
    }

    void decodeEnvelope(BitStream in, SBRHeader header, FrequencyTables tables, boolean secCh, boolean coupling) throws AACException {
        int fLav;
        int[][] fHuff;
        int tLav;
        int[][] tHuff;
        if (coupling && secCh) {
            if (this.ampRes) {
                tHuff = T_HUFFMAN_ENV_BAL_3_0;
                tLav = 12;
                fHuff = F_HUFFMAN_ENV_BAL_3_0;
                fLav = 12;
            } else {
                tHuff = T_HUFFMAN_ENV_BAL_1_5;
                tLav = 24;
                fHuff = F_HUFFMAN_ENV_BAL_1_5;
                fLav = 24;
            }
        } else if (this.ampRes) {
            tHuff = T_HUFFMAN_ENV_3_0;
            tLav = 31;
            fHuff = F_HUFFMAN_ENV_3_0;
            fLav = 31;
        } else {
            tHuff = T_HUFFMAN_ENV_1_5;
            tLav = 60;
            fHuff = F_HUFFMAN_ENV_1_5;
            fLav = 60;
        }
        int[] envBands = tables.getN();
        int bits = 7 - (secCh && coupling ? 1 : 0) - (this.ampRes ? 1 : 0);
        int delta = (secCh && coupling ? 1 : 0) + 1;
        int odd = envBands[1] & 1;
        int i = 0;
        while (i < this.envCount) {
            int j;
            int frPrev;
            float[] prev = i == 0 ? this.envelopeSFPrevious : this.envelopeSF[i - 1];
            int n = frPrev = i == 0 ? this.freqResPrevious : this.freqRes[i - 1];
            if (this.dfEnv[i]) {
                int k;
                if (this.freqRes[i] == frPrev) {
                    j = 0;
                    while (j < envBands[this.freqRes[i]]) {
                        this.envelopeSF[i][j] = prev[j] + (float)(delta * (this.decodeHuffman(in, tHuff) - tLav));
                        ++j;
                    }
                } else if (this.freqRes[i] == 1) {
                    j = 0;
                    while (j < envBands[this.freqRes[i]]) {
                        k = j + odd >> 1;
                        this.envelopeSF[i][j] = prev[k] + (float)(delta * (this.decodeHuffman(in, tHuff) - tLav));
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < envBands[this.freqRes[i]]) {
                        k = j != 0 ? 2 * j - odd : 0;
                        this.envelopeSF[i][j] = prev[k] + (float)(delta * (this.decodeHuffman(in, tHuff) - tLav));
                        ++j;
                    }
                }
            } else {
                this.envelopeSF[i][0] = delta * in.readBits(bits);
                j = 1;
                while (j < envBands[this.freqRes[i]]) {
                    this.envelopeSF[i][j] = this.envelopeSF[i][j - 1] + (float)(delta * (this.decodeHuffman(in, fHuff) - fLav));
                    ++j;
                }
            }
            ++i;
        }
        System.arraycopy(this.envelopeSF[this.envCount - 1], 0, this.envelopeSFPrevious, 0, 64);
    }

    void decodeNoise(BitStream in, SBRHeader header, FrequencyTables tables, boolean secCh, boolean coupling) throws AACException {
        int fLav;
        int[][] fHuff;
        int tLav;
        int[][] tHuff;
        if (coupling && secCh) {
            tHuff = T_HUFFMAN_NOISE_BAL_3_0;
            tLav = 12;
            fHuff = F_HUFFMAN_NOISE_BAL_3_0;
            fLav = 12;
        } else {
            tHuff = T_HUFFMAN_NOISE_3_0;
            tLav = 31;
            fHuff = F_HUFFMAN_NOISE_3_0;
            fLav = 31;
        }
        int noiseBands = tables.getNq();
        int delta = (secCh && coupling ? 1 : 0) + 1;
        int i = 0;
        while (i < this.noiseCount) {
            int j;
            if (this.dfNoise[i]) {
                float[] prev = i == 0 ? this.noiseFDPrevious : this.noiseFloorData[i - 1];
                j = 0;
                while (j < noiseBands) {
                    this.noiseFloorData[i][j] = prev[j] + (float)(delta * (this.decodeHuffman(in, tHuff) - tLav));
                    ++j;
                }
            } else {
                this.noiseFloorData[i][0] = delta * in.readBits(5);
                j = 1;
                while (j < noiseBands) {
                    this.noiseFloorData[i][j] = this.noiseFloorData[i][j - 1] + (float)(delta * (this.decodeHuffman(in, fHuff) - fLav));
                    ++j;
                }
            }
            ++i;
        }
        System.arraycopy(this.noiseFloorData[this.noiseCount - 1], 0, this.noiseFDPrevious, 0, 64);
    }

    void decodeSinusoidal(BitStream in, SBRHeader header, FrequencyTables tables) throws AACException {
        this.sinusoidalsPresent = in.readBool();
        if (this.sinusoidalsPresent) {
            int i = 0;
            while (i < tables.getN(1)) {
                this.sinusoidals[i] = in.readBool();
                ++i;
            }
        } else {
            Arrays.fill(this.sinusoidals, false);
        }
    }

    private int decodeHuffman(BitStream in, int[][] table) throws AACException {
        int off = 0;
        int len = table[off][0];
        int cw = in.readBits(len);
        while (cw != table[off][1]) {
            int j = table[++off][0] - len;
            len = table[off][0];
            cw <<= j;
            cw |= in.readBits(j);
        }
        return table[off][2];
    }

    public boolean getAmpRes() {
        return this.ampRes;
    }

    public float[][] getEnvelopeScalefactors() {
        return this.envelopeSF;
    }

    public int getEnvCount() {
        return this.envCount;
    }

    public int getEnvCountPrevious() {
        return this.envCountPrev;
    }

    public int[] getTe() {
        return this.te;
    }

    public int getTePrevious() {
        return this.tePrevious;
    }

    public float[][] getNoiseFloorData() {
        return this.noiseFloorData;
    }

    public int getNoiseCount() {
        return this.noiseCount;
    }

    public int[] getTq() {
        return this.tq;
    }

    public int[] getFrequencyResolutions() {
        return this.freqRes;
    }

    int getFrameClass() {
        return this.frameClass;
    }

    public int getLa(boolean previous) {
        return previous ? (this.laPrevious == this.envCountPrev ? 0 : -1) : this.la;
    }

    int getPointer() {
        return this.pointer;
    }

    public boolean areSinusoidalsPresent() {
        return this.sinusoidalsPresent;
    }

    public boolean[] getSinusoidals() {
        return this.sinusoidals;
    }

    public boolean[] getSIndexMappedPrevious() {
        return this.sIndexMappedPrevious;
    }

    void setSIndexMappedPrevious(boolean[] sIndexMapped) {
        Arrays.fill(this.sIndexMappedPrevious, false);
        System.arraycopy(sIndexMapped, 0, this.sIndexMappedPrevious, 0, sIndexMapped.length);
    }

    int[] getInvfMode(boolean previous) {
        return previous ? this.invfModePrevious : this.invfMode;
    }

    float[] getChirpFactors() {
        return this.bwArray;
    }

    int getNoiseIndex() {
        return this.noiseIndex;
    }

    void setNoiseIndex(int noiseIndex) {
        this.noiseIndex = noiseIndex;
    }

    int getSineIndex() {
        return this.sineIndex;
    }

    void setSineIndex(int sineIndex) {
        this.sineIndex = sineIndex;
    }

    public int getLTemp() {
        return this.lTemp;
    }

    public float[][] getGTmp() {
        return this.gTmp;
    }

    public float[][] getQTmp() {
        return this.qTmp;
    }

    void copyGrid(ChannelData cd) {
        this.frameClass = cd.getFrameClass();
        this.envCount = cd.getEnvCount();
        this.noiseCount = cd.getNoiseCount();
        System.arraycopy(cd.getFrequencyResolutions(), 0, this.freqRes, 0, this.envCount);
        System.arraycopy(cd.getTe(), 0, this.te, 0, this.te.length);
        System.arraycopy(cd.getTq(), 0, this.tq, 0, this.tq.length);
        this.pointer = cd.getPointer();
    }

    void copyInvf(ChannelData cd) {
        System.arraycopy(cd.getInvfMode(false), 0, this.invfMode, 0, 5);
    }
}

