/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl;

import java.io.IOException;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.FullBox;

public class SubSampleInformationBox
extends FullBox {
    private long[] sampleDelta;
    private long[][] subsampleSize;
    private int[][] subsamplePriority;
    private boolean[][] discardable;

    public SubSampleInformationBox() {
        super("Sub Sample Information Box");
    }

    public void decode(MP4InputStream in) throws IOException {
        super.decode(in);
        int len = this.version == 1 ? 4 : 2;
        int entryCount = (int)in.readBytes(4);
        this.sampleDelta = new long[entryCount];
        this.subsampleSize = new long[entryCount][];
        this.subsamplePriority = new int[entryCount][];
        this.discardable = new boolean[entryCount][];
        int i = 0;
        while (i < entryCount) {
            this.sampleDelta[i] = in.readBytes(4);
            int subsampleCount = (int)in.readBytes(2);
            this.subsampleSize[i] = new long[subsampleCount];
            this.subsamplePriority[i] = new int[subsampleCount];
            this.discardable[i] = new boolean[subsampleCount];
            int j = 0;
            while (j < subsampleCount) {
                this.subsampleSize[i][j] = in.readBytes(len);
                this.subsamplePriority[i][j] = in.read();
                this.discardable[i][j] = (in.read() & 1) == 1;
                in.skipBytes(4L);
                ++j;
            }
            ++i;
        }
    }

    public long[] getSampleDelta() {
        return this.sampleDelta;
    }

    public long[][] getSubsampleSize() {
        return this.subsampleSize;
    }

    public int[][] getSubsamplePriority() {
        return this.subsamplePriority;
    }

    public boolean[][] getDiscardable() {
        return this.discardable;
    }
}

