/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl.meta;

import java.io.IOException;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.FullBox;
import net.sourceforge.jaad.mp4.boxes.Utils;

public class GenreBox
extends FullBox {
    private String languageCode;
    private String genre;

    public GenreBox() {
        super("Genre Box");
    }

    public void decode(MP4InputStream in) throws IOException {
        if (this.parent.getType() == 1969517665L) {
            super.decode(in);
            this.languageCode = Utils.getLanguageCode(in.readBytes(2));
            byte[] b = in.readTerminated((int)this.getLeft(in), 0);
            this.genre = new String(b, "UTF-8");
        } else {
            this.readChildren(in);
        }
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getGenre() {
        return this.genre;
    }
}

