/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl.meta;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.FullBox;
import net.sourceforge.jaad.util.ArraysUtils;

public class ITunesMetadataBox
extends FullBox {
    private static final String[] TIMESTAMPS = new String[]{"yyyy", "yyyy-MM", "yyyy-MM-dd"};
    private DataType dataType;
    private byte[] data;

    public ITunesMetadataBox() {
        super("iTunes Metadata Box");
    }

    public void decode(MP4InputStream in) throws IOException {
        super.decode(in);
        this.dataType = DataType.forInt(this.flags);
        in.skipBytes(4L);
        this.data = new byte[(int)this.getLeft(in)];
        in.readBytes(this.data);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public byte[] getData() {
        return ArraysUtils.copyOf(this.data, this.data.length);
    }

    public String getText() {
        try {
            return new String(this.data, 0, this.data.length, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedCharsetException("UTF-8");
        }
    }

    public long getNumber() {
        long l = 0L;
        int i = 0;
        while (i < this.data.length) {
            l <<= 8;
            l |= (long)(this.data[i] & 0xFF);
            ++i;
        }
        return l;
    }

    public int getInteger() {
        return (int)this.getNumber();
    }

    public boolean getBoolean() {
        return this.getNumber() != 0L;
    }

    public Date getDate() {
        Date date;
        int i = (int)Math.floor(this.data.length / 3) - 1;
        if (i >= 0 && i < TIMESTAMPS.length) {
            SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMPS[i]);
            date = sdf.parse(new String(this.data), new ParsePosition(0));
        } else {
            date = null;
        }
        return date;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        IMPLICIT,
        UTF8,
        UTF16,
        HTML,
        XML,
        UUID,
        ISRC,
        MI3P,
        GIF,
        JPEG,
        PNG,
        URL,
        DURATION,
        DATETIME,
        GENRE,
        INTEGER,
        RIAA,
        UPC,
        BMP,
        UNDEFINED;

        private static final DataType[] TYPES;

        static {
            DataType[] dataTypeArray = new DataType[28];
            dataTypeArray[0] = IMPLICIT;
            dataTypeArray[1] = UTF8;
            dataTypeArray[2] = UTF16;
            dataTypeArray[6] = HTML;
            dataTypeArray[7] = XML;
            dataTypeArray[8] = UUID;
            dataTypeArray[9] = ISRC;
            dataTypeArray[10] = MI3P;
            dataTypeArray[12] = GIF;
            dataTypeArray[13] = JPEG;
            dataTypeArray[14] = PNG;
            dataTypeArray[15] = URL;
            dataTypeArray[16] = DURATION;
            dataTypeArray[17] = DATETIME;
            dataTypeArray[18] = GENRE;
            dataTypeArray[21] = INTEGER;
            dataTypeArray[24] = RIAA;
            dataTypeArray[25] = UPC;
            dataTypeArray[27] = BMP;
            TYPES = dataTypeArray;
        }

        private static DataType forInt(int i) {
            DataType type = null;
            if (i >= 0 && i < TYPES.length) {
                type = TYPES[i];
            }
            if (type == null) {
                type = UNDEFINED;
            }
            return type;
        }
    }
}

