/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.common;

import ch.tachyon.tunnel.engine.bean.ClassInfo;
import ch.tachyon.tunnel.engine.bean.MemberInfo;
import ch.tachyon.tunnel.utils.Debug;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterDefinition<P, T> {
    private final Class<P> pluginClass;
    private final Class<T> type;
    private final String name;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPED = new HashMap();

    static {
        PRIMITIVE_TO_WRAPPED.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPED.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPED.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPED.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPED.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPED.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPED.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPED.put(Double.TYPE, Double.class);
    }

    public ParameterDefinition(Class<P> pluginClass, Class<T> type, String name) {
        this.pluginClass = pluginClass;
        this.type = type;
        this.name = name;
        assert (this.propertyExists(pluginClass, type, name)) : "No property " + name + " of type " + type.getSimpleName() + " in class " + pluginClass.getSimpleName();
    }

    private boolean propertyExists(Class<?> clazz, Class<?> type, String propName) {
        for (MemberInfo property : new ClassInfo(clazz).getMembers()) {
            if (!property.getName().equals(propName)) continue;
            Class<?> propType = property.getType();
            if (propType.equals(type)) {
                return true;
            }
            if (type.equals(PRIMITIVE_TO_WRAPPED.get(propType))) {
                return true;
            }
            if (!property.getType().getName().equals(type.getName())) continue;
            Debug.warn("{0} exists in two different ClassLoaders. The use of ParameterDefinition is probably not possible. Consider loading the plugin statically", type);
        }
        return false;
    }

    public Class<P> getPluginClass() {
        return this.pluginClass;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pluginClass == null ? 0 : this.pluginClass.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pluginClass == null ? other.pluginClass != null : !this.pluginClass.equals(other.pluginClass)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "ParameterDefinition [pluginClass=" + this.pluginClass + ", type=" + this.type + ", name=" + this.name + "]";
    }
}

