/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.common;

import ch.tachyon.tunnel.host.IProcessingInfo;
import java.io.Serializable;

public class ProcessingInfo
implements IProcessingInfo,
Cloneable,
Serializable {
    public static final int LENGTH_ANY = -2;
    public static final int LENGTH_UNKNOWN = -1;
    private int numberOfChannels;
    private float sampleRate;
    private int quantization;
    private long length;
    private int maxChunkLength;
    private int fixedChunkLength;

    public ProcessingInfo(int numberOfChannels, float sampleRate, int quantization, int maxChunkLength) {
        this(numberOfChannels, sampleRate, quantization, -1L, maxChunkLength, -2);
    }

    public ProcessingInfo(int numberOfChannels, float sampleRate, int quantization, long length, int maxChunkLength, int fixedChunkLength) {
        this.numberOfChannels = numberOfChannels;
        this.sampleRate = sampleRate;
        this.quantization = quantization;
        this.length = length;
        this.maxChunkLength = maxChunkLength;
        this.fixedChunkLength = fixedChunkLength;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public void setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getQuantization() {
        return this.quantization;
    }

    public void setQuantization(int quantization) {
        this.quantization = quantization;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public int getMaxChunkLength() {
        return this.maxChunkLength;
    }

    public int getMaxChunkLength(int pluginOptimalChunkLength) {
        return this.maxChunkLength;
    }

    public void setMaxChunkLength(int maxChunkLength) {
        this.maxChunkLength = maxChunkLength;
    }

    public int getFixedChunkLength() {
        return this.fixedChunkLength;
    }

    public int getHostPreferredChunkLength() {
        return Math.max(-1, this.fixedChunkLength);
    }

    public int negociateFixedChunkLength(int pluginOptimalChunkLength) {
        if (this.fixedChunkLength <= -2) {
            this.fixedChunkLength = Math.min(this.maxChunkLength, pluginOptimalChunkLength);
        }
        return this.fixedChunkLength;
    }

    public void setFixedChunkLength(int fixedChunkLength) {
        this.fixedChunkLength = fixedChunkLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fixedChunkLength;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + this.maxChunkLength;
        result = 31 * result + this.numberOfChannels;
        result = 31 * result + Float.floatToIntBits(this.sampleRate);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingInfo other = (ProcessingInfo)obj;
        if (this.fixedChunkLength != other.fixedChunkLength) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.maxChunkLength != other.maxChunkLength) {
            return false;
        }
        if (this.numberOfChannels != other.numberOfChannels) {
            return false;
        }
        return Float.floatToIntBits(this.sampleRate) == Float.floatToIntBits(other.sampleRate);
    }

    public String toString() {
        return "ProcessingInfo [numberOfChannels=" + this.numberOfChannels + ", sampleRate=" + this.sampleRate + ", length=" + this.length + ", maxChunkLength=" + this.maxChunkLength + ", fixedChunkLength=" + this.fixedChunkLength + "]";
    }

    public ProcessingInfo clone() {
        try {
            return (ProcessingInfo)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }
}

