/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine;

import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.common.ParameterDefinition;
import ch.tachyon.tunnel.engine.ParameterInfoParameter;
import ch.tachyon.tunnel.engine.ProcessingInfoBridge;
import ch.tachyon.tunnel.engine.PropertyParameter;
import ch.tachyon.tunnel.engine.bean.ClassInfo;
import ch.tachyon.tunnel.engine.bean.MemberInfo;
import ch.tachyon.tunnel.engine.bridges.mthread.DummyMtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.IProcessedFramesMonitor;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionHandler;
import ch.tachyon.tunnel.engine.gui.EffectControlPanel;
import ch.tachyon.tunnel.engine.gui.EffectDialog;
import ch.tachyon.tunnel.engine.storage.PluginStorage;
import ch.tachyon.tunnel.engine.utils.AnnotationUtils;
import ch.tachyon.tunnel.engine.utils.DoubleConverter;
import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.host.IGuiListener;
import ch.tachyon.tunnel.host.IParameter;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.IDynamicMetaData;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.ILoadUnload;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Documentation;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.spec.IRequiredBeforeAfter;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialAccu;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialAccumulator;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.ParameterInfo;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.utils.Debug;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginToHostWrapper<P extends IPlugin>
implements IEffect {
    protected static final int DEFAULT_CHUNK_LENGTH = 2048;
    protected static final int DEFAULT_MAX_LENGTH = 8192;
    protected final IPlugin baseTarget;
    protected final P processingTarget;
    private final IMtContext mtContext;
    private final Class<? extends IEffect> hostInterface;
    private final Properties properties;
    private List<IParameter> parameters;
    private EffectDialog dialog = null;
    private ProcessingInfoBridge pluginInfo;
    private IProcessingInfo hostInfo;
    private PluginStorage storage;
    private boolean hasBegun;
    private AtomicLong processedFrames = new AtomicLong();
    private boolean handleMonitoring;
    private float[][] inputs;
    private int inputIndex;

    protected PluginToHostWrapper(IPlugin baseTarget, P processingTarget, Class<?> hostInterface, IMtContext mtContext, Properties properties) {
        this.baseTarget = baseTarget;
        this.processingTarget = processingTarget;
        this.hostInterface = hostInterface;
        this.mtContext = mtContext;
        this.properties = properties;
    }

    public IPlugin getBaseTarget() {
        return this.baseTarget;
    }

    public P getProcessingTarget() {
        return this.processingTarget;
    }

    @Override
    public String getName() {
        Name nameAnno = this.getAnnotation(Name.class);
        if (nameAnno != null) {
            return nameAnno.value();
        }
        return PluginToHostWrapper.convertName(this.baseTarget.getClass().getSimpleName());
    }

    static String convertName(String name) {
        StringBuilder result = new StringBuilder();
        boolean upperCase = true;
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch) && !upperCase) {
                result.append(' ');
                upperCase = true;
            } else {
                upperCase = false;
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    @Override
    public String getClassName() {
        return this.baseTarget.getClass().getName();
    }

    @Override
    public Class<? extends IEffect> getInterface() {
        return this.hostInterface;
    }

    @Override
    public String getCategory() {
        Category categoryAnno = this.getAnnotation(Category.class);
        if (categoryAnno != null) {
            return categoryAnno.value();
        }
        return null;
    }

    @Override
    public List<IParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.getParameters(this.baseTarget);
        }
        return this.parameters;
    }

    private List<IParameter> getParameters(IPlugin target) {
        ArrayList<IParameter> result = new ArrayList<IParameter>();
        if (target instanceof IDynamicMetaData) {
            List pInfos = ((IDynamicMetaData)((Object)target)).getParameters();
            for (ParameterInfo pInfo : pInfos) {
                ParameterInfoParameter<IPlugin> param = new ParameterInfoParameter<IPlugin>(target, pInfo);
                result.add(param);
            }
        } else {
            ClassInfo info = new ClassInfo(target.getClass());
            for (MemberInfo property : info.getMembers()) {
                PropertyParameter<IPlugin> param = new PropertyParameter<IPlugin>(target, property, this.properties, property.getName());
                result.add(param);
            }
            Collections.sort(result, new Comparator<IParameter>(){

                @Override
                public int compare(IParameter o1, IParameter o2) {
                    PropertyParameter p1 = (PropertyParameter)o1;
                    PropertyParameter p2 = (PropertyParameter)o2;
                    return p1.getOrder() - p2.getOrder();
                }
            });
        }
        return result;
    }

    @Override
    public String getDescription() {
        Description descrAnno = this.getAnnotation(Description.class);
        if (descrAnno != null) {
            return descrAnno.value();
        }
        return null;
    }

    @Override
    public <E extends Annotation> E getAnnotation(Class<E> annoType) {
        return AnnotationUtils.getAnnotation(this.baseTarget.getClass(), annoType, this.properties);
    }

    @Override
    public Reader getDocumentation() {
        Documentation docAnno = this.getAnnotation(Documentation.class);
        if (docAnno != null) {
            InputStream stream = this.baseTarget.getClass().getResourceAsStream(docAnno.value());
            try {
                return new InputStreamReader(stream, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    @Override
    public void load(IProcessingInfo info) {
        this.storage = new PluginStorage(this.baseTarget.getClass());
        this.hostInfo = info;
        this.pluginInfo = new ProcessingInfoBridge(info, this.storage, this.mtContext);
        if (this.baseTarget instanceof ILoadUnload) {
            ((ILoadUnload)((Object)this.baseTarget)).load(this.pluginInfo);
        }
        this.setParameterDefaults();
    }

    private void setParameterDefaults() {
        for (IParameter parameter : this.getParameters()) {
            Range range = parameter.getRange();
            if (range == null) continue;
            Class<?> type = parameter.getType();
            double defValue = range.defaultValue();
            if (Double.isNaN(defValue)) continue;
            parameter.setInternalValue(DoubleConverter.fromDouble(defValue, type));
        }
    }

    @Override
    public JPanel createControlPanel() {
        return new EffectControlPanel(this, this.hostInfo);
    }

    @Override
    public void showGui(JFrame parent, IGuiListener listener) {
        this.dialog = new EffectDialog(parent, this, this.hostInfo, listener);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
    }

    @Override
    public void hideGui() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public <E, T> void setParameterValue(ParameterDefinition<E, T> parameter, T value) {
        this.setParameterValue(parameter.getName(), value);
    }

    public <E, T> T getParameterValue(ParameterDefinition<E, T> parameter) {
        return (T)this.getParameterValue(parameter.getName());
    }

    @Override
    public void setParameterValue(String name, Object value) {
        for (IParameter param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            param.setValue(value, this.hostInfo);
            return;
        }
        throw new IllegalArgumentException("Unknown parameter \"" + name + "\"");
    }

    @Override
    public Object getParameterValue(String name) {
        for (IParameter param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param.getValue(this.hostInfo);
        }
        throw new IllegalArgumentException("Unknown parameter \"" + name + "\"");
    }

    @Override
    public int getPreferredChunkLength() {
        if (this.baseTarget instanceof IFixedChunkLength) {
            return this.pluginInfo.adaptPluginLength(((IFixedChunkLength)((Object)this.baseTarget)).getFixedChunkLength());
        }
        return -1;
    }

    protected int getActualMaxChunkLength(IProcessingInfo info) {
        int result = info.getMaxChunkLength(this.getActualChunkLength());
        if (result < 0) {
            result = 8192;
        }
        return result;
    }

    protected int getActualChunkLength() {
        int result = this.getPreferredChunkLength();
        if (result < 0) {
            result = 2048;
        }
        return result;
    }

    @Override
    public void startProcessing(final IProcessingInfo info) {
        if (info != this.hostInfo) {
            this.hostInfo = info;
            this.pluginInfo = new ProcessingInfoBridge(info, this.storage, this.mtContext);
        }
        this.storage.createChannelStorage();
        if (this.processingTarget instanceof IStartStop) {
            ((IStartStop)this.processingTarget).startProcessing(this.pluginInfo);
        }
        if (!(this.processingTarget instanceof ISerialSectionHandler) && this.baseTarget instanceof IHasSerialSections) {
            MultiThreading mtAnno = this.baseTarget.getClass().getAnnotation(MultiThreading.class);
            if (mtAnno == null && this.getClass().desiredAssertionStatus()) {
                Class<?>[] intfs = this.baseTarget.getClass().getInterfaces();
                boolean hasIt = false;
                Class<?>[] classArray = intfs;
                int n = intfs.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> intf = classArray[n2];
                    if (intf.equals(IHasSerialSections.class)) {
                        hasIt = true;
                    }
                    ++n2;
                }
                if (hasIt) {
                    Debug.warn("Plugin " + this.baseTarget.getClass() + " implements IHasSerialSection, but lacks the @MultiThreading annotation." + "\nThe engine will supply dummy ISerialSection implementations to make it work. However, you way want to check if this makes sense.", new Object[0]);
                }
            }
            final DummyMtContext mtContext = new DummyMtContext();
            ((IHasSerialSections)((Object)this.baseTarget)).createSerialSections(new ISerialSectionFactory(){

                @Override
                public void ensureMinInputHistorySize(int value) {
                    PluginToHostWrapper.this.inputs = new float[value * info.getNumberOfChannels()][];
                    PluginToHostWrapper.this.inputIndex = 0;
                }

                @Override
                public ISerialSection createSerialSection(String name, Object userData) {
                    return new DummySerialSection(name, userData);
                }

                @Override
                public <E> ISerialAccumulator<E> createSerialAccumulator(Class<E> workType, String name, Object userData, float relCapacity) {
                    return new DummySerialAccu(name, userData);
                }

                @Override
                public IMtContext getMtContext() {
                    return mtContext;
                }
            });
        }
        this.hasBegun = false;
        this.processedFrames.set(0L);
        this.handleMonitoring = true;
        if (this.processingTarget instanceof IProcessedFramesMonitor) {
            ((IProcessedFramesMonitor)this.processingTarget).setCounter(this.processedFrames);
            this.handleMonitoring = false;
        }
    }

    protected int getLatency(IoDirection ioDirection) {
        if (this.baseTarget instanceof ILatency) {
            return ((ILatency)((Object)this.baseTarget)).getLatency(ioDirection);
        }
        return 0;
    }

    @Override
    public long getAdditionalInputFrames() {
        return this.getLatency(IoDirection.INPUT);
    }

    @Override
    public long getRequiredSamplesBefore() {
        if (this.baseTarget instanceof IRequiredBeforeAfter) {
            return ((IRequiredBeforeAfter)((Object)this.baseTarget)).getRequiredSamplesBefore(this.pluginInfo);
        }
        return 0L;
    }

    @Override
    public long getRequiredSamplesAfter() {
        if (this.baseTarget instanceof IRequiredBeforeAfter) {
            return ((IRequiredBeforeAfter)((Object)this.baseTarget)).getRequiredSamplesAfter(this.pluginInfo);
        }
        return 0L;
    }

    @Override
    public float getTimeChange() {
        int latencyIn = this.getLatency(IoDirection.INPUT);
        int latencyOut = this.getLatency(IoDirection.OUTPUT);
        if (latencyIn == 0) {
            return 1.0f;
        }
        return (float)latencyOut / (float)latencyIn;
    }

    @Override
    public void beginProcessing(IProcessingInfo info) {
        if (info != this.hostInfo) {
            this.hostInfo = info;
            this.pluginInfo = new ProcessingInfoBridge(info, this.storage, this.mtContext);
        }
        if (this.processingTarget instanceof IBeginProcessing) {
            ((IBeginProcessing)this.processingTarget).beginProcessing(this.pluginInfo);
        }
        this.hasBegun = true;
    }

    protected void beginIfWorth() {
        if (!this.hasBegun) {
            this.beginProcessing(this.hostInfo);
        }
    }

    protected float[] wrapInput(float[] input) {
        if (this.inputs != null) {
            if (this.inputs[this.inputIndex] == null || this.inputs[this.inputIndex].length != input.length) {
                this.inputs[this.inputIndex] = new float[input.length];
            }
            System.arraycopy(input, 0, this.inputs[this.inputIndex], 0, input.length);
            input = this.inputs[this.inputIndex];
            this.inputIndex = (this.inputIndex + 1) % this.inputs.length;
        }
        return input;
    }

    protected float[][] wrapInput(float[][] input) {
        if (this.inputs == null) {
            return input;
        }
        float[][] result = new float[input.length][];
        int c = 0;
        while (c < input.length) {
            result[c] = this.wrapInput(input[c]);
            ++c;
        }
        return result;
    }

    protected boolean isSane(float[] data, boolean in) {
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            if (Float.isInfinite(v) || Float.isNaN(v)) {
                if (in) {
                    assert (false) : "Infinite or NaN value supplied by the host";
                } else assert (false) : "Infinite or NaN value produced by the plugin";
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void unwrapInput(float[] wrapped, float[] initial) {
        if (wrapped != initial) {
            System.arraycopy(wrapped, 0, initial, 0, wrapped.length);
        }
    }

    protected void processed(long nbFrames) {
        if (this.handleMonitoring) {
            this.processedFrames.addAndGet(nbFrames);
        }
    }

    @Override
    public long getProcessedFrames() {
        return this.processedFrames.get();
    }

    @Override
    public void stopProcessing() {
        if (this.processingTarget instanceof IStartStop) {
            ((IStartStop)this.processingTarget).stopProcessing();
        }
        this.inputs = null;
        this.storage.destroyChannelStorage();
    }

    @Override
    public void unload() {
        if (this.baseTarget instanceof ILoadUnload) {
            ((ILoadUnload)((Object)this.baseTarget)).unload();
        }
        this.hostInfo = null;
        this.pluginInfo = null;
        this.storage = null;
    }

    protected IProcessingInfo getHostInfo() {
        return this.hostInfo;
    }

    protected ch.tachyon.tunnel.plugin.IProcessingInfo getPluginInfo() {
        return this.pluginInfo;
    }

    protected boolean needsRebuffering() {
        int pluginChunkSize = this.getPreferredChunkLength();
        if (pluginChunkSize <= 0) {
            return false;
        }
        return pluginChunkSize != this.hostInfo.negociateFixedChunkLength(pluginChunkSize);
    }

    public String toString() {
        return "IEffect Wrapper [name=" + this.getName() + ",class=" + this.baseTarget.getClass().getName() + ",interface=" + this.hostInterface.getSimpleName();
    }
}

