/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine;

import ch.tachyon.tunnel.engine.bridges.McEffectFromMcEffect;
import ch.tachyon.tunnel.engine.bridges.McPullFromMcEffect;
import ch.tachyon.tunnel.engine.bridges.McPullFromMcPull;
import ch.tachyon.tunnel.engine.bridges.McPushFromMcPush;
import ch.tachyon.tunnel.engine.bridges.ScEffectFromScEffect;
import ch.tachyon.tunnel.engine.bridges.ScPullFromScEffect;
import ch.tachyon.tunnel.engine.bridges.ScPullFromScPull;
import ch.tachyon.tunnel.engine.bridges.ScPullFromScPush;
import ch.tachyon.tunnel.engine.bridges.ScPushFromScEffect;
import ch.tachyon.tunnel.engine.bridges.ScPushFromScPull;
import ch.tachyon.tunnel.engine.bridges.ScPushFromScPush;
import ch.tachyon.tunnel.engine.bridges.mthread.BridgeMcSimpleAsPush;
import ch.tachyon.tunnel.engine.bridges.mthread.BridgeScSimpleAsPull;
import ch.tachyon.tunnel.engine.bridges.mthread.BridgeScSimpleAsPush;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.MtMcPush;
import ch.tachyon.tunnel.engine.bridges.mthread.MtScPull;
import ch.tachyon.tunnel.engine.bridges.mthread.MtScPush;
import ch.tachyon.tunnel.engine.bridges.mthread.old.NumaScPush;
import ch.tachyon.tunnel.engine.utils.AnnotationUtils;
import ch.tachyon.tunnel.engine.utils.CodecInputStream;
import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.host.ISingleChanEffect;
import ch.tachyon.tunnel.host.ISingleChanPullEffect;
import ch.tachyon.tunnel.host.ISingleChanPushEffect;
import ch.tachyon.tunnel.plugin.IMultiChanEffect;
import ch.tachyon.tunnel.plugin.IMultiChanPullEffect;
import ch.tachyon.tunnel.plugin.IMultiChanPushEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IPullEffect;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.IMultiStep;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsImpl {
    private static final String PLUGINS_RESOURCE = "META-INF/services/ch.tachyon.tunnel.Plugins";
    private static final int PRIORITY_STRAIGHT = 0;
    private static final int PRIORITY_EASY = 1;
    private static final int PRIORITY_HARD = 2;
    private static final Map<Pair<Class<? extends IPlugin>, Class<? extends IEffect>>, Class<? extends IEffect>> bridges = new HashMap<Pair<Class<? extends IPlugin>, Class<? extends IEffect>>, Class<? extends IEffect>>();
    private static final Map<Class<? extends IEffect>, Integer> bridgePriorities = new HashMap<Class<? extends IEffect>, Integer>();

    static {
        PluginsImpl.addBridge(ISimpleEffect.class, ISingleChanEffect.class, ScEffectFromScEffect.class, 0);
        PluginsImpl.addBridge(IMultiChanEffect.class, ch.tachyon.tunnel.host.ISimpleEffect.class, McEffectFromMcEffect.class, 0);
        PluginsImpl.addBridge(IPullEffect.class, ISingleChanPullEffect.class, ScPullFromScPull.class, 0);
        PluginsImpl.addBridge(IMultiChanPullEffect.class, ch.tachyon.tunnel.host.IPullEffect.class, McPullFromMcPull.class, 0);
        PluginsImpl.addBridge(IPushEffect.class, ISingleChanPushEffect.class, ScPushFromScPush.class, 0);
        PluginsImpl.addBridge(IMultiChanPushEffect.class, ch.tachyon.tunnel.host.IPushEffect.class, McPushFromMcPush.class, 0);
        PluginsImpl.addBridge(ISimpleEffect.class, ISingleChanPullEffect.class, ScPullFromScEffect.class, 1);
        PluginsImpl.addBridge(ISimpleEffect.class, ISingleChanPushEffect.class, ScPushFromScEffect.class, 1);
        PluginsImpl.addBridge(IMultiChanEffect.class, ch.tachyon.tunnel.host.IPullEffect.class, McPullFromMcEffect.class, 1);
        PluginsImpl.addBridge(IPullEffect.class, ISingleChanPushEffect.class, ScPushFromScPull.class, 2);
        PluginsImpl.addBridge(IPushEffect.class, ISingleChanPullEffect.class, ScPullFromScPush.class, 2);
    }

    private static <P extends IPlugin, H extends IEffect> void addBridge(Class<P> pluginInterface, Class<H> hostInterface, Class<? extends H> bridgeType, int priority) {
        bridges.put(new Pair<Class<P>, Class<H>>(pluginInterface, hostInterface), bridgeType);
        bridgePriorities.put(bridgeType, priority);
    }

    public static List<IEffect> loadAllPlugins(ClassLoader classLoader, MtContext mtContext, Class<?> ... types) throws IOException {
        ArrayList<IEffect> plugins = new ArrayList<IEffect>();
        Enumeration<URL> pluginLists = classLoader.getResources(PLUGINS_RESOURCE);
        while (pluginLists.hasMoreElements()) {
            URL pluginList = pluginLists.nextElement();
            InputStream stream = pluginList.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            try {
                String line = reader.readLine();
                while (line != null) {
                    String className;
                    IEffect effect;
                    if (!line.trim().equals("") && !line.trim().startsWith("#") && (effect = PluginsImpl.loadEffect(classLoader, types, className = line.trim(), mtContext)) != null) {
                        plugins.add(effect);
                    }
                    line = reader.readLine();
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return plugins;
    }

    public static <E extends IEffect> E loadPlugin(ClassLoader classLoader, MtContext mtContext, Class<E> type, String className) {
        IEffect result = PluginsImpl.loadEffect(classLoader, new Class[]{type}, className, mtContext);
        assert (result == null || type.isInstance(result));
        return (E)result;
    }

    private static IEffect loadEffect(ClassLoader cl, Class<?>[] hostInterfaces, String className, MtContext mtContext) {
        Class<?> type;
        block5: {
            type = Class.forName(className, true, cl);
            if (IPlugin.class.isAssignableFrom(type)) break block5;
            Debug.error("Not a plugin: {0}", className);
            return null;
        }
        try {
            Class<?> effectType = type;
            return PluginsImpl.createEffect(hostInterfaces, effectType, mtContext);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static IEffect createEffect(Class<?>[] hostInterfaces, Class<? extends IPlugin> effectType, MtContext mtContext) throws InstantiationException, IllegalAccessException {
        List<Class<? extends IPlugin>> effectInterfaces = PluginsImpl.getEffectInterfaces(effectType);
        for (Class<? extends IPlugin> effectInterface : effectInterfaces) {
            IEffect result = PluginsImpl.createEffect(hostInterfaces, effectType, effectInterface, mtContext);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Properties loadProperties(Class<?> forClass) {
        Properties properties = new Properties();
        InputStream input = forClass.getResourceAsStream(String.valueOf(forClass.getSimpleName()) + ".properties");
        if (input == null) {
            return properties;
        }
        try {
            CodecInputStream codec = new CodecInputStream(input, "UTF-8", "ISO-8859-1");
            properties.load(codec);
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return properties;
    }

    private static IEffect createEffect(Class<?>[] hostInterfaces, Class<? extends IPlugin> effectType, Class<? extends IPlugin> effectInterface, MtContext mtContext) throws InstantiationException, IllegalAccessException {
        IPlugin plugin;
        int n;
        int n2;
        Class<?>[] classArray;
        Properties properties = PluginsImpl.loadProperties(effectType);
        MultiThreading mtAnno = AnnotationUtils.getAnnotation(effectType, MultiThreading.class, properties);
        if (PluginsImpl.isMultiThreadingSupported(mtAnno, mtContext)) {
            Class<?> hostInterface;
            boolean hostPullOk;
            boolean hostPushOk;
            if (effectInterface.equals(ISimpleEffect.class)) {
                hostPushOk = false;
                hostPullOk = false;
                classArray = hostInterfaces;
                n2 = hostInterfaces.length;
                n = 0;
                while (n < n2) {
                    hostInterface = classArray[n];
                    if (hostInterface.equals(ISingleChanPushEffect.class)) {
                        hostPushOk = true;
                    }
                    if (hostInterface.equals(ISingleChanPullEffect.class)) {
                        hostPullOk = true;
                    }
                    ++n;
                }
                if (hostPushOk) {
                    effectInterface = IPushEffect.class;
                } else if (hostPullOk) {
                    effectInterface = IPullEffect.class;
                }
            }
            if (effectInterface.equals(IMultiChanEffect.class)) {
                hostPushOk = false;
                hostPullOk = false;
                classArray = hostInterfaces;
                n2 = hostInterfaces.length;
                n = 0;
                while (n < n2) {
                    hostInterface = classArray[n];
                    if (hostInterface.equals(ch.tachyon.tunnel.host.IPushEffect.class)) {
                        hostPushOk = true;
                    }
                    if (hostInterface.equals(ch.tachyon.tunnel.host.IPullEffect.class)) {
                        hostPullOk = true;
                    }
                    ++n;
                }
                if (hostPushOk) {
                    effectInterface = IMultiChanPushEffect.class;
                } else if (hostPullOk) {
                    effectInterface = IMultiChanPullEffect.class;
                }
            }
        }
        Pair bestConversion = null;
        int bestPriority = Integer.MAX_VALUE;
        classArray = hostInterfaces;
        n2 = hostInterfaces.length;
        n = 0;
        while (n < n2) {
            Class<? extends IEffect> converterType;
            int priority;
            Class<?> hostInterface0 = classArray[n];
            if (!IEffect.class.isAssignableFrom(hostInterface0)) {
                throw new IllegalArgumentException("Not a valid effect type: " + hostInterface0);
            }
            Class<?> hostInterface = hostInterface0;
            Pair conversion = new Pair(effectInterface, hostInterface);
            if (bridges.containsKey(conversion) && (priority = bridgePriorities.get(converterType = bridges.get(conversion)).intValue()) < bestPriority) {
                bestConversion = conversion;
                bestPriority = priority;
            }
            ++n;
        }
        if (bestConversion == null) {
            return null;
        }
        IPlugin processor = plugin = effectType.newInstance();
        Class<? extends IEffect> converterType = bridges.get(bestConversion);
        IEffect converter = PluginsImpl.newConverter(converterType, effectInterface, plugin, processor, properties, mtAnno, mtContext);
        return converter;
    }

    private static List<Class<? extends IPlugin>> getEffectInterfaces(Class<? extends IPlugin> effectType) {
        ArrayList<Class<? extends IPlugin>> result = new ArrayList<Class<? extends IPlugin>>();
        Class<? extends IPlugin> currentType = effectType;
        do {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = currentType.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> intf = classArray[n2];
                if (PluginsImpl.interfaceExtends(intf, IPlugin.class)) {
                    Class<?> pluginIntf = intf;
                    result.add(pluginIntf);
                }
                ++n2;
            }
        } while ((currentType = currentType.getSuperclass()) != null);
        return result;
    }

    private static boolean interfaceExtends(Class<?> intf, Class<?> parent) {
        Class<?>[] parents;
        Class<?>[] classArray = parents = intf.getInterfaces();
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> p = classArray[n2];
            if (p.equals(parent)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static <H extends IEffect, P extends IPlugin> H newConverter(Class<H> converterType, Class<P> targetType, IPlugin target, IPlugin processingTarget, Properties properties, MultiThreading mtSpecs, MtContext mtContext) {
        try {
            if (PluginsImpl.isMultiThreadingSupported(mtSpecs, mtContext)) {
                if (processingTarget instanceof ISimpleEffect && targetType.equals(IPushEffect.class)) {
                    processingTarget = new BridgeScSimpleAsPush((ISimpleEffect)processingTarget);
                }
                if (processingTarget instanceof ISimpleEffect && targetType.equals(IPullEffect.class)) {
                    processingTarget = new BridgeScSimpleAsPull((ISimpleEffect)processingTarget);
                }
                if (processingTarget instanceof IMultiChanEffect && targetType.equals(IMultiChanPushEffect.class)) {
                    processingTarget = new BridgeMcSimpleAsPush((IMultiChanEffect)processingTarget);
                }
                if (processingTarget instanceof IPushEffect && processingTarget instanceof IMultiStep) {
                    processingTarget = new NumaScPush<IPushEffect>((IPushEffect)processingTarget);
                } else if (processingTarget instanceof IPushEffect) {
                    processingTarget = new MtScPush((IPushEffect)processingTarget, mtContext);
                } else if (processingTarget instanceof IPullEffect) {
                    processingTarget = new MtScPull((IPullEffect)processingTarget, mtContext);
                } else if (processingTarget instanceof IMultiChanPushEffect) {
                    processingTarget = new MtMcPush((IMultiChanPushEffect)processingTarget, mtContext);
                }
            }
            Constructor<H> cons = converterType.getConstructor(IPlugin.class, targetType, IMtContext.class, Properties.class);
            IEffect result = (IEffect)cons.newInstance(target, processingTarget, mtContext, properties);
            return (H)result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static boolean isMultiThreadingSupported(MultiThreading mtAnno, MtContext mtContext) {
        boolean result;
        boolean bl = result = mtAnno != null && !mtAnno.markov();
        if (!mtContext.isMultiCore()) {
            result = false;
        }
        return result;
    }

    public static <I extends IEffect, E extends IPlugin> I getPlugin(Class<I> commIntf, Class<E> pluginClass, MtContext mtContext) {
        try {
            IEffect result = PluginsImpl.createEffect(new Class[]{commIntf}, pluginClass, mtContext);
            return (I)result;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new InstantiationError(ex.toString());
        }
    }
}

