/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine;

import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IStorage;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;

public class ProcessingInfoBridge
implements ch.tachyon.tunnel.plugin.IProcessingInfo {
    private final IProcessingInfo target;
    private final IStorage storage;
    private final IMtContext mtContext;
    private int timeLocal;
    private int addedLength;
    private int pluginLength;
    private int hostLength;

    public ProcessingInfoBridge(IProcessingInfo target) {
        this(target, null, null);
    }

    public ProcessingInfoBridge(IProcessingInfo target, IStorage storage, IMtContext mtContext) {
        this.target = target;
        this.storage = storage;
        this.mtContext = mtContext;
    }

    public int getTimeLocal() {
        return this.timeLocal;
    }

    public void setTimeLocal(int historySize) {
        this.timeLocal = historySize;
    }

    public int getNumberOfChannels() {
        return this.target.getNumberOfChannels();
    }

    public float getSampleRate() {
        return this.target.getSampleRate();
    }

    public int getQuantization() {
        return this.target.getQuantization();
    }

    public int getMaxChunkLength(int pluginOptimalChunkLength) {
        return this.adaptHostLength(this.target.getMaxChunkLength(this.adaptPluginLength(pluginOptimalChunkLength)));
    }

    public int getHostPreferredChunkLength() {
        return this.adaptHostLength(this.target.getHostPreferredChunkLength());
    }

    public int negociateFixedChunkLength(int pluginOptimalChunkLength) {
        return this.adaptHostLength(this.target.negociateFixedChunkLength(this.adaptPluginLength(pluginOptimalChunkLength)));
    }

    public long getLength() {
        return this.target.getLength();
    }

    public IStorage getStorage() {
        return this.storage;
    }

    int adaptPluginLength(int pluginLength) {
        this.pluginLength = pluginLength;
        if (pluginLength < 0) {
            return -1;
        }
        this.addedLength = this.timeLocal / pluginLength * pluginLength;
        int result = pluginLength + this.addedLength - this.timeLocal;
        assert (result > 0);
        return result;
    }

    int adaptHostLength(int hostLength) {
        this.hostLength = hostLength;
        if (hostLength < 0) {
            return -1;
        }
        int result = hostLength + this.timeLocal - this.addedLength;
        assert (result > 0);
        return result;
    }

    public int getAddedLength() {
        return this.addedLength;
    }

    public int getPluginLength() {
        return this.pluginLength;
    }

    public int getHostLength() {
        return this.hostLength;
    }

    public IMtContext getMtContext() {
        return this.mtContext;
    }
}

