/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine;

import ch.tachyon.tunnel.engine.IdentityTransform;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.ProcessingInfoBridge;
import ch.tachyon.tunnel.engine.bean.MemberInfo;
import ch.tachyon.tunnel.engine.utils.DoubleConverter;
import ch.tachyon.tunnel.engine.utils.DynamicAnnotationHandler;
import ch.tachyon.tunnel.engine.utils.PropertiesAnnotationHandler;
import ch.tachyon.tunnel.host.IParameter;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.param.IParameterTransform;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Transform;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyParameter<P extends IPlugin>
implements IParameter {
    private final P plugin;
    private final Properties properties;
    private final String propertyPrefix;
    private final Method reader;
    private final Method writer;
    private final Class<?> type;
    private final String javaName;
    private final String displayName;
    private final int order;

    public PropertyParameter(P plugin, MemberInfo property, Properties properties, String propertyPrefix) {
        String propName;
        this.plugin = plugin;
        this.reader = property.getReader();
        this.writer = property.getWriter();
        this.type = property.getType();
        this.properties = properties;
        this.propertyPrefix = propertyPrefix;
        this.javaName = propName = property.getName();
        Name nameAnno = this.getAnnotation(Name.class);
        this.displayName = nameAnno != null ? nameAnno.value() : PluginToHostWrapper.convertName(String.valueOf(propName.substring(0, 1).toUpperCase()) + propName.substring(1));
        Order orderAnno = this.getAnnotation(Order.class);
        this.order = orderAnno != null ? orderAnno.value() : 0;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.javaName;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        Description description = this.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        return null;
    }

    @Override
    public String getUnit() {
        Unit unit = this.getAnnotation(Unit.class);
        if (unit != null) {
            return unit.value();
        }
        return null;
    }

    @Override
    public IParameterTransform getTransform() {
        Transform transformAnno = this.getAnnotation(Transform.class);
        if (transformAnno != null) {
            try {
                return transformAnno.value().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Cannot instanciate " + transformAnno.value() + " specified by the @Transform annotation on parameter \"" + this.displayName + "\" of the plugin \"" + this.plugin.getClass().getName() + "\"", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Cannot instanciate " + transformAnno.value() + " specified by the @Transform annotation on parameter \"" + this.displayName + "\" of the plugin \"" + this.plugin.getClass().getName() + "\"", ex);
            }
        }
        return IdentityTransform.getInstance();
    }

    @Override
    public Range getRange() {
        return this.getAnnotation(Range.class);
    }

    @Override
    public ScaleType getScaleType() {
        Scale scale = this.getAnnotation(Scale.class);
        if (scale != null) {
            return scale.value();
        }
        return ScaleType.LINEAR;
    }

    @Override
    public <E extends Annotation> E getAnnotation(Class<E> annoType) {
        E result = this.reader.getAnnotation(annoType);
        if (result != null) {
            return result;
        }
        if (this.isAnnoPropertyPresent(annoType)) {
            return DynamicAnnotationHandler.newAnnotation(annoType, new PropertiesAnnotationHandler(annoType, this.properties, String.valueOf(this.propertyPrefix) + "." + annoType.getSimpleName()));
        }
        return null;
    }

    private boolean isAnnoPropertyPresent(Class<?> annoType) {
        String prefix = String.valueOf(this.propertyPrefix) + "." + annoType.getSimpleName();
        for (Object key0 : this.properties.keySet()) {
            String key = String.valueOf(key0);
            if (!key.equals(prefix) && !key.startsWith(String.valueOf(prefix) + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(IProcessingInfo info) {
        Object value = this.getInternalValue();
        if (value instanceof Number) {
            value = this.getTransform().transform((Number)value, new ProcessingInfoBridge(info));
        }
        return value;
    }

    @Override
    public void setValue(Object value, IProcessingInfo info) {
        if (value instanceof Number) {
            value = this.getTransform().untransform((Number)value, new ProcessingInfoBridge(info));
        }
        this.setInternalValue(value);
    }

    @Override
    public Object getInternalValue() {
        try {
            return this.reader.invoke(this.plugin, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void setInternalValue(Object value) {
        double doubleValue;
        Range range = this.getRange();
        if (range != null && ((doubleValue = DoubleConverter.toDouble(value, this.type)) < range.minValue() || doubleValue > range.maxValue())) {
            throw new IllegalArgumentException("Value out of range for parameter \"" + this.getDisplayName() + "\": " + value + "; " + "range: [" + DoubleConverter.fromDouble(range.minValue(), this.type) + " - " + DoubleConverter.fromDouble(range.maxValue(), this.type) + "]");
        }
        Class<?> valueClass = value.getClass();
        if (!this.type.isAssignableFrom(valueClass) && !this.type.isPrimitive()) {
            if (this.type.getName().equals(valueClass.getName())) {
                throw new ClassCastException("ClassLoader mismatch: the value loaded with ClassLoader \"" + valueClass.getClassLoader() + "\" cannot be assigned to the plugin loaded with ClassLoader \"" + this.type.getClassLoader() + "\"");
            }
            throw new ClassCastException(valueClass + " is not assignable to " + this.type);
        }
        try {
            this.writer.invoke(this.plugin, value);
        }
        catch (IllegalArgumentException ex) {
            if (this.type.isPrimitive()) {
                throw new ClassCastException(value.getClass() + " is not assignable to " + this.type);
            }
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }
}

