/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.McRebufferizer;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.ISimpleEffect;
import ch.tachyon.tunnel.plugin.IMultiChanEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McEffectFromMcEffect
extends PluginToHostWrapper<IMultiChanEffect>
implements ISimpleEffect {
    private McRebufferizer rebufferizer = null;

    public McEffectFromMcEffect(IPlugin baseTarget, IMultiChanEffect processingTarget, IMtContext mtContext, Properties properties) {
        super(baseTarget, processingTarget, ISimpleEffect.class, mtContext, properties);
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.rebufferizer = super.needsRebuffering() ? new McRebufferizer(info.getNumberOfChannels(), this.getActualMaxChunkLength(info), this.getActualChunkLength()) : null;
    }

    @Override
    public int getLatency() {
        if (this.rebufferizer == null) {
            return super.getLatency(IoDirection.OUTPUT);
        }
        return super.getLatency(IoDirection.OUTPUT) + this.rebufferizer.getLatency();
    }

    @Override
    public void process(float[][] samples) {
        this.beginIfWorth();
        if (this.rebufferizer == null) {
            ((IMultiChanEffect)this.processingTarget).process(samples);
        } else {
            this.rebufferizer.submitVariable(samples);
            float[][] fixed = this.rebufferizer.retrieveFixed();
            while (fixed != null) {
                ((IMultiChanEffect)this.processingTarget).process(fixed);
                this.rebufferizer.submitFixed(fixed);
                fixed = this.rebufferizer.retrieveFixed();
            }
            this.rebufferizer.retrieveVariable(samples);
        }
        super.processed(samples[0].length);
    }

    @Override
    public void stopProcessing() {
        super.stopProcessing();
        this.rebufferizer = null;
    }
}

