/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.McRebufferizer;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.IPullEffect;
import ch.tachyon.tunnel.plugin.IMultiChanEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPullFromMcEffect
extends PluginToHostWrapper<IMultiChanEffect>
implements IPullEffect,
IMultiChanAudioSource {
    private McRebufferizer rebufferizer;
    private IMultiChanAudioSource curSource;
    private int maxChunkSize;
    private int headOutToSkip;
    private int tailInToPad;

    public McPullFromMcEffect(IPlugin baseTarget, IMultiChanEffect processingTarget, IMtContext mtContext, Properties properties) {
        super(baseTarget, processingTarget, IPullEffect.class, mtContext, properties);
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return false;
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        if (this.needsRebuffering()) {
            this.maxChunkSize = this.getActualMaxChunkLength(info);
            this.rebufferizer = new McRebufferizer(info.getNumberOfChannels(), this.maxChunkSize, this.getActualChunkLength());
        } else {
            this.rebufferizer = null;
        }
        this.headOutToSkip = this.getFullLatency(IoDirection.OUTPUT);
        this.tailInToPad = this.getFullLatency(IoDirection.INPUT);
    }

    @Override
    protected boolean needsRebuffering() {
        if (super.needsRebuffering()) {
            return true;
        }
        return super.getLatency(IoDirection.INPUT) > 0 || super.getLatency(IoDirection.OUTPUT) > 0;
    }

    private int getFullLatency(IoDirection ioDirection) {
        if (this.rebufferizer == null) {
            return super.getLatency(ioDirection);
        }
        return super.getLatency(ioDirection) + this.rebufferizer.getLatency();
    }

    @Override
    public int process(IMultiChanAudioSource source, float[][] output) {
        this.beginIfWorth();
        this.curSource = source;
        while (this.headOutToSkip > 0) {
            int amount = Math.min(this.headOutToSkip, this.maxChunkSize);
            float[][] temp = new float[output.length][amount];
            this.readSamples(temp);
            this.process0(temp);
            this.headOutToSkip -= amount;
        }
        int count = this.readSamples(output);
        this.process0(output);
        super.processed(count);
        return count;
    }

    protected void process0(float[][] output) {
        if (this.rebufferizer == null) {
            ((IMultiChanEffect)this.processingTarget).process(output);
        } else {
            this.rebufferizer.submitVariable(output);
            float[][] fixed = this.rebufferizer.retrieveFixed();
            while (fixed != null) {
                ((IMultiChanEffect)this.processingTarget).process(fixed);
                this.rebufferizer.submitFixed(fixed);
                fixed = this.rebufferizer.retrieveFixed();
            }
            this.rebufferizer.retrieveVariable(output);
        }
    }

    @Override
    public int readSamples(float[][] target) {
        int result = this.curSource.readSamples(target);
        if (result < target[0].length && this.tailInToPad > 0) {
            int amount = Math.min(target[0].length - result, this.tailInToPad);
            int i = 0;
            while (i < target.length) {
                Arrays.fill(target[i], result, result + amount, 0.0f);
                ++i;
            }
            this.tailInToPad -= amount;
            result += amount;
        }
        return result;
    }
}

