/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.IPullEffect;
import ch.tachyon.tunnel.plugin.IMultiChanPullEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPullFromMcPull
extends PluginToHostWrapper<IMultiChanPullEffect>
implements IPullEffect,
IMultiChanAudioSource {
    private IMultiChanPullEffect wrappedTarget;
    private IMultiChanAudioSource curSource;
    private int headOutToSkip;
    private int tailInToPad;

    public McPullFromMcPull(IPlugin baseTarget, IMultiChanPullEffect processingTarget, IMtContext mtContext, Properties properties) {
        super(baseTarget, processingTarget, IPullEffect.class, mtContext, properties);
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.headOutToSkip = super.getLatency(IoDirection.OUTPUT);
        this.tailInToPad = super.getLatency(IoDirection.INPUT);
        this.wrappedTarget = super.needsRebuffering() ? new IMultiChanPullEffect(info){
            private final float[][] buffer;
            private int bufferIndex;
            private int bufferAvailable;
            {
                this.buffer = new float[iProcessingInfo.getNumberOfChannels()][McPullFromMcPull.this.getActualChunkLength()];
                this.bufferIndex = this.buffer[0].length;
            }

            public int process(IMultiChanAudioSource source, float[][] output) {
                int outIndex = 0;
                int result = 0;
                while (outIndex < output.length) {
                    if (this.bufferIndex >= this.buffer[0].length) {
                        this.bufferAvailable = ((IMultiChanPullEffect)McPullFromMcPull.this.processingTarget).process(source, this.buffer);
                        this.bufferIndex = 0;
                    }
                    int amount = Math.min(output[0].length - outIndex, this.buffer[0].length - this.bufferIndex);
                    System.arraycopy(this.buffer, this.bufferIndex, output, outIndex, amount);
                    result += Math.max(0, Math.min(amount, this.bufferAvailable - this.bufferIndex));
                    outIndex += amount;
                    this.bufferIndex += amount;
                }
                return result;
            }

            public boolean canWriteFasterThanRead() {
                return ((IMultiChanPullEffect)McPullFromMcPull.this.processingTarget).canWriteFasterThanRead();
            }
        } : (IMultiChanPullEffect)this.processingTarget;
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IMultiChanPullEffect)this.processingTarget).canWriteFasterThanRead();
    }

    @Override
    public int process(IMultiChanAudioSource source, float[][] output) {
        this.beginIfWorth();
        this.curSource = source;
        if (this.headOutToSkip > 0) {
            float[][] temp = new float[output.length][this.headOutToSkip];
            this.wrappedTarget.process(this, temp);
            this.headOutToSkip = 0;
        }
        int result = this.wrappedTarget.process(source, output);
        return result;
    }

    @Override
    public int readSamples(float[][] target) {
        int result = this.curSource.readSamples(target);
        if (result < target.length && this.tailInToPad > 0) {
            int amount = Math.min(target.length - result, this.tailInToPad);
            int i = 0;
            while (i < target.length) {
                Arrays.fill(target[0], result, result + amount, 0.0f);
                ++i;
            }
            this.tailInToPad -= amount;
            result += amount;
        }
        super.processed(result);
        return result;
    }
}

