/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.IMultiChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.McRebufferizer;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.IPushEffect;
import ch.tachyon.tunnel.plugin.IMultiChanPushEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPushFromMcPush
extends PluginToHostWrapper<IMultiChanPushEffect>
implements IPushEffect,
IMultiChanAudioSink {
    private IMultiChanAudioSink curSink;
    private McRebufferizer rebufferizer = null;
    private int headOutToSkip;
    private int tailInToPad;
    private int maxInputLength;

    public McPushFromMcPush(IPlugin baseTarget, IMultiChanPushEffect processingTarget, IMtContext mtContext, Properties properties) {
        super(baseTarget, processingTarget, IPushEffect.class, mtContext, properties);
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IMultiChanPushEffect)this.processingTarget).canWriteFasterThanRead();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.headOutToSkip = super.getLatency(IoDirection.OUTPUT);
        this.tailInToPad = super.getLatency(IoDirection.INPUT);
        this.maxInputLength = this.getActualMaxChunkLength(info);
        this.rebufferizer = super.needsRebuffering() ? new McRebufferizer(info.getNumberOfChannels(), this.maxInputLength, this.getActualChunkLength()) : null;
    }

    @Override
    public void process(float[][] input, int length, IMultiChanAudioSink sink) {
        this.beginIfWorth();
        int nbChans = input.length;
        int nbSamples = input[0].length;
        int c = 0;
        while (c < nbChans) {
            assert (super.isSane(input[c], true));
            ++c;
        }
        if (length > this.maxInputLength) {
            throw new IllegalArgumentException("Host error: the given length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        this.curSink = sink;
        if (length == nbSamples) {
            if (this.rebufferizer == null) {
                input = super.wrapInput(input);
                ((IMultiChanPushEffect)this.processingTarget).process(input, length, this);
            } else {
                this.rebufferizer.submitVariable(input);
                float[][] fixed = this.rebufferizer.retrieveFixed();
                while (fixed != null) {
                    fixed = super.wrapInput(fixed);
                    ((IMultiChanPushEffect)this.processingTarget).process(fixed, this.rebufferizer.getTargetSize(), this);
                    fixed = this.rebufferizer.retrieveFixed();
                }
            }
        } else {
            int remaining = length + this.tailInToPad;
            boolean tailSent = false;
            boolean lastSent = false;
            while (remaining > 0 && !tailSent) {
                int c2 = 0;
                while (c2 < nbChans) {
                    Arrays.fill(input[c2], length, nbSamples, 0.0f);
                    ++c2;
                }
                if (this.rebufferizer == null) {
                    input = super.wrapInput(input);
                    int amount = Math.min(remaining, nbSamples);
                    if (amount < nbSamples) {
                        lastSent = true;
                    }
                    ((IMultiChanPushEffect)this.processingTarget).process(input, amount, this);
                    tailSent |= amount < nbSamples;
                    length = Math.max(0, length - amount);
                    remaining -= amount;
                    continue;
                }
                this.rebufferizer.submitVariable(input);
                int fixedLength = this.rebufferizer.getTargetSize();
                float[][] fixed = this.rebufferizer.retrieveFixed();
                while (fixed != null && remaining > 0) {
                    fixed = super.wrapInput(fixed);
                    int amount = Math.min(remaining, fixedLength);
                    if (amount < fixedLength) {
                        lastSent = true;
                    }
                    ((IMultiChanPushEffect)this.processingTarget).process(fixed, amount, this);
                    fixed = this.rebufferizer.retrieveFixed();
                    tailSent |= amount < fixedLength;
                    length = Math.max(0, length - amount);
                    remaining -= amount;
                }
            }
            if (!lastSent) {
                if (this.rebufferizer != null) {
                    float[][] last = new float[nbChans][this.rebufferizer.getTargetSize()];
                    ((IMultiChanPushEffect)this.processingTarget).process(last, 0, this);
                } else {
                    float[][] last = new float[nbChans][nbSamples];
                    ((IMultiChanPushEffect)this.processingTarget).process(last, 0, this);
                }
            }
            this.tailInToPad = 0;
        }
        super.processed(length);
    }

    @Override
    public void stopProcessing() {
        super.stopProcessing();
        this.curSink = null;
    }

    @Override
    public void writeSamples(float[][] samples) {
        int nbChans = samples.length;
        int amount = samples[0].length;
        int c = 0;
        while (c < nbChans) {
            assert (super.isSane(samples[c], false));
            ++c;
        }
        if (this.headOutToSkip >= amount) {
            this.headOutToSkip -= amount;
        } else if (this.headOutToSkip > 0) {
            float[][] head = new float[nbChans][amount - this.headOutToSkip];
            int c2 = 0;
            while (c2 < nbChans) {
                System.arraycopy(samples[c2], this.headOutToSkip, head[c2], 0, head[c2].length);
                ++c2;
            }
            this.curSink.writeSamples(head);
            this.headOutToSkip = 0;
        } else {
            this.curSink.writeSamples(samples);
        }
    }
}

