/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.ISingleChanPullEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IPullEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScPullFromScPull
extends PluginToHostWrapper<IPullEffect>
implements ISingleChanPullEffect,
ISingleChanAudioSource {
    private IPullEffect wrappedTarget;
    private ISingleChanAudioSource curSource;
    private int headOutToSkip;
    private int tailInToPad;
    private int maxOutputLength;

    public ScPullFromScPull(IPlugin baseTarget, IPullEffect processingTarget, IMtContext mtContext, Properties properties) {
        super(baseTarget, processingTarget, ISingleChanPullEffect.class, mtContext, properties);
    }

    private int getChunkLength(IProcessingInfo info) {
        int result = this.getPreferredChunkLength();
        if (result > 0) {
            return result;
        }
        result = info.getHostPreferredChunkLength();
        if (result > 0) {
            return result;
        }
        return 2048;
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.headOutToSkip = super.getLatency(IoDirection.OUTPUT);
        this.tailInToPad = super.getLatency(IoDirection.INPUT);
        this.maxOutputLength = this.getActualMaxChunkLength(info);
        this.wrappedTarget = super.needsRebuffering() || this.headOutToSkip > 0 ? new IPullEffect(info){
            private final float[] buffer;
            private int bufferIndex;
            private int bufferAvailable;
            {
                this.buffer = new float[ScPullFromScPull.this.getChunkLength(iProcessingInfo)];
                this.bufferIndex = this.buffer.length;
            }

            public int process(ISingleChanAudioSource source, float[] output) {
                int outIndex = 0;
                int result = 0;
                while (outIndex < output.length) {
                    if (this.bufferIndex >= this.buffer.length) {
                        this.bufferAvailable = ((IPullEffect)ScPullFromScPull.this.processingTarget).process(source, this.buffer);
                        this.bufferIndex = 0;
                    }
                    int amount = Math.min(output.length - outIndex, this.buffer.length - this.bufferIndex);
                    System.arraycopy(this.buffer, this.bufferIndex, output, outIndex, amount);
                    result += Math.max(0, Math.min(amount, this.bufferAvailable - this.bufferIndex));
                    outIndex += amount;
                    this.bufferIndex += amount;
                }
                return result;
            }

            public boolean canWriteFasterThanRead() {
                return ((IPullEffect)ScPullFromScPull.this.processingTarget).canWriteFasterThanRead();
            }
        } : (IPullEffect)this.processingTarget;
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IPullEffect)this.processingTarget).canWriteFasterThanRead();
    }

    @Override
    public int process(ISingleChanAudioSource source, float[] output) {
        this.beginIfWorth();
        if (output.length > this.maxOutputLength) {
            throw new IllegalArgumentException("Host error: the given array length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        this.curSource = source;
        if (this.headOutToSkip > 0) {
            float[] temp = new float[this.headOutToSkip];
            this.wrappedTarget.process(this, temp);
            this.headOutToSkip = 0;
        }
        int result = this.wrappedTarget.process(this, output);
        assert (this.isSane(output, false));
        return result;
    }

    @Override
    public void stopProcessing() {
        super.stopProcessing();
        this.curSource = null;
        this.wrappedTarget = null;
    }

    @Override
    public int readSamples(float[] target) {
        int result = this.curSource.readSamples(target);
        if (result < target.length && this.tailInToPad > 0) {
            int amount = Math.min(target.length - result, this.tailInToPad);
            Arrays.fill(target, result, result + amount, 0.0f);
            this.tailInToPad -= amount;
            result += amount;
        }
        assert (this.isSane(target, true));
        super.processed(result);
        return result;
    }
}

