/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.FloatQueue;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.ISingleChanPullEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScPullFromScPush
extends PluginToHostWrapper<IPushEffect>
implements ISingleChanPullEffect,
Runnable {
    private final ISingleChanAudioSink sink = new AudioSink();
    private int inputLength;
    private int maxBlockLength;
    private int queueCapacity;
    private int headOutToSkip;
    private int tailInToPad;
    private FloatQueue queue;
    private final Object lock = new Monitor("ScPullFromScPush");
    private ISingleChanAudioSource source;
    private Thread puller;

    public ScPullFromScPush(IPlugin baseTarget, IPushEffect processingTarget, IMtContext mtContext, Properties properties) {
        super(baseTarget, processingTarget, ISingleChanPullEffect.class, mtContext, properties);
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.queue = null;
        this.source = null;
        this.inputLength = this.getActualChunkLength();
        this.maxBlockLength = this.getActualMaxChunkLength(info);
        this.queueCapacity = this.inputLength + this.maxBlockLength;
        this.headOutToSkip = super.getLatency(IoDirection.OUTPUT);
        this.tailInToPad = super.getLatency(IoDirection.INPUT);
        this.puller = new Thread(this);
        this.puller.setName(String.valueOf(this.getName()) + "-Puller");
        this.puller.start();
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IPushEffect)this.processingTarget).canWriteFasterThanRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int process(ISingleChanAudioSource source, float[] output) {
        this.beginIfWorth();
        if (output.length > this.maxBlockLength) {
            throw new IllegalArgumentException("Host error: the given length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        Object object = this.lock;
        synchronized (object) {
            int amount;
            this.source = source;
            if (this.queue == null) {
                this.queue = new FloatQueue(this.queueCapacity);
                this.lock.notify();
            }
            while (this.queue.getSize() < output.length && this.puller != null) {
                this.waitLock();
            }
            int n = amount = this.puller != null ? output.length : Math.min(output.length, this.queue.getSize());
            if (amount > 0) {
                this.queue.popArray(output, 0, amount);
                this.lock.notify();
            }
            return amount;
        }
    }

    @Override
    public void stopProcessing() {
        super.stopProcessing();
        this.queue = null;
        this.source = null;
        this.puller = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            while (this.queue == null) {
                this.waitLock();
            }
        }
        assert (this.source != null);
        boolean eof = false;
        boolean lastBuffer = false;
        float[] buffer = new float[this.inputLength];
        while (!lastBuffer) {
            int amount = eof ? 0 : this.source.readSamples(buffer);
            float[] input = this.wrapInput(buffer);
            if (amount < buffer.length) {
                eof = true;
                if (this.tailInToPad > 0) {
                    int padAmount = Math.min(this.tailInToPad, buffer.length - amount);
                    this.tailInToPad -= padAmount;
                    Arrays.fill(input, amount, buffer.length, 0.0f);
                    if ((amount += padAmount) < buffer.length) {
                        lastBuffer = true;
                    }
                } else {
                    lastBuffer = true;
                }
            }
            ((IPushEffect)this.processingTarget).process(input, amount, this.sink);
            super.processed(amount);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.puller = null;
            this.lock.notify();
        }
    }

    void waitLock() {
        try {
            this.lock.wait();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    class AudioSink
    implements ISingleChanAudioSink {
        AudioSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeSamples(float[] samples) {
            assert (ScPullFromScPush.this.isSane(samples, false));
            int offset = 0;
            while (offset < samples.length) {
                int amount = Math.min(samples.length - offset, ScPullFromScPush.this.maxBlockLength);
                Object object = ScPullFromScPush.this.lock;
                synchronized (object) {
                    if (ScPullFromScPush.this.headOutToSkip >= amount) {
                        ScPullFromScPush scPullFromScPush = ScPullFromScPush.this;
                        scPullFromScPush.headOutToSkip = scPullFromScPush.headOutToSkip - amount;
                    } else if (ScPullFromScPush.this.headOutToSkip > 0) {
                        float[] head = new float[amount - ScPullFromScPush.this.headOutToSkip];
                        System.arraycopy(samples, offset + ScPullFromScPush.this.headOutToSkip, head, 0, head.length);
                        this.push(head, 0, head.length);
                        ScPullFromScPush.this.headOutToSkip = 0;
                    } else {
                        this.push(samples, offset, amount);
                    }
                    ScPullFromScPush.this.lock.notify();
                }
                offset += amount;
            }
        }

        private void push(float[] data, int offset, int length) {
            while (ScPullFromScPush.this.queue.getSize() + length > ScPullFromScPush.this.queueCapacity) {
                ScPullFromScPush.this.waitLock();
            }
            ScPullFromScPush.this.queue.pushArray(data, offset, length);
        }
    }
}

