/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.Rebufferizer;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.ISingleChanPushEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScPushFromScEffect
extends PluginToHostWrapper<ISimpleEffect>
implements ISingleChanPushEffect,
ISingleChanAudioSink {
    private Rebufferizer rebufferizer = null;
    private ISingleChanAudioSink curSink;
    private int maxChunkSize;
    private int headOutToSkip;
    private int tailInToPad;

    public ScPushFromScEffect(IPlugin baseTarget, ISimpleEffect processingTarget, IMtContext mtContext, Properties properties) {
        super(baseTarget, processingTarget, ISingleChanPushEffect.class, mtContext, properties);
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return false;
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.maxChunkSize = this.getActualMaxChunkLength(info);
        if (this.needsRebuffering()) {
            int chunkSize = this.getActualChunkLength();
            this.rebufferizer = new Rebufferizer(this.maxChunkSize, chunkSize);
        } else {
            this.rebufferizer = null;
        }
        this.headOutToSkip = this.getFullLatency(IoDirection.OUTPUT);
        this.tailInToPad = this.getFullLatency(IoDirection.INPUT);
    }

    @Override
    protected boolean needsRebuffering() {
        if (super.needsRebuffering()) {
            return true;
        }
        return super.getLatency(IoDirection.INPUT) > 0 || super.getLatency(IoDirection.OUTPUT) > 0;
    }

    private int getFullLatency(IoDirection ioDirection) {
        if (this.rebufferizer == null) {
            return super.getLatency(ioDirection);
        }
        return super.getLatency(ioDirection) + this.rebufferizer.getLatency();
    }

    @Override
    public void process(float[] input, int length, ISingleChanAudioSink sink) {
        this.beginIfWorth();
        assert (this.isSane(input, true));
        if (length > this.maxChunkSize) {
            throw new IllegalArgumentException("Host error: the given length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        input = super.wrapInput(input);
        this.curSink = sink;
        if (input.length == length) {
            this.process0(input, length);
        } else {
            int amount = Math.min(this.maxChunkSize, length + this.tailInToPad);
            float[] temp = new float[amount];
            System.arraycopy(input, 0, temp, 0, Math.min(length, amount));
            this.process0(temp, amount);
            this.tailInToPad -= amount - length;
            while (this.tailInToPad > 0) {
                amount = Math.min(this.maxChunkSize, this.tailInToPad);
                temp = new float[amount];
                this.process0(temp, amount);
                this.tailInToPad -= amount;
            }
        }
    }

    private void process0(float[] input, int length) {
        if (this.rebufferizer != null) {
            float[] data;
            if (input.length == length) {
                data = input;
            } else {
                data = new float[length];
                System.arraycopy(input, 0, data, 0, length);
            }
            this.rebufferizer.submitVariable(data);
            float[] fixed = this.rebufferizer.retrieveFixed();
            while (fixed != null) {
                ((ISimpleEffect)this.processingTarget).process(fixed);
                this.rebufferizer.submitFixed(fixed);
                fixed = this.rebufferizer.retrieveFixed();
            }
            this.rebufferizer.retrieveVariable(data);
            this.writeSamples(data);
        } else {
            if (length < input.length) {
                Arrays.fill(input, length, input.length, 0.0f);
            }
            ((ISimpleEffect)this.processingTarget).process(input);
            if (length == input.length) {
                this.writeSamples(input);
            } else {
                float[] temp = new float[length];
                System.arraycopy(input, 0, temp, 0, length);
                this.writeSamples(temp);
            }
        }
        super.processed(length);
    }

    @Override
    public void writeSamples(float[] samples) {
        assert (super.isSane(samples, false));
        if (this.headOutToSkip >= samples.length) {
            this.headOutToSkip -= samples.length;
        } else if (this.headOutToSkip > 0) {
            float[] temp = new float[samples.length - this.headOutToSkip];
            System.arraycopy(samples, this.headOutToSkip, temp, 0, temp.length);
            this.curSink.writeSamples(temp);
            this.headOutToSkip = 0;
        } else {
            this.curSink.writeSamples(samples);
        }
    }
}

