/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClockedAsynchronousQueue<E> {
    private final int capacity;
    private final AtomicReferenceArray<E> buffers;
    private final AtomicReferenceArray<Thread> parkedProducers;
    private final AtomicReferenceArray<Thread> parkedConsumers;

    public ClockedAsynchronousQueue(int capacity) {
        this.capacity = capacity;
        this.buffers = new AtomicReferenceArray(capacity);
        this.parkedProducers = new AtomicReferenceArray(capacity);
        this.parkedConsumers = new AtomicReferenceArray(capacity);
    }

    /*
     * Unable to fully structure code
     */
    public void put(long clock, E element) {
        index = (int)(clock % (long)this.capacity);
        try {
            if (this.buffers.compareAndSet(index, null, element)) {
                return;
            }
            success = this.parkedProducers.compareAndSet(index, null, Thread.currentThread());
            if (ClockedAsynchronousQueue.$assertionsDisabled || success) ** GOTO lbl9
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                LockSupport.park();
lbl9:
                // 2 sources

                ** while (!this.buffers.compareAndSet((int)index, null, element))
            }
lbl10:
            // 1 sources

            this.parkedProducers.set(index, null);
        }
        finally {
            waiting = this.parkedConsumers.get(index);
            if (waiting != null) {
                LockSupport.unpark(waiting);
            }
        }
    }

    public E take(long clock) {
        int index = (int)(clock % (long)this.capacity);
        try {
            E result = this.buffers.getAndSet(index, null);
            if (result != null) {
                E e = result;
                return e;
            }
            boolean success = this.parkedConsumers.compareAndSet(index, null, Thread.currentThread());
            assert (success);
            result = this.buffers.getAndSet(index, null);
            while (result == null) {
                LockSupport.park();
                result = this.buffers.getAndSet(index, null);
            }
            this.parkedConsumers.set(index, null);
            E e = result;
            return e;
        }
        finally {
            Thread waiting = this.parkedProducers.get(index);
            if (waiting != null) {
                LockSupport.unpark(waiting);
            }
        }
    }

    public E pollBuffer(long clock) {
        Thread waiting;
        int index = (int)(clock % (long)this.capacity);
        E result = this.buffers.getAndSet(index, null);
        if (result != null && (waiting = this.parkedProducers.get(index)) != null) {
            LockSupport.unpark(waiting);
        }
        return result;
    }
}

