/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.engine.ProcessingInfoBridge;
import ch.tachyon.tunnel.engine.bridges.mthread.IProcessedFramesMonitor;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.SerialSectionPool;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.DebugSerialAccumulator;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.DebugSerialSection;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialAccumulatorEx;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionHandler;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ProfiledSerialAccumulator;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ProfiledSerialSection;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.SerialAccumulatorImpl;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.SerialSectionImpl;
import ch.tachyon.tunnel.engine.utils.ConcurrentHistoryBuffer;
import ch.tachyon.tunnel.engine.utils.PluginDuplicator;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.ILoadUnload;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ITimeLocal;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialAccumulator;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.concurrent.ThreadPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MtBase<E extends IPlugin>
implements IPlugin,
IStartStop,
IBeginProcessing,
ISerialSectionHandler,
IProcessedFramesMonitor {
    private static final int DEFAULT_CHUNK_LENGTH = 2048;
    public static final String DEBUG_PROPERTY = "ch.tachyon.tunnel.debug";
    public static final String PROFILE_PROPERTY = "ch.tachyon.tunnel.profile";
    private static final String READ_SECTION_NAME = "ch.tachyon.tunnel.engine.source.reader";
    private static final String WRITE_SECTION_NAME = "ch.tachyon.tunnel.engine.sink.writer";
    private static final String HISTORY_SECTION_NAME = "ch.tachyon.tunnel.engine.history";
    private final E target;
    private final boolean needsReadSection;
    protected final MtContext mtContext;
    private final Map<Thread, E> pool = new ConcurrentHashMap<Thread, E>(8, 0.75f, 1);
    private int poolSize;
    private int minInputPoolSize = 0;
    protected ThreadPool threadPool;
    protected ISerialSectionExt[] serialSections;
    protected ISerialAccumulatorEx<?>[] serialAccus;
    protected ISerialSectionExt readSection;
    protected ISerialSectionExt writeSection;
    protected int historySize;
    protected int pluginFixedSize;
    protected ConcurrentHistoryBuffer historyBuffer;
    protected ISerialSection historySection;
    protected boolean serialize;
    protected AtomicLong framesCounter;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !MtBase.class.desiredAssertionStatus();
        if (System.getProperty(DEBUG_PROPERTY) != null && !System.getProperty(DEBUG_PROPERTY).equalsIgnoreCase("false")) {
            Debug.warn("Debug mode enabled", new Object[0]);
        }
    }

    protected MtBase(E target, boolean needsReadSection, MtContext mtContext) {
        this.target = target;
        this.needsReadSection = needsReadSection;
        this.mtContext = mtContext;
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        this.setupPool(this.target, info);
    }

    private ISerialSectionExt newSerialSection(String name, Object userData) {
        if (System.getProperty(DEBUG_PROPERTY) != null && !System.getProperty(DEBUG_PROPERTY).equalsIgnoreCase("false")) {
            return new DebugSerialSection(this.threadPool, name, userData);
        }
        if (System.getProperty(PROFILE_PROPERTY) != null && !System.getProperty(PROFILE_PROPERTY).equalsIgnoreCase("false")) {
            return new ProfiledSerialSection(this.threadPool, name, userData);
        }
        return new SerialSectionImpl(this.threadPool, name, userData);
    }

    private <W> ISerialAccumulatorEx<W> newSerialAccu(String name, Object userData) {
        if (System.getProperty(DEBUG_PROPERTY) != null && !System.getProperty(DEBUG_PROPERTY).equalsIgnoreCase("false")) {
            return new DebugSerialAccumulator(name, userData);
        }
        if (System.getProperty(PROFILE_PROPERTY) != null && !System.getProperty(PROFILE_PROPERTY).equalsIgnoreCase("false")) {
            return new ProfiledSerialAccumulator(this.threadPool, name, userData);
        }
        return new SerialAccumulatorImpl(name, userData);
    }

    private void setupPool(E plugin, IProcessingInfo info) {
        final SerialSectionPool ssPool = new SerialSectionPool(this.mtContext);
        this.threadPool = this.mtContext.setupPool();
        if (this.needsReadSection) {
            this.readSection = this.newSerialSection(READ_SECTION_NAME, null);
            ssPool.addSerialSection(READ_SECTION_NAME, this.readSection);
        }
        this.historySize = 0;
        this.serialize = false;
        Set<Thread> threads = this.threadPool.getPoolThreads();
        int index = 0;
        for (Thread thread : threads) {
            E poolPlugin;
            if (index == 0) {
                poolPlugin = plugin;
                if (plugin instanceof IStartStop) {
                    ((IStartStop)plugin).startProcessing(info);
                }
                if (plugin instanceof ITimeLocal) {
                    this.pluginFixedSize = this.getPreferredChunkLength();
                    int pluginChunkSize = this.getActualChunkLength();
                    int hostChunkLength = info.getMaxChunkLength(pluginChunkSize);
                    ITimeLocal tl = (ITimeLocal)plugin;
                    int historySize = tl.getRequiredFramesBefore(info);
                    if (historySize != 0) {
                        if (historySize > 0 && (historySize + hostChunkLength) * 11 / 10 < hostChunkLength * this.mtContext.getActualNbThreads()) {
                            int historyCapacity = historySize + hostChunkLength;
                            this.historyBuffer = new ConcurrentHistoryBuffer(historyCapacity, historyCapacity + pluginChunkSize * this.mtContext.getSerialRunningMaxSkew());
                            this.historySection = this.newSerialSection(HISTORY_SECTION_NAME, this.historyBuffer);
                            ssPool.addSerialSection(HISTORY_SECTION_NAME, this.historySection);
                            this.historySize = historySize;
                            ((ProcessingInfoBridge)info).setTimeLocal(historySize);
                        } else {
                            this.serialize = true;
                            this.historySize = 0;
                        }
                    }
                }
                if (plugin instanceof IHasSerialSections) {
                    final ArrayList accus = new ArrayList();
                    final ArrayList relCapacities = new ArrayList();
                    ((IHasSerialSections)plugin).createSerialSections(new ISerialSectionFactory(){

                        @Override
                        public ISerialSection createSerialSection(String name, Object userData) {
                            ISerialSectionExt ss = MtBase.this.newSerialSection(name, userData);
                            ssPool.addSerialSection(name, ss);
                            return ss;
                        }

                        public <W> ISerialAccumulator<W> createSerialAccumulator(Class<W> workType, String name, Object userData, float relCapacity) {
                            if (relCapacity <= 0.0f || Float.isInfinite(relCapacity) || Float.isNaN(relCapacity)) {
                                throw new IllegalArgumentException("Illegal capacity " + relCapacity);
                            }
                            int capacity = MtBase.this.mtContext.getSerialAccuCapacity();
                            ISerialAccumulatorEx sa = MtBase.this.newSerialAccu(name, userData);
                            accus.add(sa);
                            relCapacities.add(Float.valueOf(relCapacity));
                            sa.init(capacity);
                            ssPool.addSerialAccu(name, sa);
                            return sa;
                        }

                        @Override
                        public void ensureMinInputHistorySize(int value) {
                            MtBase.this.minInputPoolSize = Math.max(MtBase.this.minInputPoolSize, value);
                        }

                        @Override
                        public IMtContext getMtContext() {
                            return MtBase.this.mtContext;
                        }
                    });
                    float remRelative = 0.0f;
                    Iterator historyCapacity = relCapacities.iterator();
                    while (historyCapacity.hasNext()) {
                        float relCap = ((Float)historyCapacity.next()).floatValue();
                        remRelative += relCap;
                    }
                    int stdCapacity = this.mtContext.getSerialAccuCapacity();
                    int remAccus = accus.size();
                    int remCapacity = accus.size() * stdCapacity;
                    int totalCapacity = 0;
                    int i = 0;
                    while (i < accus.size()) {
                        ISerialAccumulatorEx accu = (ISerialAccumulatorEx)accus.get(i);
                        float relCapacity = ((Float)relCapacities.get(i)).floatValue();
                        int absCapacity = (int)(relCapacity * (float)remCapacity / remRelative + 0.5f);
                        if (absCapacity > remCapacity - remAccus + 1) {
                            absCapacity = remCapacity - remAccus + 1;
                        }
                        if (absCapacity < 1) {
                            absCapacity = 1;
                        }
                        accu.init(absCapacity);
                        Debug.info("SerialAccu {0} got capacity {1}", accu.getName(), absCapacity);
                        totalCapacity += absCapacity;
                        remCapacity -= absCapacity;
                        remRelative -= relCapacity;
                        --remAccus;
                        ++i;
                    }
                    if (!$assertionsDisabled && totalCapacity != accus.size() * stdCapacity) {
                        throw new AssertionError();
                    }
                }
                if (this.serialize) {
                    break;
                }
            } else {
                poolPlugin = PluginDuplicator.prepareCopy(plugin, info);
                if (poolPlugin instanceof IStartStop && !(poolPlugin instanceof Cloneable)) {
                    ((IStartStop)poolPlugin).startProcessing(info);
                }
                ssPool.setThreadIndex(index);
                if (poolPlugin instanceof IHasSerialSections) {
                    ((IHasSerialSections)poolPlugin).setSerialSections(ssPool);
                }
            }
            this.pool.put(thread, poolPlugin);
            ++index;
        }
        if (!ssPool.hasSerialAccumulators()) {
            this.writeSection = this.newSerialSection(WRITE_SECTION_NAME, null);
            ssPool.addSerialSection(WRITE_SECTION_NAME, this.writeSection);
        }
        this.serialSections = ssPool.getSerialSections().toArray(new ISerialSectionExt[ssPool.getNbSerialSections()]);
        this.serialAccus = ssPool.getSerialAccus().toArray(new ISerialAccumulatorEx[ssPool.getNbSerialAccus()]);
        this.poolSize = this.pool.size();
    }

    protected int getInputPoolSize(boolean accuMode) {
        if (accuMode) {
            return this.mtContext.getAccuTotalMaxSkew(this.serialAccus.length) + this.minInputPoolSize;
        }
        return this.mtContext.getSerialTotalMaxSkew() + this.minInputPoolSize;
    }

    protected E getBaseTarget() {
        return this.target;
    }

    public int getPreferredChunkLength() {
        if (this.target instanceof IFixedChunkLength) {
            return ((IFixedChunkLength)this.target).getFixedChunkLength();
        }
        return -1;
    }

    protected int getActualChunkLength() {
        int result = this.getPreferredChunkLength();
        if (result < 0) {
            result = 2048;
        }
        return result;
    }

    protected E getProcessingTarget(Thread thread) {
        if (this.poolSize == 1) {
            return this.target;
        }
        return (E)((IPlugin)this.pool.get(thread));
    }

    @Override
    public void setCounter(AtomicLong framesCounter) {
        this.framesCounter = framesCounter;
    }

    @Override
    public void beginProcessing(final IProcessingInfo info) {
        if (this.serialize) {
            if (this.target instanceof IBeginProcessing) {
                ((IBeginProcessing)this.target).beginProcessing(info);
            }
        } else {
            this.threadPool.executeByEachThread(new Runnable(){

                public void run() {
                    Object plugin = MtBase.this.getProcessingTarget(Thread.currentThread());
                    if (plugin instanceof IBeginProcessing) {
                        ((IBeginProcessing)plugin).beginProcessing(info);
                    }
                }
            });
        }
    }

    @Override
    public void stopProcessing() {
        this.flushPool(this.target);
        this.threadPool.executeByEachThread(new Runnable(){

            public void run() {
                Object[] objectArray = MtBase.this.serialSections;
                int n = MtBase.this.serialSections.length;
                int n2 = 0;
                while (n2 < n) {
                    ISerialSectionExt serialSection = objectArray[n2];
                    serialSection.clearClock();
                    ++n2;
                }
                objectArray = MtBase.this.serialAccus;
                n = MtBase.this.serialAccus.length;
                n2 = 0;
                while (n2 < n) {
                    Object serialAccu = objectArray[n2];
                    serialAccu.clearClock();
                    ++n2;
                }
            }
        });
        this.mtContext.releasePool();
        this.threadPool = null;
    }

    private void flushPool(E main) {
        if (this.serialize) {
            if (main instanceof IStartStop) {
                ((IStartStop)main).stopProcessing();
            }
        } else {
            this.threadPool.executeByEachThread(new Runnable(){

                public void run() {
                    IPlugin plugin = (IPlugin)MtBase.this.pool.get(Thread.currentThread());
                    if (plugin instanceof IStartStop) {
                        ((IStartStop)((Object)plugin)).stopProcessing();
                    }
                }
            });
        }
        for (IPlugin plugin : this.pool.values()) {
            if (plugin == main || !(plugin instanceof ILoadUnload)) continue;
            ((ILoadUnload)((Object)plugin)).unload();
        }
        this.pool.clear();
    }
}

