/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.concurrent.ThreadPool;

public class MtContext
implements IMtContext {
    private int nbUsers;
    private int nbThreads;
    private int defaultNbThreads;
    private ThreadPool threadPool;

    synchronized ThreadPool setupPool() {
        if (this.threadPool == null) {
            assert (this.nbUsers == 0);
            this.threadPool = new ThreadPool(this.getActualNbThreads());
        }
        ++this.nbUsers;
        return this.threadPool;
    }

    synchronized void releasePool() {
        --this.nbUsers;
        if (this.nbUsers <= 0) {
            assert (this.nbUsers == 0);
            assert (this.threadPool != null);
            this.threadPool.dispose();
            this.threadPool = null;
        }
    }

    public int getMaxNbThreads() {
        return this.getActualNbThreads();
    }

    public synchronized ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public int getActualNbThreads() {
        if (this.nbThreads <= 0) {
            if (this.defaultNbThreads < 1) {
                String prop = System.getProperty("ch.tachyon.tunnel.threads");
                if (prop != null) {
                    try {
                        int result = Integer.parseInt(prop);
                        if (result >= 1) {
                            this.defaultNbThreads = result;
                            Debug.info("Using {0} threads", result);
                        }
                    }
                    catch (NumberFormatException ex) {
                        Debug.warn("Illegal value for property ch.tachyon.tunnel.threads: {0}", prop);
                    }
                }
                if (this.defaultNbThreads < 1) {
                    this.defaultNbThreads = Runtime.getRuntime().availableProcessors();
                    long maxMemMb = (Runtime.getRuntime().maxMemory() >> 20) - 96L;
                    int maxSupportedCores = (int)Math.max(1L, maxMemMb / 10L);
                    if (this.defaultNbThreads > maxSupportedCores) {
                        Debug.warn("Using only {0} of {1} cores as the allocated memory is limited", maxSupportedCores, this.defaultNbThreads);
                        this.defaultNbThreads = maxSupportedCores;
                    }
                }
            }
            return this.defaultNbThreads;
        }
        return this.nbThreads;
    }

    public boolean isMultiCore() {
        return this.getActualNbThreads() > 1;
    }

    public void setNbThreads(int nbThreads) {
        if (this.threadPool != null) {
            throw new IllegalStateException("Cannot change the number of threads while the pool is in use");
        }
        this.nbThreads = nbThreads;
    }

    public int getSerialRunningMaxSkew() {
        return this.threadPool.getPoolSize();
    }

    public int getSerialTotalMaxSkew() {
        return this.threadPool.getPoolSize() + this.threadPool.getIncommingQueueCapacity();
    }

    public int getSerialAccuCapacity() {
        if (this.threadPool.getPoolSize() <= 1) {
            return 0;
        }
        return this.threadPool.getPoolSize() * 2;
    }

    public int getAccuRunningMaxSkew(int nbSerialAccus) {
        return this.getSerialRunningMaxSkew() + this.getSerialAccuCapacity() * nbSerialAccus;
    }

    public int getAccuTotalMaxSkew(int nbSerialAccus) {
        return this.getSerialTotalMaxSkew() + this.getSerialAccuCapacity() * nbSerialAccus;
    }
}

